/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleSerializer;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;

public class EnumSerializer
extends SimpleSerializer {
    protected static Log log = LogFactory.getLog((String)EnumSerializer.class.getName());
    private Method getValueMethod = null;
    private QName componentTypeQName = null;

    public EnumSerializer(Class clazz, QName qName, QName qName2, QName qName3) {
        super(clazz, qName);
        this.componentTypeQName = qName3;
    }

    public void serialize(QName qName, Attributes attributes, Object object, SerializationContext serializationContext) throws IOException {
        serializationContext.getSerializationWriter().simpleElement(qName, attributes, this.getValueAsString(object, serializationContext));
    }

    public String getValueAsString(Object object, SerializationContext serializationContext) {
        try {
            if (this.getValueMethod == null) {
                try {
                    this.getValueMethod = (Method)AccessController.doPrivileged(new getGetValuePRIV(this.javaType));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
            }
            return super.getValueAsString(this.getValueMethod.invoke(object, null), serializationContext);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.encoding.ser.EnumSerializer.getValueAsString", (String)"136", (Object)this);
            log.error((Object)Messages.getMessage((String)"exception00"), (Throwable)exception);
            return null;
        }
    }

    public String getBuildNumber() {
        return null;
    }

    private class getGetValuePRIV
    implements PrivilegedExceptionAction {
        private Class clazz;

        getGetValuePRIV(Class clazz) {
            this.clazz = clazz;
        }

        public Object run() throws Exception {
            return this.clazz.getMethod("getValue", null);
        }
    }
}

