/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.Serializer;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.schema.SchemaVersion;
import com.ibm.ws.webservices.engine.utils.NullAttributes;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class ArraySerializer
implements Serializer {
    protected static Log log = LogFactory.getLog((String)ArraySerializer.class.getName());
    protected QName xmlType;
    protected Class javaType;
    QName compTypeQName = null;
    QName compQName = null;

    public ArraySerializer(Class clazz, QName qName) {
        this(clazz, qName, null, null);
    }

    public ArraySerializer(Class clazz, QName qName, QName qName2, QName qName3) {
        this.xmlType = qName;
        this.javaType = clazz;
        this.compQName = qName2;
        this.compTypeQName = qName3;
    }

    public void serialize(QName qName, Attributes attributes, Object object, SerializationContext serializationContext) throws IOException {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        boolean bl;
        if (object == null) {
            throw new IOException(Messages.getMessage((String)"cantDoNullArray00"));
        }
        MessageContext messageContext = serializationContext.getMessageContext();
        SchemaVersion schemaVersion = messageContext.getSchemaVersion();
        SOAPConstants sOAPConstants = messageContext.getSOAPConstants();
        Class<?> clazz = object.getClass();
        Collection collection = null;
        if (!clazz.isArray()) {
            if (!(object instanceof Collection)) {
                throw new IOException(Messages.getMessage((String)"cantSerialize00", (String)clazz.getName()));
            }
            collection = (Collection)object;
        }
        QName qName2 = this.compTypeQName != null ? this.compTypeQName : this.getComponentTypeQName(clazz, serializationContext);
        int n = collection == null ? Array.getLength(object) : collection.size();
        int n2 = -1;
        boolean bl2 = this.compQName != null;
        boolean bl3 = !bl2 && qName2.equals(serializationContext.getCurrentXMLType());
        boolean bl4 = bl = !bl2 && !bl3;
        if (bl && object instanceof SOAPElement[]) {
            bl3 = true;
            bl = false;
        }
        if (bl) {
            AttributesImpl attributesImpl;
            Object object6;
            int n3;
            object5 = this.getExtraDims(clazz, qName2, serializationContext);
            object4 = serializationContext.getSerializationWriter().getOrCreatePrefix(qName2.getNamespaceURI(), null, true);
            object3 = ((String)object4).length() > 0 ? (String)object4 + ':' + qName2.getLocalPart() : qName2.getLocalPart();
            object2 = (String)object3 + (String)object5 + "[" + n + "]";
            boolean bl5 = true;
            if (bl5 && !((String)object5).equals("") && clazz.isArray() && n > 0) {
                boolean bl6 = true;
                for (n3 = 0; n3 < n && bl6; ++n3) {
                    object6 = Array.get(object, n3);
                    if (object6 == null) {
                        bl6 = false;
                        continue;
                    }
                    if (n2 < 0) {
                        n2 = Array.getLength(object6);
                        if (n2 > 0) continue;
                        bl6 = false;
                        continue;
                    }
                    if (n2 == Array.getLength(object6)) continue;
                    bl6 = false;
                }
                if (bl6) {
                    object5 = ((String)object5).substring(0, ((String)object5).length() - 2);
                    object2 = (String)object3 + (String)object5 + "[" + n + "," + n2 + "]";
                } else {
                    n2 = -1;
                }
            }
            if ((attributesImpl = attributes == null ? new AttributesImpl() : (attributes instanceof AttributesImpl ? (AttributesImpl)attributes : new AttributesImpl(attributes))).getIndex(sOAPConstants.getEncodingURI(), "arrayType") == -1) {
                String string = serializationContext.getSerializationWriter().getOrCreatePrefix(sOAPConstants.getEncodingURI(), null, true);
                attributesImpl.addAttribute(sOAPConstants.getEncodingURI(), "arrayType", string + ":arrayType", "CDATA", (String)object2);
            }
            if ((n3 = attributesImpl.getIndex(schemaVersion.getXsiURI(), "type")) != -1) {
                object6 = serializationContext.getSerializationWriter().getOrCreatePrefix(schemaVersion.getXsiURI(), "xsi", true) + ":type";
                attributesImpl.setAttribute(n3, schemaVersion.getXsiURI(), "type", (String)object6, "CDATA", serializationContext.getSerializationWriter().qName2String(Constants.SOAP_ARRAY));
            }
            attributes = attributesImpl;
        }
        object5 = qName;
        if (bl || bl2) {
            serializationContext.getSerializationWriter().startElement(qName, attributes);
            object5 = this.compQName == null ? Constants.QNAME_LITERAL_ITEM : this.compQName;
        }
        if (n2 < 0) {
            if (collection == null) {
                for (int i = 0; i < n; ++i) {
                    object3 = Array.get(object, i);
                    serializationContext.serialize((QName)object5, (Attributes)NullAttributes.singleton, object3, qName2, true, Boolean.FALSE);
                }
            } else {
                object4 = collection.iterator();
                while (object4.hasNext()) {
                    object3 = object4.next();
                    serializationContext.serialize((QName)object5, (Attributes)NullAttributes.singleton, object3, qName2, true, Boolean.FALSE);
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    object2 = Array.get(Array.get(object, i), j);
                    serializationContext.serialize((QName)object5, null, object2);
                }
            }
        }
        if (bl || bl2) {
            serializationContext.getSerializationWriter().endElement();
        }
    }

    private final QName getComponentTypeQName(Class clazz, SerializationContext serializationContext) throws IOException {
        Class clazz2;
        if (clazz.isArray()) {
            clazz2 = clazz.getComponentType();
        } else {
            Class clazz3 = clazz2 = Object.class;
        }
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
        }
        QName qName = serializationContext.getTypeMapping().getTypeQName(clazz2);
        if (qName == null) {
            Class clazz4;
            for (clazz4 = clazz2; clazz4 != null && qName == null; clazz4 = clazz4.getSuperclass()) {
                qName = serializationContext.getTypeMapping().getTypeQName(clazz4);
            }
            if (qName != null) {
                clazz2 = clazz4;
            }
        }
        if (qName == null) {
            throw new IOException(Messages.getMessage((String)"noType00", (String)clazz2.getName()));
        }
        return qName;
    }

    private final String getExtraDims(Class clazz, QName qName, SerializationContext serializationContext) {
        String string = "";
        Class clazz2 = clazz.isArray() ? clazz.getComponentType() : Object.class;
        boolean bl = false;
        while (clazz2.isArray() && !serializationContext.getTypeMapping().isRegistered(clazz2, qName)) {
            clazz2 = clazz2.getComponentType();
            string = string + "[]";
        }
        return string;
    }

    public String getMechanismType() {
        return "WebServices SAX Mechanism";
    }

    public String getBuildNumber() {
        return null;
    }
}

