/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt.http;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.srt.http.Ascii;
import java.io.IOException;
import java.io.OutputStream;

public class HttpDate
extends Ascii {
    protected int sec;
    protected int min;
    protected int hour;
    protected int mday;
    protected int mon;
    protected int year;
    protected int wday;
    protected static final byte[][] days = new byte[][]{HttpDate.toBytes("Sunday"), HttpDate.toBytes("Monday"), HttpDate.toBytes("Tuesday"), HttpDate.toBytes("Wednesday"), HttpDate.toBytes("Thursday"), HttpDate.toBytes("Friday"), HttpDate.toBytes("Saturday")};
    protected static final byte[][] months = new byte[][]{HttpDate.toBytes("Jan"), HttpDate.toBytes("Feb"), HttpDate.toBytes("Mar"), HttpDate.toBytes("Apr"), HttpDate.toBytes("May"), HttpDate.toBytes("Jun"), HttpDate.toBytes("Jul"), HttpDate.toBytes("Aug"), HttpDate.toBytes("Sep"), HttpDate.toBytes("Oct"), HttpDate.toBytes("Nov"), HttpDate.toBytes("Dec")};
    protected static byte[] daysInMonth = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    protected static byte[] daysInMonthLeap = new byte[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    protected static short[] daysBeforeMonth = new short[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    protected static short[] daysBeforeMonthLeap = new short[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366};
    private static final String DATESTR = "Sun, 06 Nov 1994 08:49:37 GMT";
    public static final int DATELEN = "Sun, 06 Nov 1994 08:49:37 GMT".length();
    protected static final int DAYS_PER_YEAR = 365;
    protected static final int DAYS_PER_LEAP = 1461;
    protected static final int SECS_PER_MIN = 60;
    protected static final int SECS_PER_HOUR = 3600;
    protected static final int SECS_PER_DAY = 86400;
    protected static final int BASE_DAY_OF_WEEK = 4;

    public HttpDate() {
    }

    public HttpDate(long ms) {
        this.setTime(ms);
    }

    protected static int daysBeforeMonth(int mon, int year) {
        return HttpDate.isLeapYear(year) ? daysBeforeMonthLeap[mon] : daysBeforeMonth[mon];
    }

    protected static int daysInMonth(int mon, int year) {
        return HttpDate.isLeapYear(year) ? daysInMonthLeap[mon] : daysInMonth[mon];
    }

    public int getBytes(byte[] b, int off, int len) {
        if (len < DATELEN) {
            throw new IllegalArgumentException("array too small");
        }
        byte[] t = days[this.wday];
        b[off++] = t[0];
        b[off++] = t[1];
        b[off++] = t[2];
        b[off++] = 44;
        b[off++] = 32;
        b[off++] = (byte)(48 + this.mday / 10);
        b[off++] = (byte)(48 + this.mday % 10);
        b[off++] = 32;
        t = months[this.mon];
        b[off++] = t[0];
        b[off++] = t[1];
        b[off++] = t[2];
        b[off++] = 32;
        int y = this.year + 1900;
        b[off++] = (byte)(48 + y / 1000);
        b[off++] = (byte)(48 + (y %= 1000) / 100);
        b[off++] = (byte)(48 + (y %= 100) / 10);
        b[off++] = (byte)(48 + y % 10);
        b[off++] = 32;
        b[off++] = (byte)(48 + this.hour / 10);
        b[off++] = (byte)(48 + this.hour % 10);
        b[off++] = 58;
        b[off++] = (byte)(48 + this.min / 10);
        b[off++] = (byte)(48 + this.min % 10);
        b[off++] = 58;
        b[off++] = (byte)(48 + this.sec / 10);
        b[off++] = (byte)(48 + this.sec % 10);
        b[off++] = 32;
        b[off++] = 71;
        b[off++] = 77;
        b[off] = 84;
        return DATELEN;
    }

    public static long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public long getTime() {
        int year = this.year;
        int days = (year - 70) * 365;
        days += (year - 69) / 4;
        days -= (year - 1) / 100;
        days += (year + 299) / 400;
        return (long)(this.sec + 60 * (this.min + 60 * (this.hour + 24 * (days += HttpDate.daysBeforeMonth(this.mon, year) + this.mday - 1)))) * 1000L;
    }

    protected static boolean isLeapYear(int year) {
        return (year & 3) == 0 && (year % 100 != 0 || (year + 300) % 400 != 0);
    }

    public void parse(byte[] b, int off, int len) {
        try {
            byte c;
            int end = off + len;
            off = this.parseDay(b, off);
            while (HttpDate.isWhite(c = b[off++])) {
            }
            if (HttpDate.isDigit(c)) {
                int n = c - 48;
                while (HttpDate.isDigit(c = b[off++])) {
                    n = n * 10 + c - 48;
                }
                this.mday = n;
                if (HttpDate.isWhite(c)) {
                    while (HttpDate.isWhite(c = b[off++])) {
                    }
                } else if (c == 45) {
                    c = b[off++];
                } else {
                    throw new IllegalArgumentException();
                }
                off = this.parseMonth(c, b, off);
                if (HttpDate.isWhite(c = b[off++])) {
                    while (HttpDate.isWhite(c = b[off++])) {
                    }
                } else if (c == 45) {
                    c = b[off++];
                } else {
                    throw new IllegalArgumentException();
                }
                if (!HttpDate.isDigit(c)) {
                    throw new IllegalArgumentException();
                }
                n = c - 48;
                while (HttpDate.isDigit(c = b[off++])) {
                    n = n * 10 + c - 48;
                }
                if (n < 100) {
                    n += 1900;
                }
                if (this.mday > HttpDate.daysInMonth(this.mon, n)) {
                    throw new IllegalArgumentException();
                }
                this.year = n - 1900;
                off = this.parseTime(b, off);
                while (HttpDate.isWhite(c = b[off++])) {
                }
                if (HttpDate.toLower(c) != 103 || HttpDate.toLower(b[off++]) != 109 || HttpDate.toLower(b[off++]) != 116) {
                    throw new IllegalArgumentException();
                }
            } else {
                off = this.parseMonth(c, b, off);
                if (!HttpDate.isWhite(c = b[off++])) {
                    throw new IllegalArgumentException();
                }
                while (HttpDate.isWhite(c = b[off++])) {
                }
                if (!HttpDate.isDigit(c)) {
                    throw new IllegalArgumentException();
                }
                int n = c - 48;
                while (HttpDate.isDigit(c = b[off++])) {
                    n = n * 10 + c - 48;
                }
                this.mday = n;
                off = this.parseTime(b, off);
                while (HttpDate.isWhite(c = b[off++])) {
                }
                n = c - 48;
                while (off < end && HttpDate.isDigit(c = b[off++])) {
                    n = n * 10 + c - 48;
                }
                if (n < 1900 || this.mday > HttpDate.daysInMonth(this.mon, n)) {
                    throw new IllegalArgumentException();
                }
                this.year = n - 1900;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.webcontainer.srt.http.HttpDate.parse", (String)"345", (Object)this);
            throw new IllegalArgumentException();
        }
    }

    public void parse(String s) {
        byte[] b = HttpDate.toBytes(s);
        this.parse(b, 0, b.length);
    }

    private int parseDay(byte[] b, int off) {
        byte c;
        while (HttpDate.isWhite(c = b[off++])) {
        }
        int n = HttpDate.toLower(c);
        n = n << 8 | HttpDate.toLower(b[off++]);
        n = n << 8 | HttpDate.toLower(b[off++]);
        switch (n) {
            case 7566702: {
                this.wday = 0;
                break;
            }
            case 7171950: {
                this.wday = 1;
                break;
            }
            case 7632229: {
                this.wday = 2;
                break;
            }
            case 7824740: {
                this.wday = 3;
                break;
            }
            case 7628917: {
                this.wday = 4;
                break;
            }
            case 6713961: {
                this.wday = 5;
                break;
            }
            case 7561588: {
                this.wday = 6;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        c = b[off++];
        if (HttpDate.isAlpha(c)) {
            byte[] day = days[this.wday];
            int len = day.length;
            for (int i = 3; i < len; ++i) {
                if (HttpDate.toLower(c) != day[i]) {
                    throw new IllegalArgumentException();
                }
                c = b[off++];
            }
        }
        if (!HttpDate.isWhite(c) && c != 44) {
            throw new IllegalArgumentException();
        }
        return off;
    }

    private int parseMonth(int c, byte[] b, int off) {
        int n = HttpDate.toLower(c);
        n = n << 8 | HttpDate.toLower(b[off++]);
        n = n << 8 | HttpDate.toLower(b[off++]);
        switch (n) {
            case 6971758: {
                this.mon = 0;
                break;
            }
            case 0x666562: {
                this.mon = 1;
                break;
            }
            case 7168370: {
                this.mon = 2;
                break;
            }
            case 6385778: {
                this.mon = 3;
                break;
            }
            case 7168377: {
                this.mon = 4;
                break;
            }
            case 6976878: {
                this.mon = 5;
                break;
            }
            case 6976876: {
                this.mon = 6;
                break;
            }
            case 6387047: {
                this.mon = 7;
                break;
            }
            case 7562608: {
                this.mon = 8;
                break;
            }
            case 7299956: {
                this.mon = 9;
                break;
            }
            case 7237494: {
                this.mon = 10;
                break;
            }
            case 6579555: {
                this.mon = 11;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return off;
    }

    private int parseTime(byte[] b, int off) {
        byte c;
        while (HttpDate.isWhite(c = b[off++])) {
        }
        if (HttpDate.isDigit(c)) {
            int n = c - 48;
            while (HttpDate.isDigit(c = b[off++])) {
                n = n * 10 + c - 48;
            }
            if (n < 24 && c == 58 && HttpDate.isDigit(c = b[off++])) {
                this.hour = n;
                n = c - 48;
                while (HttpDate.isDigit(c = b[off++])) {
                    n = n * 10 + c - 48;
                }
                if (n < 60 && c == 58 && HttpDate.isDigit(c = b[off++])) {
                    this.min = n;
                    n = c - 48;
                    while (HttpDate.isDigit(c = b[off++])) {
                        n = n * 10 + c - 48;
                    }
                    if (n < 60 && c == 32) {
                        this.sec = n;
                        return off;
                    }
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public void setTime() {
        this.setTime(HttpDate.getCurrentTime());
    }

    public void setTime(long ms) {
        int sec = (int)(ms / 1000L);
        int days = sec / 86400;
        this.hour = (sec -= days * 86400) / 3600;
        this.min = (sec -= this.hour * 3600) / 60;
        this.sec = sec - this.min * 60;
        this.wday = (days + 4) % 7;
        int leaps = days / 1461;
        boolean isLeap = false;
        int year = leaps * 4 + 70;
        if ((days -= leaps * 1461) >= 365) {
            ++year;
            if ((days -= 365) >= 365) {
                ++year;
                if ((days -= 365) >= 366) {
                    ++year;
                    days -= 366;
                } else {
                    isLeap = true;
                }
            }
        }
        this.year = year;
        short[] mdays = isLeap ? daysBeforeMonthLeap : daysBeforeMonth;
        int mon = 1;
        while (mdays[mon] <= days) {
            ++mon;
        }
        this.mon = --mon;
        this.mday = days - mdays[mon] + 1;
    }

    protected static byte[] toBytes(String s) {
        byte[] b = s.getBytes();
        return b;
    }

    public String toString() {
        byte[] b = new byte[DATELEN];
        return new String(b, 0, 0, this.getBytes(b, 0, b.length));
    }

    public void write(OutputStream out) throws IOException {
        byte[] b = new byte[DATELEN];
        out.write(b, 0, this.getBytes(b, 0, b.length));
    }

    public void reset() {
        this.sec = 0;
        this.min = 0;
        this.hour = 0;
        this.mday = 0;
        this.mon = 0;
        this.year = 0;
        this.wday = 0;
    }
}

