/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.request.IRequest;
import com.ibm.websphere.servlet.response.IResponse;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.ws.webcontainer.srt.SRTServletResponse;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import com.ibm.wsspi.webcontainer.servlet.IServletResponse;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SRTConnectionContext
implements Cloneable {
    protected IExtendedRequest _request;
    protected WebAppDispatcherContext _dispatchContext = null;
    private IExtendedResponse _response;
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.srt");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.srt.SRTConnectionContext";

    public SRTConnectionContext() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "SRTConnectionContext", "Constructor");
        }
        this._request = new SRTServletRequest(this);
        this._response = new SRTServletResponse(this);
        this._request.setWebAppDispatcherContext(this._dispatchContext);
    }

    public void prepareForNextConnection(IRequest req, IResponse res) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "prepareForNextConnection", "entry");
        }
        this._request.initForNextRequest(req);
        this._response.initForNextResponse(res);
    }

    public void start() {
        this._response.start();
        this._request.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishConnection() {
        try {
            try {
                this._response.finish();
            }
            catch (Throwable th) {
                FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.webcontainer.srt.SRTConnectionContext.finishConnection", (String)"64", (Object)this);
            }
            try {
                this._request.finish();
            }
            catch (Throwable th) {
                FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.webcontainer.srt.SRTConnectionContext.finishConnection", (String)"74", (Object)this);
                WebAppDispatcherContext dispatchContext = (WebAppDispatcherContext)this._request.getWebAppDispatcherContext();
                dispatchContext.getWebApp().logError("Error while finishing the connection", th);
            }
            this.dispatchContextFinish();
        }
        finally {
            this._request.initForNextRequest(null);
            this._response.initForNextResponse(null);
        }
    }

    protected void dispatchContextFinish() {
        try {
            this._dispatchContext.finish();
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.webcontainer.srt.SRTConnectionContext.dispatchContextFinish", (String)"84", (Object)this);
        }
    }

    public IExtendedRequest getRequest() {
        return this._request;
    }

    public IExtendedResponse getResponse() {
        return this._response;
    }

    protected Object clone(SRTServletRequest clonedRequest, WebAppDispatcherContext clonedDispatchContext) throws CloneNotSupportedException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "clone", " entry");
        }
        SRTConnectionContext clonedConnContext = (SRTConnectionContext)super.clone();
        clonedConnContext._request = clonedRequest;
        clonedConnContext._dispatchContext = clonedDispatchContext;
        if (this._response instanceof IServletResponse) {
            clonedConnContext._response = (IExtendedResponse)((IServletResponse)((Object)this._response)).clone();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "clone", " exit original -->" + this + " cloned -->" + clonedConnContext);
        }
        return clonedConnContext;
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "destroy", " entry");
        }
        this._request.destroy();
        this._response.destroy();
        this._dispatchContext = null;
        this._request = null;
        this._response = null;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "destroy", " exit");
        }
    }

    public void setResponse(IExtendedResponse extResp) {
        this._response = extResp;
    }
}

