/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.extension;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.extension.WebExtensionProcessor;
import com.ibm.ws.webcontainer.servlet.CacheServletWrapper;
import com.ibm.ws.webcontainer.servlet.ServletConfig;
import com.ibm.ws.webcontainer.servlet.exception.NoTargetForURIException;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.WebGroup;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.util.ServletUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class InvokerExtensionProcessor
extends WebExtensionProcessor {
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.extension");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.extension.InvokerExtensionProcessor";
    private static String showCfg = "com.ibm.websphere.examples.ServletEngineConfigDumper";
    protected static final int numSyncObjects = 41;
    private static final Object syncObjectCreationLock = new Object();
    protected static Object[] syncObjects;
    private List patternList = new ArrayList();
    private static final String DEFAULT_MAPPING = "/servlet/*";
    private Map params;
    private static final boolean servletCaseSensitive;
    static HashSet blockedClassesList;
    static boolean doNotServeByClassName;

    private static final Object getSyncObject(String name) {
        int syncIndex = Math.abs(name.hashCode() % 41);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getSyncObject", "grabbed syncObject in position-->[" + syncIndex + "]");
        }
        return syncObjects[syncIndex];
    }

    public InvokerExtensionProcessor(WebApp webApp, HashMap params) {
        super(webApp);
        this.params = params;
        String fileServingExtensions = this.getInitParameter("invoker.patterns");
        if (fileServingExtensions != null) {
            this.patternList = this.parseInvokerExtensions(fileServingExtensions);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "InvokerExtensionProcessor", "URI patterns for invoking servlets =[" + this.patternList + "]");
            }
        } else {
            this.patternList.add(DEFAULT_MAPPING);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "InvokerExtensionProcessor", "Default URI pattern for invoking servlets =[" + this.patternList + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleRequest(ServletRequest req, ServletResponse res) throws Exception {
        boolean failedAddMappingTarget;
        boolean requestHandled;
        IServletWrapper s;
        String invokePath;
        WebAppDispatcherContext dispatchContext;
        HttpServletRequest request;
        block67: {
            block66: {
                block65: {
                    block64: {
                        block63: {
                            block62: {
                                block61: {
                                    block60: {
                                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "InvokerExtensionProcessor handling request");
                                        }
                                        request = (HttpServletRequest)req;
                                        HttpServletResponse response = (HttpServletResponse)res;
                                        dispatchContext = (WebAppDispatcherContext)((IExtendedRequest)ServletUtil.unwrapRequest(request)).getWebAppDispatcherContext();
                                        invokePath = null;
                                        String servletName = null;
                                        s = null;
                                        String reqURI = null;
                                        requestHandled = false;
                                        failedAddMappingTarget = false;
                                        StringBuffer cacheKey = new StringBuffer(req.getServerName());
                                        cacheKey.append(':');
                                        cacheKey.append(req.getServerPort());
                                        try {
                                            Object sc;
                                            String pathInfo;
                                            int index;
                                            boolean isInclude = dispatchContext.isInclude();
                                            if (isInclude) {
                                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "InvokerExtensionProcessor is called from include so use request attributes");
                                                }
                                                servletName = (String)request.getAttribute("javax.servlet.include.path_info");
                                                reqURI = (String)request.getAttribute("javax.servlet.include.request_uri");
                                            } else {
                                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "InvokerExtensionProcessor called directly or from forward.");
                                                }
                                                servletName = request.getPathInfo();
                                                reqURI = request.getRequestURI();
                                            }
                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "before stripping /servlet/, servletName-->[" + servletName + "], reqURI-->[" + reqURI + "]");
                                            }
                                            if (servletName == null) throw new NoTargetForURIException("/servlet/null");
                                            if ((servletName = WebGroup.stripURL(servletName)) == null) {
                                                throw new NoTargetForURIException("/servlet/null");
                                            }
                                            if (servletName.charAt(0) == '/') {
                                                servletName = servletName.substring(1);
                                            }
                                            if ((index = servletName.indexOf("/")) != -1) {
                                                servletName = servletName.substring(0, index);
                                            }
                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "after stripping /servlet/, servletName-->[" + servletName + "]");
                                            }
                                            if (servletName.length() == 0) {
                                                throw new NoTargetForURIException("/servlet/" + servletName);
                                            }
                                            if (servletName.equals(showCfg)) {
                                                response.sendError(404, MessageFormat.format(nls.getString("Servlet.Not.Found.{0}", "Servlet Not Found: {0}"), servletName));
                                                Object var25_15 = null;
                                                break block60;
                                            }
                                            if (doNotServeByClassName) {
                                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Checking if " + servletName + " is on the blockedClassesList");
                                                }
                                                if (blockedClassesList.contains(servletName)) {
                                                    logger.logp(Level.WARNING, CLASS_NAME, "handleRequest", MessageFormat.format(nls.getString("servlet.on.blocked.list.{0}", "Servlet on the blocked list: {0}"), servletName));
                                                    response.sendError(404, MessageFormat.format(nls.getString("Servlet.Not.Found.{0}", "Servlet Not Found: {0}"), servletName));
                                                    break block61;
                                                }
                                            }
                                            if (isInclude) {
                                                invokePath = (String)request.getAttribute("javax.servlet.include.servlet_path");
                                                pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
                                            } else {
                                                invokePath = request.getServletPath();
                                                pathInfo = request.getPathInfo();
                                            }
                                            if (pathInfo != null) {
                                                int ind = pathInfo.indexOf(servletName);
                                                invokePath = invokePath + pathInfo.substring(0, ind += servletName.length());
                                                pathInfo = pathInfo.substring(ind);
                                            }
                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "after parsing servletName from request elements, invokePath -->[" + invokePath + "], pathInfo-->[" + pathInfo + "]");
                                            }
                                            dispatchContext.setPathElements(invokePath, pathInfo);
                                            cacheKey.append(reqURI);
                                            CacheServletWrapper cWrapper = WebContainer.getFromCache(cacheKey);
                                            if (cWrapper != null) {
                                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "InvokerExtensionProcessor found cacheServletWrapper");
                                                }
                                                cWrapper.handleRequest(request, response);
                                                break block62;
                                            }
                                            if (((WebApp)this.extensionContext).isInternalServlet(servletName)) {
                                                response.sendError(404, MessageFormat.format(nls.getString("Servlet.Not.Found.{0}", "Servlet Not Found: {0}"), servletName));
                                                break block63;
                                            }
                                            s = ((WebApp)this.extensionContext).getServletWrapper(servletName);
                                            if (s != null) {
                                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "found servletWrapper already in the webApp for -->[" + servletName + "]");
                                                }
                                                s.handleRequest(request, response);
                                                requestHandled = true;
                                                break block64;
                                            }
                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Couldn't find servletWrapper, traverse servletInfos or create servletWrapper");
                                            }
                                            Iterator i = ((WebApp)this.extensionContext).getConfiguration().getServletInfos();
                                            while (i.hasNext()) {
                                                String realName;
                                                sc = (ServletConfig)i.next();
                                                String className = ((ServletConfig)sc).getClassName();
                                                if (className == null || !(servletCaseSensitive ? className.equals(servletName) : className.equalsIgnoreCase(servletName))) continue;
                                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "className for current ServletConfig is [" + className + "]");
                                                }
                                                if ((s = ((WebApp)this.extensionContext).getServletWrapper(realName = ((ServletConfig)sc).getServletName())) != null) {
                                                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "found servletWrapper for real servlet name -->[" + realName + "], handle the request");
                                                    }
                                                    s.handleRequest(request, response);
                                                    requestHandled = true;
                                                    break block65;
                                                }
                                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "unable to retrieve a servlet wrapper even though the class names matched");
                                                }
                                                response.sendError(404, MessageFormat.format(nls.getString("Servlet.Not.Found.{0}", "Servlet Not Found: {0}"), servletName));
                                                requestHandled = false;
                                                break block66;
                                            }
                                            if (syncObjects == null) {
                                                sc = syncObjectCreationLock;
                                                synchronized (sc) {
                                                    if (syncObjects == null) {
                                                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Sync objects are being intialized for synchronization during creation of servlet wrappers.");
                                                        }
                                                        syncObjects = new Object[41];
                                                        for (int k = 0; k < 41; ++k) {
                                                            InvokerExtensionProcessor.syncObjects[k] = new Object();
                                                        }
                                                    }
                                                }
                                            }
                                            sc = InvokerExtensionProcessor.getSyncObject(invokePath);
                                            synchronized (sc) {
                                                s = ((WebApp)this.extensionContext).getServletWrapper(servletName);
                                                if (s == null) {
                                                    IServletConfig sconfig = this.createConfig("Invoked_" + System.currentTimeMillis());
                                                    sconfig.setServletName(servletName);
                                                    sconfig.setDisplayName(servletName);
                                                    sconfig.setClassName(servletName);
                                                    sconfig.setStartUpWeight(new Integer(1));
                                                    sconfig.setServletContext(((WebApp)this.extensionContext).getFacade());
                                                    sconfig.setIsJsp(false);
                                                    try {
                                                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "InvokerExtensionProcessor will create a servlet wrapper");
                                                        }
                                                        s = this.createServletWrapper(sconfig);
                                                        WebAppConfiguration wConfig = (WebAppConfiguration)this.extensionContext.getWebAppConfig();
                                                        ServletConfig internalSConfig = (ServletConfig)sconfig;
                                                        wConfig.addServletInfo(servletName, internalSConfig);
                                                        ((ServletConfig)sconfig).addMapping(invokePath);
                                                        wConfig.addServletMapping(servletName, invokePath);
                                                        try {
                                                            this.extensionContext.addMappingTarget(invokePath + "/*", s);
                                                        }
                                                        catch (Exception e2) {
                                                            failedAddMappingTarget = true;
                                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Error adding mapping Target", e2);
                                                            }
                                                        }
                                                    }
                                                    catch (Throwable t) {
                                                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "exception caught creating servlet wrapper or adding mapping", t);
                                                        }
                                                        requestHandled = false;
                                                        throw new ServletException("Initialization Error :" + t.getMessage());
                                                    }
                                                }
                                                if (s == null) break block67;
                                            }
                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Handle the request and add a mapping target for the created servletWrapper.");
                                            }
                                            try {
                                                s.handleRequest(request, response);
                                                requestHandled = true;
                                                break block67;
                                            }
                                            catch (Exception e) {
                                                if (!TraceComponent.isAnyTracingEnabled()) throw e;
                                                if (!logger.isLoggable(Level.FINE)) throw e;
                                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Error handling request in InvokerExtensionProcessor created servletWrapper", e);
                                                throw e;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Object var25_23 = null;
                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "About to add to cache, servletWrapper-->[" + s + "], requestHandled-->" + requestHandled + "]");
                                            }
                                            if (dispatchContext.isInclude()) throw throwable;
                                            if (dispatchContext.isForward()) throw throwable;
                                            if (s == null) throw throwable;
                                            if (invokePath == null) throw throwable;
                                            if (!requestHandled) throw throwable;
                                            if (failedAddMappingTarget) throw throwable;
                                            WebContainer.addToCache(request, s, (WebApp)this.extensionContext);
                                            throw throwable;
                                        }
                                    }
                                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "About to add to cache, servletWrapper-->[" + s + "], requestHandled-->" + requestHandled + "]");
                                    }
                                    if (dispatchContext.isInclude()) return;
                                    if (dispatchContext.isForward()) return;
                                    if (s == null) return;
                                    if (invokePath == null) return;
                                    if (!requestHandled) return;
                                    if (failedAddMappingTarget) return;
                                    WebContainer.addToCache(request, s, (WebApp)this.extensionContext);
                                    return;
                                }
                                Object var25_16 = null;
                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "About to add to cache, servletWrapper-->[" + s + "], requestHandled-->" + requestHandled + "]");
                                }
                                if (dispatchContext.isInclude()) return;
                                if (dispatchContext.isForward()) return;
                                if (s == null) return;
                                if (invokePath == null) return;
                                if (!requestHandled) return;
                                if (failedAddMappingTarget) return;
                                WebContainer.addToCache(request, s, (WebApp)this.extensionContext);
                                return;
                            }
                            Object var25_17 = null;
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "About to add to cache, servletWrapper-->[" + s + "], requestHandled-->" + requestHandled + "]");
                            }
                            if (dispatchContext.isInclude()) return;
                            if (dispatchContext.isForward()) return;
                            if (s == null) return;
                            if (invokePath == null) return;
                            if (!requestHandled) return;
                            if (failedAddMappingTarget) return;
                            WebContainer.addToCache(request, s, (WebApp)this.extensionContext);
                            return;
                        }
                        Object var25_18 = null;
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "About to add to cache, servletWrapper-->[" + s + "], requestHandled-->" + requestHandled + "]");
                        }
                        if (dispatchContext.isInclude()) return;
                        if (dispatchContext.isForward()) return;
                        if (s == null) return;
                        if (invokePath == null) return;
                        if (!requestHandled) return;
                        if (failedAddMappingTarget) return;
                        WebContainer.addToCache(request, s, (WebApp)this.extensionContext);
                        return;
                    }
                    Object var25_19 = null;
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "About to add to cache, servletWrapper-->[" + s + "], requestHandled-->" + requestHandled + "]");
                    }
                    if (dispatchContext.isInclude()) return;
                    if (dispatchContext.isForward()) return;
                    if (s == null) return;
                    if (invokePath == null) return;
                    if (!requestHandled) return;
                    if (failedAddMappingTarget) return;
                    WebContainer.addToCache(request, s, (WebApp)this.extensionContext);
                    return;
                }
                Object var25_20 = null;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "About to add to cache, servletWrapper-->[" + s + "], requestHandled-->" + requestHandled + "]");
                }
                if (dispatchContext.isInclude()) return;
                if (dispatchContext.isForward()) return;
                if (s == null) return;
                if (invokePath == null) return;
                if (!requestHandled) return;
                if (failedAddMappingTarget) return;
                WebContainer.addToCache(request, s, (WebApp)this.extensionContext);
                return;
            }
            Object var25_21 = null;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "About to add to cache, servletWrapper-->[" + s + "], requestHandled-->" + requestHandled + "]");
            }
            if (dispatchContext.isInclude()) return;
            if (dispatchContext.isForward()) return;
            if (s == null) return;
            if (invokePath == null) return;
            if (!requestHandled) return;
            if (failedAddMappingTarget) return;
            WebContainer.addToCache(request, s, (WebApp)this.extensionContext);
            return;
        }
        Object var25_22 = null;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "About to add to cache, servletWrapper-->[" + s + "], requestHandled-->" + requestHandled + "]");
        }
        if (dispatchContext.isInclude()) return;
        if (dispatchContext.isForward()) return;
        if (s == null) return;
        if (invokePath == null) return;
        if (!requestHandled) return;
        if (failedAddMappingTarget) return;
        WebContainer.addToCache(request, s, (WebApp)this.extensionContext);
    }

    public List getPatternList() {
        return this.patternList;
    }

    private String getInitParameter(String param) {
        return (String)this.params.get(param);
    }

    private List parseInvokerExtensions(String exts) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(exts, ": ;");
        while (st.hasMoreTokens()) {
            String ext = st.nextToken();
            if (ext.equals("/")) {
                ext = "/*";
            }
            if (this.patternList.contains(ext)) continue;
            list.add(ext);
        }
        return list;
    }

    static {
        servletCaseSensitive = WCCustomProperties.SERVLET_CASE_SENSITIVE;
        doNotServeByClassName = false;
        if (WCCustomProperties.DO_NOT_SERVE_BY_CLASSNAME != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "InvokerExtensionProcessor", "doNotServeByClassName set to true");
            }
            doNotServeByClassName = true;
            String blockedClasses = WCCustomProperties.DO_NOT_SERVE_BY_CLASSNAME;
            StringTokenizer tokenizedBlockedClasses = new StringTokenizer(blockedClasses, "; \t\n\r\f");
            blockedClassesList = new HashSet(tokenizedBlockedClasses.countTokens());
            while (tokenizedBlockedClasses.hasMoreTokens()) {
                String classToBlock = tokenizedBlockedClasses.nextToken();
                if (classToBlock.equals("*")) {
                    logger.logp(Level.WARNING, CLASS_NAME, "handleRequest", nls.getString("filtering.by.asterisk", "Filtering by asterisk is not allowed."));
                }
                blockedClassesList.add(classToBlock);
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                logger.logp(Level.FINE, CLASS_NAME, "InvokerExtensionProcessor", "Added " + classToBlock + " to blockedClassesList.");
            }
        }
    }
}

