/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.extension;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.FileSystem;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.extension.WebExtensionProcessor;
import com.ibm.ws.webcontainer.filter.WebAppFilterManager;
import com.ibm.ws.webcontainer.servlet.FileServletWrapper;
import com.ibm.ws.webcontainer.servlet.ZipFileServletWrapper;
import com.ibm.ws.webcontainer.util.ExtendedDocumentRootUtils;
import com.ibm.ws.webcontainer.util.UnsynchronizedStack;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.WebAppErrorReport;
import com.ibm.wsspi.webcontainer.IPlatformHelper;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import com.ibm.wsspi.webcontainer.collaborator.CollaboratorInvocationEnum;
import com.ibm.wsspi.webcontainer.collaborator.ICollaboratorHelper;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppNameSpaceCollaborator;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppSecurityCollaborator;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.metadata.WebComponentMetaData;
import com.ibm.wsspi.webcontainer.security.SecurityViolationException;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.util.ServletUtil;
import com.ibm.wsspi.webcontainer.util.URIMatcher;
import com.ibm.wsspi.webcontainer.webapp.NamespaceInvoker;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class DefaultExtensionProcessor
extends WebExtensionProcessor
implements NamespaceInvoker,
Servlet {
    public static final String PARAM_DEFAULT_PAGE = "default.page";
    public static final String PARAM_BUFFER_SIZE = "bufferSize";
    public static final String WEB_INF_DIR = "WEB-INF/";
    public static final String META_INF_DIR = "META-INF/";
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.extension");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.extension.DefaultExtensionProcessor";
    private int defaultBufferSize = 4096;
    private String esiControl = null;
    String extendedDocumentRoot = null;
    private static final String DEFAULT_MAPPING = "/*";
    protected List patternList = new ArrayList();
    private static int optimizeFileServingSizeGlobal;
    private int optimizeFileServingSize = 1000000;
    private static final List DEFAULT_DENY_EXTENSIONS;
    protected URIMatcher denyPatterns = null;
    protected boolean redirectToWelcomeFile = false;
    protected WebComponentMetaData cmd;
    protected IPlatformHelper platformHelper;
    private Map params;
    protected List welcomeFileList;
    protected WebApp _webapp;
    private ICollaboratorHelper collabHelper;
    private IWebAppNameSpaceCollaborator webAppNameSpaceCollab;
    private IWebAppSecurityCollaborator secCollab;
    private boolean exposeWebInfOnDispatch;

    public DefaultExtensionProcessor(IServletContext webapp, HashMap params) {
        super(webapp);
        this._webapp = (WebApp)webapp;
        this.params = params;
        this.collabHelper = this._webapp.getCollaboratorHelper();
        this.webAppNameSpaceCollab = this.collabHelper.getWebAppNameSpaceCollaborator();
        this.secCollab = this.collabHelper.getSecurityCollaborator();
        this.platformHelper = WebContainer.getWebContainer().getPlatformHelper();
        this.welcomeFileList = (List)webapp.getAttribute(WebApp.WELCOME_FILE_LIST);
        this.init();
    }

    private void init() {
        List list;
        String fileServingExtensionsDenied;
        String stringBufferSize;
        this.exposeWebInfOnDispatch = WCCustomProperties.EXPOSE_WEB_INF_ON_DISPATCH;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "init", "exposeWebInfOnDispatch ---> true");
        }
        if ((stringBufferSize = this.getInitParameter(PARAM_BUFFER_SIZE)) != null) {
            try {
                int tempBufferSize;
                this.defaultBufferSize = tempBufferSize = Integer.parseInt(stringBufferSize);
            }
            catch (NumberFormatException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.webcontainer.servlet.SimpleFileServlet.init", (String)"65", (Object)this);
            }
        }
        this.extendedDocumentRoot = this.getInitParameter("extendedDocumentRoot");
        String fileServingExtensions = this.getInitParameter("file.serving.patterns.allow");
        if (fileServingExtensions != null) {
            this.patternList = this.parseFileServingExtensions(fileServingExtensions);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "init", "URI patterns for FileServing =[" + this.patternList + "]");
            }
        } else {
            this.patternList.add(DEFAULT_MAPPING);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "init", "Default URI pattern for FileServing =[" + this.patternList + "]");
            }
        }
        if ((fileServingExtensionsDenied = this.getInitParameter("file.serving.patterns.deny")) != null) {
            list = this.parseFileServingExtensions(fileServingExtensionsDenied);
            list.addAll(DEFAULT_DENY_EXTENSIONS);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "init", "Denied URI patterns for FileServing =[" + list + "]");
            }
            this.denyPatterns = this.createURIMatcher(list);
        } else {
            list = DEFAULT_DENY_EXTENSIONS;
            this.denyPatterns = this.createURIMatcher(list);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "init", "Default denied patterns for FileServing =[" + list + "]");
            }
        }
        String esiTimeout = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperties().getProperty("com.ibm.servlet.file.esi.timeOut", "300");
            }
        });
        if (!esiTimeout.equals("0")) {
            this.esiControl = "max-age=" + esiTimeout + "," + "cacheid=\"URL\"," + "content=\"ESI/1.0+\"";
        }
        this.esiControl = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperties().getProperty("com.ibm.servlet.file.esi.control", DefaultExtensionProcessor.this.esiControl);
            }
        });
        String redirectToWelcomeFileStr = this.getInitParameter("redirectToWelcomeFile");
        if (redirectToWelcomeFileStr != null) {
            this.redirectToWelcomeFile = redirectToWelcomeFileStr.equalsIgnoreCase("true");
        }
        this.optimizeFileServingSize = this.getFileServingIntegerAttribute("com.ibm.ws.webcontainer.optimizefileservingsize", optimizeFileServingSizeGlobal);
    }

    private int getFileServingIntegerAttribute(String attributeKey, int defaultValue) {
        int integerAttribute;
        block5: {
            integerAttribute = defaultValue;
            try {
                String integerAttributeStr;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getFileServingIntegerAttribute", "attributeKey->" + attributeKey);
                }
                if ((integerAttributeStr = this.getInitParameter(attributeKey)) != null) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "getFileServingIntegerAttribute", "integerAttributeStr->" + integerAttributeStr);
                    }
                    integerAttribute = Integer.valueOf(integerAttributeStr);
                }
            }
            catch (NumberFormatException nfe) {
                FFDCFilter.processException((Throwable)nfe, (String)"com.ibm.ws.webcontainer.extension.DefaultExtensionProcessor.init", (String)"65", (Object)this);
                if (!logger.isLoggable(Level.SEVERE)) break block5;
                logger.logp(Level.SEVERE, CLASS_NAME, "getFileServingIntegerAttribute", "init : NumberFormatException for file size at which you switch to optimized file serving");
            }
        }
        return integerAttribute;
    }

    private String getInitParameter(String param) {
        return (String)this.params.get(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleRequest(ServletRequest request, ServletResponse response) throws Exception {
        boolean fileNotFoundExceptionThrown;
        UnsynchronizedStack<Object> securityPreInvokes;
        Object cred;
        block167: {
            block166: {
                block165: {
                    block164: {
                        block162: {
                            block161: {
                                block160: {
                                    block159: {
                                        cred = null;
                                        securityPreInvokes = new UnsynchronizedStack<Object>();
                                        HttpServletRequest req = (HttpServletRequest)request;
                                        HttpServletResponse resp = (HttpServletResponse)response;
                                        StringBuffer path = null;
                                        WebAppDispatcherContext dispatchContext = null;
                                        String pathInfo = null;
                                        fileNotFoundExceptionThrown = false;
                                        try {
                                            try {
                                                Java2SecurityFile caseFile;
                                                Java2SecurityFile file;
                                                String fileSystemPath;
                                                WebApp context;
                                                boolean isInclude;
                                                block168: {
                                                    String string;
                                                    block169: {
                                                        block163: {
                                                            ExtendedDocumentRootUtils extDocRoot;
                                                            block170: {
                                                                IExtendedRequest wasreq = (IExtendedRequest)ServletUtil.unwrapRequest(request);
                                                                dispatchContext = (WebAppDispatcherContext)wasreq.getWebAppDispatcherContext();
                                                                this.webAppNameSpaceCollab.preInvoke(this.cmd);
                                                                securityPreInvokes.push(this.secCollab.preInvoke(req, resp, null, false));
                                                                if (this.platformHelper.isSyncToThreadPlatform() && this._webapp.getConfiguration().isSyncToThreadEnabled()) {
                                                                    cred = this.platformHelper.securityIdentityPush();
                                                                }
                                                                isInclude = false;
                                                                context = this._webapp;
                                                                fileSystemPath = null;
                                                                path = new StringBuffer();
                                                                String servletPath = null;
                                                                if (req.getAttribute("javax.servlet.include.request_uri") != null) {
                                                                    isInclude = true;
                                                                    servletPath = (String)req.getAttribute("javax.servlet.include.servlet_path");
                                                                    pathInfo = (String)req.getAttribute("javax.servlet.include.path_info");
                                                                } else {
                                                                    servletPath = req.getServletPath();
                                                                    pathInfo = req.getPathInfo();
                                                                }
                                                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "servletPath [" + servletPath + "] pathInfo [" + pathInfo + "]");
                                                                }
                                                                path.append(servletPath);
                                                                if (pathInfo != null) {
                                                                    int semicolon = pathInfo.indexOf(59);
                                                                    if (semicolon != -1) {
                                                                        pathInfo = pathInfo.substring(0, semicolon);
                                                                    }
                                                                    path.append(pathInfo);
                                                                    String tempPathInfo = this.removeLeadingSlashes(pathInfo);
                                                                    if (tempPathInfo != null) {
                                                                        if (!this.exposeWebInfOnDispatch || !tempPathInfo.startsWith(WEB_INF_DIR)) {
                                                                            pathInfo = tempPathInfo;
                                                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", " stripping leading slashes pathInfo ---> " + pathInfo);
                                                                            }
                                                                        }
                                                                        if (pathInfo.startsWith(WEB_INF_DIR) || pathInfo.startsWith(META_INF_DIR)) {
                                                                            resp.sendError(403, MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), path.toString()));
                                                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Forbidden-WEB-INF/META-INF");
                                                                            }
                                                                            Object var27_26 = null;
                                                                            if (this.platformHelper.isSyncToThreadPlatform() && this._webapp.getConfiguration().isSyncToThreadEnabled()) {
                                                                                this.platformHelper.securityIdentityPop(cred);
                                                                            }
                                                                            break block159;
                                                                        }
                                                                    }
                                                                }
                                                                if (!(fileSystemPath = context.getRealPath(path.toString())).endsWith(File.separator)) {
                                                                    fileSystemPath = fileSystemPath + File.separator;
                                                                }
                                                                if (!this.isValidFilePath(fileSystemPath)) {
                                                                    resp.sendError(403, nls.getString("File.name.contains.illegal.character", "File path contains illegal character."));
                                                                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Forbidden-invalid file path");
                                                                    }
                                                                    break block160;
                                                                }
                                                                Object matchedURI = this.denyPatterns.match(path.toString());
                                                                if (matchedURI != null) {
                                                                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Attempted to serve URI that matches denied URL pattern URI =[" + path.toString() + "] matched [" + matchedURI + "]");
                                                                    }
                                                                    resp.sendError(403, MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), path.toString()));
                                                                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Forbidden-denied pattern");
                                                                    }
                                                                    break block161;
                                                                }
                                                                file = new Java2SecurityFile(fileSystemPath);
                                                                if (((File)file).exists()) break block168;
                                                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "file does not exist --> " + file.getPath());
                                                                }
                                                                if (this.extendedDocumentRoot == null) break block169;
                                                                extDocRoot = new ExtendedDocumentRootUtils(context, this.extendedDocumentRoot);
                                                                extDocRoot.handleExtendedDocumentRoots(path.toString());
                                                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Extended doc root --> " + extDocRoot.toString());
                                                                }
                                                                if (this.isRequestForbidden(path)) {
                                                                    resp.sendError(403, MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), req.getPathInfo()));
                                                                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Forbidden-Extended doc root endsWith");
                                                                    }
                                                                    break block162;
                                                                }
                                                                if (extDocRoot.getMatchedZipFile() == null) break block170;
                                                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Extended doc root: Use ZipFileServletWrapper");
                                                                }
                                                                ZipFileServletWrapper zfwrapper = this.getZipFileWrapper(this._webapp, this, extDocRoot.getMatchedZipFile(), extDocRoot.getMatchedEntry());
                                                                zfwrapper.handleRequest(req, resp);
                                                                if (!this._webapp.isCachingEnabled()) {
                                                                    try {
                                                                        this._webapp.addMappingTarget(path.toString(), zfwrapper);
                                                                        if (!dispatchContext.isInclude() && !dispatchContext.isForward()) {
                                                                            WebContainer.addToCache(req, zfwrapper, this._webapp);
                                                                        }
                                                                        break block163;
                                                                    }
                                                                    catch (Exception e) {}
                                                                }
                                                                break block163;
                                                            }
                                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Extended doc root: Use FileSevletWrapper");
                                                            }
                                                            FileServletWrapper fwrapper = this.getStaticFileWrapper(this._webapp, this, extDocRoot.getMatchedFile());
                                                            fwrapper.handleRequest(req, resp);
                                                            if (!this._webapp.isCachingEnabled()) {
                                                                try {
                                                                    this._webapp.addMappingTarget(path.toString(), fwrapper);
                                                                    if (!dispatchContext.isInclude() && !dispatchContext.isForward()) {
                                                                        WebContainer.addToCache(req, fwrapper, this._webapp);
                                                                    }
                                                                }
                                                                catch (Exception e) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                        }
                                                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Extended doc root processing");
                                                        }
                                                        break block164;
                                                    }
                                                    if (path.toString().indexOf(WebApp.DIR_BROWSING_MAPPING) != -1) {
                                                        string = "Directory browsing not enabled";
                                                        throw new FileNotFoundException(string);
                                                    }
                                                    string = path.toString();
                                                    throw new FileNotFoundException(string);
                                                }
                                                if (((File)file).isDirectory()) {
                                                    RequestDispatcher dirBrowse;
                                                    String requestString;
                                                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "file is a directory --> " + file.getPath());
                                                    }
                                                    if (!(requestString = this.getURLWithRequestURIEncoded(req).toString()).endsWith("/") && !isInclude) {
                                                        String tmpURL = requestString + "/";
                                                        String qString = req.getQueryString();
                                                        if (qString != null) {
                                                            tmpURL = tmpURL + "?" + qString;
                                                        }
                                                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "sendRedirect -->" + tmpURL);
                                                        }
                                                        resp.sendRedirect(resp.encodeRedirectURL(tmpURL));
                                                        break block165;
                                                    }
                                                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "calling security check for URI --> " + path.toString());
                                                    }
                                                    securityPreInvokes.push(this.secCollab.preInvoke(req, resp, path.toString(), dispatchContext.isEnforceSecurity()));
                                                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "returned from security check for URI --> " + path.toString());
                                                    }
                                                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                                                        logger.logp(Level.FINEST, CLASS_NAME, "handleRequest", "(isInclude,isForward):(" + dispatchContext.isInclude() + "," + dispatchContext.isForward() + ")");
                                                    }
                                                    if (!dispatchContext.isInclude() && !dispatchContext.isForward()) {
                                                        dispatchContext.setFireRequestEvents(true);
                                                    }
                                                    String welcomeFileRedirectUri = null;
                                                    String welcomeFileForwardUri = null;
                                                    if (this.welcomeFileList != null && this.welcomeFileList.size() != 0) {
                                                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Check welcome file list");
                                                        }
                                                        Iterator e = this.welcomeFileList.iterator();
                                                        String page = null;
                                                        while (e.hasNext()) {
                                                            boolean available;
                                                            RequestProcessor rp;
                                                            page = (String)e.next();
                                                            if (page.charAt(0) == '/') {
                                                                page = page.substring(1);
                                                            }
                                                            if ((rp = this._webapp.getRequestMapper().map(path.toString() + page)) == null) {
                                                                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                                                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "No request processor found for welcome file:" + path.toString() + page);
                                                                continue;
                                                            }
                                                            if (rp instanceof WebExtensionProcessor) {
                                                                available = ((WebExtensionProcessor)rp).isAvailable(path.toString() + page);
                                                                if (!available) {
                                                                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                                                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "No web extension processor found for welcome file:" + path.toString() + page);
                                                                    continue;
                                                                }
                                                            } else if (rp instanceof IServletWrapper && !(available = ((IServletWrapper)rp).isAvailable())) {
                                                                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                                                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "No servlet wrapper found for welcome file:" + path.toString() + page);
                                                                continue;
                                                            }
                                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Process welcome file:" + path.toString() + page);
                                                            }
                                                            if (this.redirectToWelcomeFile) {
                                                                String rPath;
                                                                String qString = "";
                                                                if (req.getQueryString() != null) {
                                                                    qString = "?" + req.getQueryString();
                                                                }
                                                                if ((rPath = this.removeLeadingSlashes(path.toString())) == null) {
                                                                    rPath = "";
                                                                }
                                                                String redirectURI = rPath + page + qString;
                                                                req.setAttribute("com.ibm.ws.webcontainer.welcomefile.redirecturl", redirectURI);
                                                                welcomeFileRedirectUri = redirectURI;
                                                                break;
                                                            }
                                                            String uri = path.toString() + page;
                                                            req.setAttribute("com.ibm.ws.webcontainer.welcomefile.url", uri);
                                                            welcomeFileForwardUri = uri;
                                                            break;
                                                        }
                                                    }
                                                    if (this._webapp.isFiltersDefined() && (WebAppFilterManager.invokeFiltersCompatibility || welcomeFileRedirectUri != null || welcomeFileForwardUri != null)) {
                                                        IServletWrapper wrapper = (IServletWrapper)this._webapp.getRequestMapper().map(WebApp.FILTER_PROXY_MAPPING);
                                                        this.invokeFilters(req, resp, wrapper);
                                                        WebContainerRequestState reqState = WebContainerRequestState.getInstance(false);
                                                        if (reqState != null && reqState.getAttribute("com.ibm.ws.webcontainer.filter.exceptioninfilter") != null) {
                                                            reqState.removeAttribute("com.ibm.ws.webcontainer.filter.exceptioninfilter");
                                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                logger.exiting(CLASS_NAME, "handleRequest");
                                                            }
                                                            Object var27_32 = null;
                                                            if (this.platformHelper.isSyncToThreadPlatform() && this._webapp.getConfiguration().isSyncToThreadEnabled()) {
                                                                this.platformHelper.securityIdentityPop(cred);
                                                            }
                                                            while (securityPreInvokes.size() != 0) {
                                                                this.secCollab.postInvoke(securityPreInvokes.pop());
                                                            }
                                                            this.webAppNameSpaceCollab.postInvoke();
                                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                                                            }
                                                            if (!fileNotFoundExceptionThrown) return;
                                                            throw new FileNotFoundException();
                                                        }
                                                        if (welcomeFileRedirectUri != null || welcomeFileForwardUri != null) {
                                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                logger.exiting(CLASS_NAME, "handleRequest");
                                                            }
                                                            Object var27_33 = null;
                                                            if (this.platformHelper.isSyncToThreadPlatform() && this._webapp.getConfiguration().isSyncToThreadEnabled()) {
                                                                this.platformHelper.securityIdentityPop(cred);
                                                            }
                                                            while (securityPreInvokes.size() != 0) {
                                                                this.secCollab.postInvoke(securityPreInvokes.pop());
                                                            }
                                                            this.webAppNameSpaceCollab.postInvoke();
                                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                                                            }
                                                            if (!fileNotFoundExceptionThrown) return;
                                                            throw new FileNotFoundException();
                                                        }
                                                    } else {
                                                        if (welcomeFileRedirectUri != null) {
                                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "sendRedirect to Welcome File:" + welcomeFileRedirectUri);
                                                            }
                                                            resp.sendRedirect(resp.encodeRedirectURL(welcomeFileRedirectUri));
                                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                logger.exiting(CLASS_NAME, "handleRequest");
                                                            }
                                                            Object var27_34 = null;
                                                            if (this.platformHelper.isSyncToThreadPlatform() && this._webapp.getConfiguration().isSyncToThreadEnabled()) {
                                                                this.platformHelper.securityIdentityPop(cred);
                                                            }
                                                            while (securityPreInvokes.size() != 0) {
                                                                this.secCollab.postInvoke(securityPreInvokes.pop());
                                                            }
                                                            this.webAppNameSpaceCollab.postInvoke();
                                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                                                            }
                                                            if (!fileNotFoundExceptionThrown) return;
                                                            throw new FileNotFoundException();
                                                        }
                                                        if (welcomeFileForwardUri != null) {
                                                            RequestDispatcher rd = context.getRequestDispatcher(welcomeFileForwardUri);
                                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "forward :" + welcomeFileForwardUri);
                                                            }
                                                            rd.forward(req, resp);
                                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                logger.exiting(CLASS_NAME, "handleRequest");
                                                            }
                                                            Object var27_35 = null;
                                                            if (this.platformHelper.isSyncToThreadPlatform() && this._webapp.getConfiguration().isSyncToThreadEnabled()) {
                                                                this.platformHelper.securityIdentityPop(cred);
                                                            }
                                                            while (securityPreInvokes.size() != 0) {
                                                                this.secCollab.postInvoke(securityPreInvokes.pop());
                                                            }
                                                            this.webAppNameSpaceCollab.postInvoke();
                                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                                                            }
                                                            if (!fileNotFoundExceptionThrown) return;
                                                            throw new FileNotFoundException();
                                                        }
                                                    }
                                                    if (this._webapp.getConfiguration().isDirectoryBrowsingEnabled() && (dirBrowse = context.getRequestDispatcher(WebApp.DIR_BROWSING_MAPPING)) != null) {
                                                        req.setAttribute("com.ibm.servlet.engine.webapp.dir.browsing.path", fileSystemPath);
                                                        req.setAttribute("com.ibm.servlet.engine.webapp.dir.browsing.uri", req.getRequestURI());
                                                        if (this._webapp.isFiltersDefined()) {
                                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "getting proxy filter mapping for directory browse -->" + WebApp.FILTER_PROXY_MAPPING);
                                                            }
                                                            IServletWrapper wrapper = (IServletWrapper)this._webapp.getRequestMapper().map(WebApp.FILTER_PROXY_MAPPING);
                                                            req.setAttribute("com.ibm.ws.webcontainer.browsedir.url", "/" + WebApp.DIR_BROWSING_MAPPING);
                                                            this.invokeFilters(req, resp, wrapper);
                                                            WebContainerRequestState reqState = WebContainerRequestState.getInstance(false);
                                                            if (reqState != null && reqState.getAttribute("com.ibm.ws.webcontainer.filter.exceptioninfilter") != null) {
                                                                WebContainerRequestState.getInstance(false).removeAttribute("com.ibm.ws.webcontainer.filter.exceptioninfilter");
                                                                Object var27_36 = null;
                                                                if (this.platformHelper.isSyncToThreadPlatform() && this._webapp.getConfiguration().isSyncToThreadEnabled()) {
                                                                    this.platformHelper.securityIdentityPop(cred);
                                                                }
                                                                while (securityPreInvokes.size() != 0) {
                                                                    this.secCollab.postInvoke(securityPreInvokes.pop());
                                                                }
                                                                this.webAppNameSpaceCollab.postInvoke();
                                                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                                                                }
                                                                if (!fileNotFoundExceptionThrown) return;
                                                                throw new FileNotFoundException();
                                                            }
                                                        } else {
                                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Directory Browse" + fileSystemPath);
                                                            }
                                                            dirBrowse.forward(req, resp);
                                                        }
                                                        Object var27_37 = null;
                                                        if (this.platformHelper.isSyncToThreadPlatform() && this._webapp.getConfiguration().isSyncToThreadEnabled()) {
                                                            this.platformHelper.securityIdentityPop(cred);
                                                        }
                                                        while (securityPreInvokes.size() != 0) {
                                                            this.secCollab.postInvoke(securityPreInvokes.pop());
                                                        }
                                                        this.webAppNameSpaceCollab.postInvoke();
                                                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                                                        }
                                                        if (!fileNotFoundExceptionThrown) return;
                                                        throw new FileNotFoundException();
                                                    }
                                                    if (!resp.isCommitted()) {
                                                        resp.sendError(404, nls.getString("File.not.found", "File not found"));
                                                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest ---> File not found");
                                                        }
                                                    } else {
                                                        logger.exiting("handleRequest", "handleRequest");
                                                    }
                                                    Object var27_38 = null;
                                                    if (this.platformHelper.isSyncToThreadPlatform() && this._webapp.getConfiguration().isSyncToThreadEnabled()) {
                                                        this.platformHelper.securityIdentityPop(cred);
                                                    }
                                                    while (securityPreInvokes.size() != 0) {
                                                        this.secCollab.postInvoke(securityPreInvokes.pop());
                                                    }
                                                    this.webAppNameSpaceCollab.postInvoke();
                                                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                                                    }
                                                    if (!fileNotFoundExceptionThrown) return;
                                                    throw new FileNotFoundException();
                                                }
                                                if (this.isRequestForbidden(path)) {
                                                    resp.sendError(403, MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), pathInfo));
                                                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest --> Forbidden-endsWith");
                                                    }
                                                    break block166;
                                                }
                                                if (FileSystem.isCaseInsensitive && !FileSystem.uriCaseCheck((File)(caseFile = new Java2SecurityFile(fileSystemPath)), (String)path.toString())) {
                                                    if (!TraceComponent.isAnyTracingEnabled()) throw new FileNotFoundException(path.toString());
                                                    if (!logger.isLoggable(Level.FINE)) throw new FileNotFoundException(path.toString());
                                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest --> Case sensitivity check - throw FileNotFoundException");
                                                    throw new FileNotFoundException(path.toString());
                                                }
                                                FileServletWrapper fwrapper = this.getStaticFileWrapper(this._webapp, this, file);
                                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Use FileServletWrapper");
                                                }
                                                fwrapper.handleRequest(req, resp);
                                                if (this._webapp.isCachingEnabled()) break block167;
                                                try {
                                                    this._webapp.addMappingTarget(path.toString(), fwrapper);
                                                    if (!dispatchContext.isInclude() && !dispatchContext.isForward()) {
                                                        WebContainer.addToCache(req, fwrapper, this._webapp);
                                                    }
                                                    break block167;
                                                }
                                                catch (Exception e) {
                                                }
                                                break block167;
                                            }
                                            catch (FileNotFoundException e) {
                                                if (!WCCustomProperties.THROW_404_IN_PREFERENCE_TO_403 && this.isDirectoryTraverse(path)) {
                                                    resp.sendError(403, MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), pathInfo));
                                                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Forbidden-file does not exist");
                                                    }
                                                    Object var27_41 = null;
                                                    if (this.platformHelper.isSyncToThreadPlatform() && this._webapp.getConfiguration().isSyncToThreadEnabled()) {
                                                        this.platformHelper.securityIdentityPop(cred);
                                                    }
                                                    while (securityPreInvokes.size() != 0) {
                                                        this.secCollab.postInvoke(securityPreInvokes.pop());
                                                    }
                                                    this.webAppNameSpaceCollab.postInvoke();
                                                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                                                    }
                                                    if (!fileNotFoundExceptionThrown) return;
                                                    throw new FileNotFoundException();
                                                }
                                                IServletWrapper wrapper = null;
                                                WebAppErrorReport errorReport = new WebAppErrorReport(MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), e.getMessage()), e);
                                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "FileNotFoundException caught");
                                                }
                                                errorReport.setErrorCode(404);
                                                errorReport.setTargetServletName("DefaultExtensionProcessor");
                                                if (this._webapp.isFiltersDefined()) {
                                                    wrapper = (IServletWrapper)this._webapp.getRequestMapper().map(WebApp.FILTER_PROXY_MAPPING);
                                                    req.setAttribute("com.ibm.ws.webcontainer.filter.filenotfound", errorReport);
                                                }
                                                if (!this.invokeFilters(req, resp, wrapper)) {
                                                    WebContainerRequestState reqState = WebContainerRequestState.getInstance(false);
                                                    if (reqState != null && reqState.getAttribute("com.ibm.ws.webcontainer.filter.exceptioninfilter") != null) {
                                                        WebContainerRequestState.getInstance(false).removeAttribute("com.ibm.ws.webcontainer.filter.exceptioninfilter");
                                                        Object var27_42 = null;
                                                        if (this.platformHelper.isSyncToThreadPlatform() && this._webapp.getConfiguration().isSyncToThreadEnabled()) {
                                                            this.platformHelper.securityIdentityPop(cred);
                                                        }
                                                        while (securityPreInvokes.size() != 0) {
                                                            this.secCollab.postInvoke(securityPreInvokes.pop());
                                                        }
                                                        this.webAppNameSpaceCollab.postInvoke();
                                                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                                                        }
                                                        if (!fileNotFoundExceptionThrown) return;
                                                        throw new FileNotFoundException();
                                                    }
                                                    if (!WCCustomProperties.THROW_MISSING_JSP_EXCEPTION && !WCCustomProperties.MODIFIED_FNF_BEHAVIOR) {
                                                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.webcontainer.extension.DefaultExtensionProcessor.handleRequest", (String)"573", (Object)this);
                                                        try {
                                                            this._webapp.sendError(req, resp, errorReport);
                                                        }
                                                        catch (Exception ex) {}
                                                    } else {
                                                        resp.setStatus(404);
                                                        fileNotFoundExceptionThrown = true;
                                                    }
                                                }
                                                Object var27_43 = null;
                                                if (this.platformHelper.isSyncToThreadPlatform() && this._webapp.getConfiguration().isSyncToThreadEnabled()) {
                                                    this.platformHelper.securityIdentityPop(cred);
                                                }
                                                while (securityPreInvokes.size() != 0) {
                                                    this.secCollab.postInvoke(securityPreInvokes.pop());
                                                }
                                                this.webAppNameSpaceCollab.postInvoke();
                                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                                                }
                                                if (!fileNotFoundExceptionThrown) return;
                                                throw new FileNotFoundException();
                                            }
                                            catch (SecurityViolationException e) {
                                                String strPath = null;
                                                if (path != null) {
                                                    strPath = path.toString();
                                                    this.collabHelper.processSecurityPreInvokeException(e, this, req, resp, dispatchContext, this._webapp, strPath);
                                                }
                                                Object var27_44 = null;
                                                if (this.platformHelper.isSyncToThreadPlatform() && this._webapp.getConfiguration().isSyncToThreadEnabled()) {
                                                    this.platformHelper.securityIdentityPop(cred);
                                                }
                                                while (securityPreInvokes.size() != 0) {
                                                    this.secCollab.postInvoke(securityPreInvokes.pop());
                                                }
                                                this.webAppNameSpaceCollab.postInvoke();
                                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                                                }
                                                if (!fileNotFoundExceptionThrown) return;
                                                throw new FileNotFoundException();
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Object var27_45 = null;
                                            if (this.platformHelper.isSyncToThreadPlatform() && this._webapp.getConfiguration().isSyncToThreadEnabled()) {
                                                this.platformHelper.securityIdentityPop(cred);
                                            }
                                            while (securityPreInvokes.size() != 0) {
                                                this.secCollab.postInvoke(securityPreInvokes.pop());
                                            }
                                            this.webAppNameSpaceCollab.postInvoke();
                                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                                            }
                                            if (!fileNotFoundExceptionThrown) throw throwable;
                                            throw new FileNotFoundException();
                                        }
                                    }
                                    while (securityPreInvokes.size() != 0) {
                                        this.secCollab.postInvoke(securityPreInvokes.pop());
                                    }
                                    this.webAppNameSpaceCollab.postInvoke();
                                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                                    }
                                    if (!fileNotFoundExceptionThrown) return;
                                    throw new FileNotFoundException();
                                }
                                Object var27_27 = null;
                                if (this.platformHelper.isSyncToThreadPlatform() && this._webapp.getConfiguration().isSyncToThreadEnabled()) {
                                    this.platformHelper.securityIdentityPop(cred);
                                }
                                while (securityPreInvokes.size() != 0) {
                                    this.secCollab.postInvoke(securityPreInvokes.pop());
                                }
                                this.webAppNameSpaceCollab.postInvoke();
                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                                }
                                if (!fileNotFoundExceptionThrown) return;
                                throw new FileNotFoundException();
                            }
                            Object var27_28 = null;
                            if (this.platformHelper.isSyncToThreadPlatform() && this._webapp.getConfiguration().isSyncToThreadEnabled()) {
                                this.platformHelper.securityIdentityPop(cred);
                            }
                            while (securityPreInvokes.size() != 0) {
                                this.secCollab.postInvoke(securityPreInvokes.pop());
                            }
                            this.webAppNameSpaceCollab.postInvoke();
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                            }
                            if (!fileNotFoundExceptionThrown) return;
                            throw new FileNotFoundException();
                        }
                        Object var27_29 = null;
                        if (this.platformHelper.isSyncToThreadPlatform() && this._webapp.getConfiguration().isSyncToThreadEnabled()) {
                            this.platformHelper.securityIdentityPop(cred);
                        }
                        while (securityPreInvokes.size() != 0) {
                            this.secCollab.postInvoke(securityPreInvokes.pop());
                        }
                        this.webAppNameSpaceCollab.postInvoke();
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                        }
                        if (!fileNotFoundExceptionThrown) return;
                        throw new FileNotFoundException();
                    }
                    Object var27_30 = null;
                    if (this.platformHelper.isSyncToThreadPlatform() && this._webapp.getConfiguration().isSyncToThreadEnabled()) {
                        this.platformHelper.securityIdentityPop(cred);
                    }
                    while (securityPreInvokes.size() != 0) {
                        this.secCollab.postInvoke(securityPreInvokes.pop());
                    }
                    this.webAppNameSpaceCollab.postInvoke();
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                    }
                    if (!fileNotFoundExceptionThrown) return;
                    throw new FileNotFoundException();
                }
                Object var27_31 = null;
                if (this.platformHelper.isSyncToThreadPlatform() && this._webapp.getConfiguration().isSyncToThreadEnabled()) {
                    this.platformHelper.securityIdentityPop(cred);
                }
                while (securityPreInvokes.size() != 0) {
                    this.secCollab.postInvoke(securityPreInvokes.pop());
                }
                this.webAppNameSpaceCollab.postInvoke();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
                }
                if (!fileNotFoundExceptionThrown) return;
                throw new FileNotFoundException();
            }
            Object var27_39 = null;
            if (this.platformHelper.isSyncToThreadPlatform() && this._webapp.getConfiguration().isSyncToThreadEnabled()) {
                this.platformHelper.securityIdentityPop(cred);
            }
            while (securityPreInvokes.size() != 0) {
                this.secCollab.postInvoke(securityPreInvokes.pop());
            }
            this.webAppNameSpaceCollab.postInvoke();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
            }
            if (!fileNotFoundExceptionThrown) return;
            throw new FileNotFoundException();
        }
        Object var27_40 = null;
        if (this.platformHelper.isSyncToThreadPlatform() && this._webapp.getConfiguration().isSyncToThreadEnabled()) {
            this.platformHelper.securityIdentityPop(cred);
        }
        while (securityPreInvokes.size() != 0) {
            this.secCollab.postInvoke(securityPreInvokes.pop());
        }
        this.webAppNameSpaceCollab.postInvoke();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "handleRequest");
        }
        if (!fileNotFoundExceptionThrown) return;
        throw new FileNotFoundException();
    }

    protected boolean invokeFilters(HttpServletRequest request, HttpServletResponse response, IServletWrapper target) throws ServletException, IOException {
        Exception fe;
        WebContainerRequestState reqState;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "invokeFilters", "entry");
        }
        EnumSet<CollaboratorInvocationEnum> colEnum = EnumSet.of(CollaboratorInvocationEnum.CLASSLOADER, CollaboratorInvocationEnum.SESSION);
        boolean result = this._webapp.getFilterManager().invokeFilters(request, response, target, null, this._webapp, this, colEnum);
        if (!result && (reqState = WebContainerRequestState.getInstance(false)) != null && (fe = (Exception)reqState.getAttribute("com.ibm.ws.webcontainer.filter.exceptioninfilter")) != null) {
            Throwable t = null;
            Throwable rootCause = fe;
            while ((t = rootCause.getCause()) != null) {
                rootCause = t;
            }
            ServletErrorReport errReport = new ServletErrorReport(rootCause.getLocalizedMessage(), fe);
            errReport.setErrorCode(500);
            this._webapp.sendError(request, response, errReport);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "invokeFilters", "exit");
        }
        return result;
    }

    protected abstract FileServletWrapper getStaticFileWrapper(IServletContext var1, DefaultExtensionProcessor var2, File var3);

    protected abstract ZipFileServletWrapper getZipFileWrapper(IServletContext var1, DefaultExtensionProcessor var2, ZipFile var3, ZipEntry var4);

    protected boolean isValidFilePath(String filePath) {
        if (filePath == null) {
            return false;
        }
        int len = filePath.length();
        for (int i = 0; i < len; ++i) {
            if (filePath.charAt(i) >= ' ') continue;
            return false;
        }
        return true;
    }

    public String removeLeadingSlashes(String src) {
        String result = null;
        int i = 0;
        boolean done = false;
        if (src == null) {
            return null;
        }
        int len = src.length();
        while (!done && i < len) {
            if (src.charAt(i) == '/') {
                ++i;
                continue;
            }
            done = true;
        }
        if (done) {
            result = src.substring(i);
        }
        return result;
    }

    protected StringBuffer getURLWithRequestURIEncoded(HttpServletRequest req) {
        StringBuffer url = new StringBuffer();
        String scheme = req.getScheme();
        int port = req.getServerPort();
        String urlPath = null;
        try {
            urlPath = new String(req.getRequestURI().getBytes("utf-8"), "iso-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            urlPath = req.getRequestURI();
        }
        url.append(scheme);
        url.append("://");
        url.append(req.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(req.getServerPort());
        }
        url.append(urlPath);
        return url;
    }

    public String getEsiControl() {
        return this.esiControl;
    }

    public int getDefaultBufferSize() {
        return this.defaultBufferSize;
    }

    public List getPatternList() {
        return this.patternList;
    }

    private List parseFileServingExtensions(String exts) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(exts, ": ;");
        while (st.hasMoreTokens()) {
            String ext = st.nextToken();
            if (ext.equals("/")) {
                ext = DEFAULT_MAPPING;
            }
            if (this.patternList.contains(ext)) continue;
            list.add(ext);
        }
        return list;
    }

    public URIMatcher createURIMatcher(List list) {
        URIMatcher uriMatcher = new URIMatcher();
        for (String currPattern : list) {
            if (currPattern.startsWith("*.")) {
                try {
                    uriMatcher.put(currPattern, currPattern + " _base pattern");
                    uriMatcher.put(currPattern + "/", currPattern + " _base pattern 2");
                }
                catch (Exception e) {
                    logger.logp(Level.SEVERE, CLASS_NAME, "createURIMatcher", "Failed to create uri pattern for [" + currPattern + "]\n {0}", e);
                }
                continue;
            }
            try {
                uriMatcher.put(currPattern, currPattern + " _base pattern");
            }
            catch (Exception e) {
                logger.logp(Level.SEVERE, CLASS_NAME, "createURIMatcher", "Failed to create uri pattern for [" + currPattern + "]\n {0}", e);
            }
        }
        return uriMatcher;
    }

    public boolean isAvailable(String resource) {
        Java2SecurityFile caseFile = new Java2SecurityFile(this._webapp.getRealPath(resource));
        boolean available = ((File)caseFile).exists();
        if (available && FileSystem.isCaseInsensitive) {
            try {
                available = FileSystem.uriCaseCheck((File)caseFile, (String)resource);
            }
            catch (IOException io) {
                available = false;
            }
        }
        return available;
    }

    public IServletWrapper createServletWrapper(IServletConfig config) throws Exception {
        File wrapperedFile;
        String filename = this._webapp.getRealPath(config.getFileName());
        if (filename != null && (wrapperedFile = new File(filename)).exists()) {
            return this.getStaticFileWrapper(this._webapp, this, wrapperedFile);
        }
        return null;
    }

    public WebComponentMetaData getCmd() {
        return this.cmd;
    }

    private boolean isRequestForbidden(StringBuffer path) {
        boolean requestIsForbidden = false;
        String matchString = path.toString();
        if (matchString.lastIndexOf("..") != -1 && !matchString.startsWith("/...") || matchString.endsWith("\\") || matchString.endsWith(".") || matchString.endsWith("/")) {
            requestIsForbidden = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isRequestForbidden", "returning true, matchstring :" + matchString);
        }
        return requestIsForbidden;
    }

    private boolean isDirectoryTraverse(StringBuffer path) {
        boolean directoryTraverse = false;
        String matchString = path.toString();
        if (matchString.lastIndexOf("..") != -1 && !matchString.startsWith("/...")) {
            directoryTraverse = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isDirectoryTraverse", "returning" + directoryTraverse + " , matchstring :" + matchString);
        }
        return directoryTraverse;
    }

    public void nameSpacePostInvoke() {
        this.webAppNameSpaceCollab.postInvoke();
    }

    public void nameSpacePreInvoke() {
        this.webAppNameSpaceCollab.preInvoke(this.getCmd());
    }

    public int getOptimizeFileServingSize() {
        return this.optimizeFileServingSize;
    }

    public void destroy() {
    }

    public ServletConfig getServletConfig() {
        return null;
    }

    public String getServletInfo() {
        return null;
    }

    public void init(ServletConfig arg0) throws ServletException {
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        try {
            this.handleRequest(request, response);
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }

    static {
        DEFAULT_DENY_EXTENSIONS = new ArrayList();
        DEFAULT_DENY_EXTENSIONS.add("*.jsp");
        DEFAULT_DENY_EXTENSIONS.add("*.jsv");
        DEFAULT_DENY_EXTENSIONS.add("*.jsw");
        DEFAULT_DENY_EXTENSIONS.add("*.jspx");
        try {
            String sizeStr = WCCustomProperties.OPTIMIZE_FILE_SERVING_SIZE_GLOBAL;
            if (sizeStr != null) {
                optimizeFileServingSizeGlobal = Integer.valueOf(WCCustomProperties.OPTIMIZE_FILE_SERVING_SIZE_GLOBAL);
            }
        }
        catch (NumberFormatException nfe) {
            FFDCFilter.processException((Throwable)nfe, (String)"com.ibm.ws.webcontainer.extension.DefaultExtensionProcessor.<init>", (String)"65");
        }
    }

    private class Java2SecurityFile
    extends File {
        private static final long serialVersionUID = 1L;

        public Java2SecurityFile(File parent, String child) {
            super(parent, child);
        }

        public Java2SecurityFile(String pathname) {
            super(pathname);
        }

        public Java2SecurityFile(String parent, String child) {
            super(parent, child);
        }

        public Java2SecurityFile(URI uri) {
            super(uri);
        }

        public boolean canRead() {
            if (System.getSecurityManager() != null) {
                Java2SecurityFile internalFile = this;
                Boolean returnType = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new Boolean(Java2SecurityFile.this._canRead());
                    }
                });
                return returnType;
            }
            return super.canRead();
        }

        public boolean _canRead() {
            return super.canRead();
        }

        public boolean canWrite() {
            if (System.getSecurityManager() != null) {
                Java2SecurityFile internalFile = this;
                Boolean returnType = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new Boolean(Java2SecurityFile.this._canWrite());
                    }
                });
                return returnType;
            }
            return super.canWrite();
        }

        public boolean _canWrite() {
            return super.canWrite();
        }

        public boolean delete() {
            if (System.getSecurityManager() != null) {
                Java2SecurityFile internalFile = this;
                Boolean returnType = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new Boolean(Java2SecurityFile.this._delete());
                    }
                });
                return returnType;
            }
            return super.delete();
        }

        public boolean _delete() {
            return super.delete();
        }

        public void deleteOnExit() {
            if (System.getSecurityManager() != null) {
                Java2SecurityFile internalFile = this;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Java2SecurityFile.this._deleteOnExit();
                        return null;
                    }
                });
            } else {
                super.deleteOnExit();
            }
        }

        public void _deleteOnExit() {
            super.deleteOnExit();
        }

        public boolean exists() {
            if (System.getSecurityManager() != null) {
                Java2SecurityFile internalFile = this;
                Boolean returnType = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new Boolean(Java2SecurityFile.this._exists());
                    }
                });
                return returnType;
            }
            return super.exists();
        }

        public boolean _exists() {
            return super.exists();
        }

        public boolean isDirectory() {
            if (System.getSecurityManager() != null) {
                Java2SecurityFile internalFile = this;
                Boolean returnType = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new Boolean(Java2SecurityFile.this._isDirectory());
                    }
                });
                return returnType;
            }
            return super.isDirectory();
        }

        public boolean _isDirectory() {
            return super.isDirectory();
        }

        public boolean isFile() {
            if (System.getSecurityManager() != null) {
                Java2SecurityFile internalFile = this;
                Boolean returnType = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new Boolean(Java2SecurityFile.this._isFile());
                    }
                });
                return returnType;
            }
            return super.isFile();
        }

        public boolean _isFile() {
            return super.isFile();
        }

        public boolean isHidden() {
            if (System.getSecurityManager() != null) {
                Java2SecurityFile internalFile = this;
                Boolean returnType = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new Boolean(Java2SecurityFile.this._isHidden());
                    }
                });
                return returnType;
            }
            return super.isHidden();
        }

        public boolean _isHidden() {
            return super.isHidden();
        }
    }
}

