/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.engine;

import java.io.Serializable;

public class UserPreferences
implements Serializable,
Comparable {
    private static final long serialVersionUID = 1L;
    private static int INVALID_INT = -1;
    private static long INVALID_LONG = -1L;
    private static String INVALID_STRING = "";
    private int hashCode;
    private String nodeName = INVALID_STRING;
    private String serverName = INVALID_STRING;
    private String userId = INVALID_STRING;
    private int refreshRate = INVALID_INT;
    private int bufferSize = INVALID_INT;
    private int numLogFiles = INVALID_INT;
    private long logFileSize = INVALID_LONG;
    private long loggingDuration = INVALID_LONG;
    private boolean viewLog = false;
    private String logFileName = "";
    private String tpvLogFormat = "xml";

    public UserPreferences() {
        this.hashCode = INVALID_INT;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int compareTo(Object object) {
        return this.compareTo((UserPreferences)object);
    }

    public int compareTo(UserPreferences userPreferences) {
        int n = this.userId.compareTo(userPreferences.userId);
        if (n != 0) {
            return n;
        }
        n = this.nodeName.compareTo(userPreferences.nodeName);
        if (n != 0) {
            return n;
        }
        n = this.serverName.compareTo(userPreferences.serverName);
        if (n != 0) {
            return n;
        }
        n = this.logFileName.compareTo(userPreferences.logFileName);
        if (n != 0) {
            return n;
        }
        n = this.refreshRate - userPreferences.refreshRate;
        if (n != 0) {
            return n;
        }
        n = this.bufferSize - userPreferences.bufferSize;
        if (n != 0) {
            return n;
        }
        n = this.numLogFiles - userPreferences.numLogFiles;
        if (n != 0) {
            return n;
        }
        n = (int)(this.logFileSize - userPreferences.logFileSize);
        if (n != 0) {
            return n;
        }
        n = (int)(this.loggingDuration - userPreferences.loggingDuration);
        if (n != 0) {
            return n;
        }
        return 0;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public long getLogFileSize() {
        return this.logFileSize;
    }

    public long getLoggingDuration() {
        return this.loggingDuration;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public int getNumLogFiles() {
        return this.numLogFiles;
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getUserId() {
        return this.userId;
    }

    public boolean getViewLog() {
        return this.viewLog;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public void setLogFileSize(long l) {
        this.logFileSize = l;
    }

    public void setLoggingDuration(long l) {
        this.loggingDuration = l;
    }

    public void setNodeName(String string) {
        this.nodeName = string;
        this.genHashCode();
    }

    public void setNumLogFiles(int n) {
        this.numLogFiles = n;
    }

    public void setRefreshRate(int n) {
        this.refreshRate = n;
    }

    public void setServerName(String string) {
        this.serverName = string;
        this.genHashCode();
    }

    public void setUserId(String string) {
        this.userId = string;
        this.genHashCode();
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String string) {
        this.logFileName = string;
    }

    public void setViewLog(boolean bl) {
        this.viewLog = bl;
    }

    public static final boolean isValid(int n) {
        return n != INVALID_INT;
    }

    public static final boolean isValid(long l) {
        return l != INVALID_LONG;
    }

    public static final boolean isValid(String string) {
        return string != null;
    }

    public boolean update(UserPreferences userPreferences) {
        if (!userPreferences.nodeName.equals(this.nodeName) || !userPreferences.serverName.equals(this.serverName)) {
            return false;
        }
        if (UserPreferences.isValid(userPreferences.userId)) {
            this.userId = userPreferences.userId;
        }
        if (UserPreferences.isValid(userPreferences.refreshRate)) {
            this.refreshRate = userPreferences.refreshRate;
        }
        if (UserPreferences.isValid(userPreferences.bufferSize)) {
            this.bufferSize = userPreferences.bufferSize;
        }
        if (UserPreferences.isValid(userPreferences.numLogFiles)) {
            this.numLogFiles = userPreferences.numLogFiles;
        }
        if (UserPreferences.isValid(userPreferences.logFileSize)) {
            this.logFileSize = userPreferences.logFileSize;
        }
        if (UserPreferences.isValid(userPreferences.loggingDuration)) {
            this.loggingDuration = userPreferences.loggingDuration;
        }
        if (UserPreferences.isValid(userPreferences.logFileName)) {
            this.logFileName = userPreferences.logFileName;
        }
        if (UserPreferences.isValid(userPreferences.tpvLogFormat)) {
            this.tpvLogFormat = userPreferences.tpvLogFormat;
        }
        this.viewLog = userPreferences.viewLog;
        return true;
    }

    public UserPreferences copy() {
        UserPreferences userPreferences = new UserPreferences();
        userPreferences.bufferSize = this.bufferSize;
        userPreferences.logFileName = new String(this.logFileName);
        userPreferences.logFileSize = this.logFileSize;
        userPreferences.loggingDuration = this.loggingDuration;
        userPreferences.nodeName = new String(this.nodeName);
        userPreferences.serverName = new String(this.serverName);
        userPreferences.userId = new String(this.userId);
        userPreferences.numLogFiles = this.numLogFiles;
        userPreferences.refreshRate = this.refreshRate;
        userPreferences.viewLog = this.viewLog;
        userPreferences.tpvLogFormat = new String(this.tpvLogFormat);
        return userPreferences;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("UserPreferences: ");
        stringBuffer.append("nodeName: ").append(this.nodeName);
        stringBuffer.append(", serverName: ").append(this.serverName);
        stringBuffer.append(", userId: ").append(this.userId);
        stringBuffer.append(", refreshRate: ").append(this.refreshRate);
        stringBuffer.append(", bufferSize: ").append(this.bufferSize);
        stringBuffer.append(", numLogFiles: ").append(this.numLogFiles);
        stringBuffer.append(", logFileSize: ").append(this.logFileSize);
        stringBuffer.append(", loggingDuration: ").append(this.loggingDuration);
        stringBuffer.append(", logFileName: ").append(this.logFileName);
        stringBuffer.append(", viewLog: ").append(this.viewLog);
        stringBuffer.append(", tpvLogFormat: ").append(this.tpvLogFormat);
        return stringBuffer.toString();
    }

    public int hashCode() {
        if (this.hashCode == INVALID_INT) {
            this.genHashCode();
        }
        return this.hashCode;
    }

    private final void genHashCode() {
        this.hashCode = new StringBuffer(64).append(this.userId).append('|').append(this.nodeName).append('|').append(this.serverName).hashCode();
    }

    public String getTpvLogFormat() {
        return this.tpvLogFormat;
    }

    public void setTpvLogFormat(String string) {
        this.tpvLogFormat = string;
    }
}

