/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.exceptions;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ce.cm.DuplicateKeyException;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.ce.cm.StaleStatementException;
import com.ibm.ws.exception.WsException;
import com.ibm.ws.exception.WsNestedException;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfigurationHelper;
import com.ibm.ws.rsadapter.exceptions.WSDataTruncation;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.BatchUpdateException;
import java.sql.ClientInfoStatus;
import java.sql.DataTruncation;
import java.sql.SQLClientInfoException;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLTransientException;
import java.util.Locale;
import java.util.Map;
import javax.resource.ResourceException;

public class DataStoreAdapterException
extends ResourceException
implements WsNestedException {
    private static final long serialVersionUID = -1282552127378991160L;
    private static final String DEFAULTTEXT = "Error in a data store adapter";
    private WsException ivException = null;
    static final String resBundle = "com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS";
    private static final TraceComponent tcLocal = Tr.register(DataStoreAdapterException.class, "RRA", "com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private boolean connectionError = false;
    private boolean containsSqlException = false;
    private boolean beenMapped = false;
    private transient String messageKey;
    private boolean authorizationException = false;
    private Object[] formatArgs;

    public DataStoreAdapterException(String string, String string2, Class clazz) {
        this(string, null, null, string2, clazz);
    }

    public DataStoreAdapterException(String string, Throwable throwable, String string2, Class clazz) {
        this(string, new Object[]{throwable.getMessage()}, throwable, string2, clazz);
    }

    public DataStoreAdapterException(String string, Throwable throwable, Class clazz) {
        this(string, new Object[]{throwable.getMessage()}, throwable, DEFAULTTEXT, clazz);
    }

    public DataStoreAdapterException(String string, Object[] objectArray, String string2, Class clazz) {
        this(string, objectArray, null, string2, clazz);
    }

    public DataStoreAdapterException(String string, Object[] objectArray, Throwable throwable, String string2, Class clazz) {
        this(TraceNLS.getFormattedMessage(resBundle, string, Locale.US, objectArray, string2), string, objectArray, throwable, clazz);
    }

    private DataStoreAdapterException(String string, String string2, Object[] objectArray, Throwable throwable, Class clazz) {
        super(string);
        this.messageKey = string2;
        this.formatArgs = objectArray;
        TraceComponent traceComponent = Tr.register(clazz, "RRA", resBundle);
        if (throwable == null) {
            this.ivException = new WsException(string);
            this.ivException.fillInStackTrace();
            if (traceComponent.isDebugEnabled()) {
                Tr.debug(tcLocal, "DSA_ERROR", this);
            }
        } else {
            if (throwable instanceof SQLException) {
                this.containsSqlException = true;
                SQLException sQLException = (SQLException)throwable;
                SQLException sQLException2 = sQLException.getNextException();
                Throwable throwable2 = sQLException.getCause();
                String string3 = sQLException.getSQLState();
                int n = sQLException.getErrorCode();
                StringBuffer stringBuffer = new StringBuffer(150);
                stringBuffer.append(string).append(" with SQL State : ").append(string3).append(" SQL Code : ").append(n);
                string = stringBuffer.toString();
                if (DSConfigurationHelper._enableReplacementOfErrorMessages) {
                    String string4 = AdapterUtil.getNLSMessage((String)"SQL_STATE_ERROR_CODE", (Object)new Object[]{string3, new Integer(n)});
                    if (throwable instanceof DuplicateKeyException) {
                        throwable = new DuplicateKeyException(sQLException.getMessage() + string4, string3, n);
                    } else if (throwable instanceof StaleStatementException) {
                        throwable = new StaleStatementException(sQLException.getMessage() + string4, string3, n);
                    } else if (throwable instanceof StaleConnectionException) {
                        throwable = new StaleConnectionException(sQLException.getMessage() + string4, string3, n);
                    } else if (throwable instanceof BatchUpdateException) {
                        int[] nArray = ((BatchUpdateException)throwable).getUpdateCounts();
                        throwable = new BatchUpdateException(sQLException.getMessage() + string4, string3, n, nArray);
                    } else if (throwable instanceof DataTruncation) {
                        DataTruncation dataTruncation = (DataTruncation)throwable;
                        throwable = new WSDataTruncation(dataTruncation.getMessage() + string4, dataTruncation.getIndex(), dataTruncation.getParameter(), dataTruncation.getRead(), dataTruncation.getDataSize(), dataTruncation.getTransferSize());
                        ((DataTruncation)throwable).setNextWarning(dataTruncation.getNextWarning());
                    } else if (throwable instanceof SQLClientInfoException) {
                        Map<String, ClientInfoStatus> map = ((SQLClientInfoException)throwable).getFailedProperties();
                        throwable = new SQLClientInfoException(sQLException.getMessage() + string4, string3, n, map);
                    } else {
                        throwable = throwable instanceof SQLDataException ? new SQLDataException(sQLException.getMessage() + string4, string3, n) : (throwable instanceof SQLFeatureNotSupportedException ? new SQLFeatureNotSupportedException(sQLException.getMessage() + string4, string3, n) : (throwable instanceof SQLIntegrityConstraintViolationException ? new SQLIntegrityConstraintViolationException(sQLException.getMessage() + string4, string3, n) : (throwable instanceof SQLInvalidAuthorizationSpecException ? new SQLInvalidAuthorizationSpecException(sQLException.getMessage() + string4, string3, n) : (throwable instanceof SQLNonTransientException ? new SQLNonTransientException(sQLException.getMessage() + string4, string3, n) : (throwable instanceof SQLRecoverableException ? new SQLRecoverableException(sQLException.getMessage() + string4, string3, n) : (throwable instanceof SQLSyntaxErrorException ? new SQLSyntaxErrorException(sQLException.getMessage() + string4, string3, n) : (throwable instanceof SQLTimeoutException ? new SQLTimeoutException(sQLException.getMessage() + string4, string3, n) : (throwable instanceof SQLTransactionRollbackException ? new SQLTransactionRollbackException(sQLException.getMessage() + string4, string3, n) : (throwable instanceof SQLTransientConnectionException ? new SQLTransientConnectionException(sQLException.getMessage() + string4, string3, n) : (throwable instanceof SQLNonTransientConnectionException ? new SQLNonTransientConnectionException(sQLException.getMessage() + string4, string3, n) : (throwable instanceof SQLTransientException ? new SQLTransientException(sQLException.getMessage() + string4, string3, n) : new SQLException(sQLException.getMessage() + string4, string3, n))))))))))));
                    }
                    throwable.setStackTrace(sQLException.getStackTrace());
                    if (throwable2 != null) {
                        throwable.initCause(throwable2);
                    }
                    if (sQLException2 != null) {
                        ((SQLException)throwable).setNextException(sQLException2);
                    }
                }
            }
            this.ivException = new WsException(string, throwable);
            this.ivException.setStackTrace(throwable.getStackTrace());
            if (traceComponent.isDebugEnabled()) {
                Tr.debug(traceComponent, "Exception", throwable);
            }
        }
    }

    public void printStackTrace() {
        this.ivException.printStackTrace();
    }

    public void printStackTrace(PrintWriter printWriter) {
        this.ivException.printStackTrace(printWriter);
    }

    public void printStackTrace(PrintStream printStream) {
        this.ivException.printStackTrace(printStream);
    }

    public void printSuperStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
    }

    public boolean beenMapped() {
        return this.beenMapped;
    }

    public void setBeenMapped() {
        this.beenMapped = true;
    }

    public boolean isConnectionError() {
        return this.connectionError;
    }

    public boolean containsSqlException() {
        return this.containsSqlException;
    }

    public void setConnectionError(boolean bl) {
        this.connectionError = bl;
    }

    public Exception getLinkedException() {
        for (Throwable throwable = this.getCause(); throwable != null; throwable = throwable.getCause()) {
            if (!(throwable instanceof Exception)) continue;
            return (Exception)throwable;
        }
        return null;
    }

    public void setLinkedException(Exception exception) {
        String string = this.ivException.getMessage();
        this.ivException = new WsException(string, exception);
        this.containsSqlException = exception instanceof SQLException;
    }

    public Throwable getCause() {
        return this.ivException.getCause();
    }

    public Throwable initCause(Throwable throwable) throws IllegalArgumentException, IllegalStateException {
        return this.ivException.initCause(throwable);
    }

    public final String translate(Locale locale) {
        if (this.messageKey == null) {
            return this.getMessage();
        }
        return TraceNLS.getFormattedMessage(resBundle, this.messageKey, locale, this.formatArgs, this.messageKey);
    }

    public boolean isAuthorizationException() {
        return this.authorizationException;
    }

    public void setAuthorizationException(boolean bl) {
        this.authorizationException = bl;
    }
}

