/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.wsadmin;

import com.ibm.io.file.exception.FileNotFoundException;
import com.ibm.ws.profile.bootstrap.WSProfileProperties;
import com.ibm.ws.profile.utils.FileLocker;
import com.ibm.ws.profile.utils.FileLockerException;
import com.ibm.ws.profile.wsadmin.WsProfileAdminService;
import java.io.File;
import java.io.IOException;

public class WsProfileAdminRequester
extends WsProfileAdminService {
    private File m_fileRequest;
    private File m_fileResponse;
    private FileLocker m_flRequest;
    private FileLocker m_flResponse;
    private static boolean m_fIsListenerAvailable = false;
    private static String m_sCommunicationBaseFilename = "";
    public static final String RETURN_CODE_PREFIX = "returnCode=";
    public static final int N_SINGLE_WSADMIN_ERROR_CODE = -1;
    public static final int[] NA_SUCCESSFUL_WSADMIN_RETURN_CODES = new int[]{0, 101};
    private static final long L_LOCK_RETRY_INTERVAL = 200L;
    private static final String S_REQUEST_FILE_EXTENSION = ".request";
    private static final String S_RESPONSE_FILE_EXTENSION = ".response";
    private static final String S_RETRY_COUNT_PROPERTY = "WS_WSADMIN_LISTENER_LOCK_RETRY_COUNT";
    private static final String S_SHUTDOWN_RETRY_COUNT_PROPERTY = "WS_WSADMIN_LISTENER_SHUTDOWN_LOCK_RETRY_COUNT";
    private static final String S_INIT_RETRY_COUNT_PROPERTY = "WS_WSADMIN_LISTENER_INITIALIZATION_LOCK_RETRY_COUNT";
    private static final int N_DEFAULT_RETRY_COUNT = 30000;
    private static final int N_DEFAULT_SHUTDOWN_RETRY_COUNT = 1;
    private static final int N_DEFAULT_INIT_RETRY_COUNT = 1500;
    private static int m_nInitRetryCount = 1500;
    private static int m_nShutdownRetryCount = 1;
    private static int m_nRetryCount = 30000;

    private WsProfileAdminRequester(String sCommunicationBaseFilename) throws IOException {
        this.m_fileRequest = new File(sCommunicationBaseFilename + S_REQUEST_FILE_EXTENSION);
        this.m_fileResponse = new File(sCommunicationBaseFilename + S_RESPONSE_FILE_EXTENSION);
        this.m_flRequest = new FileLocker(sCommunicationBaseFilename + S_REQUEST_FILE_EXTENSION);
        this.m_flResponse = new FileLocker(sCommunicationBaseFilename + S_RESPONSE_FILE_EXTENSION);
        if (this.isCommunicationsFileChanged(sCommunicationBaseFilename)) {
            m_fIsListenerAvailable = false;
            WsProfileAdminRequester.log("Resetting listener available status to: " + m_fIsListenerAvailable);
            this.resetTimeouts();
        }
        m_sCommunicationBaseFilename = sCommunicationBaseFilename;
    }

    public static int sendWsAdminRequest(String[] saArgs, String sCommunicationBaseFilename) {
        int nReturnCode = -1;
        try {
            WsProfileAdminRequester wsparAdminRequester = new WsProfileAdminRequester(sCommunicationBaseFilename);
            nReturnCode = wsparAdminRequester.processRequest(saArgs);
            if (wsparAdminRequester.isFatalFailure(nReturnCode)) {
                wsparAdminRequester.stopListener();
            }
        }
        catch (Exception ex) {
            nReturnCode = -1;
            WsProfileAdminRequester.log("Received Exception: " + ex.getMessage());
            WsProfileAdminRequester.log("Returning with error code=" + nReturnCode);
            ex.printStackTrace();
        }
        return nReturnCode;
    }

    private int processRequest(String[] saArgs) throws FileLockerException, IOException {
        int nReturnCode = -1;
        if (this.isListenerAvailable()) {
            this.sendRequest(saArgs);
            nReturnCode = this.processResponse();
        }
        WsProfileAdminRequester.log("Returning with returnCode=" + nReturnCode);
        return nReturnCode;
    }

    private void sendRequest(String[] saArgs) throws FileLockerException, IOException {
        WsProfileAdminRequester.log("Sending wsadmin request");
        try {
            this.m_flRequest.acquireFileLock(200L, m_nRetryCount);
            String formattedArgs = WsProfileAdminRequester.formatArgs(saArgs);
            WsProfileAdminRequester.writeToFile(this.m_fileRequest, formattedArgs);
            this.m_flRequest.releaseFileLock();
        }
        catch (FileLockerException fle) {
            WsProfileAdminRequester.log("Could not aquire file lock to file: " + this.m_fileRequest.getAbsolutePath() + " within timeout period. Either file does not exist, or the lock is unavailable.");
            WsProfileAdminRequester.log("Received a FileLockerException: " + fle.getMessage());
            WsProfileAdminRequester.log(WsProfileAdminRequester.getExceptionStackTraceAsString(fle));
            throw fle;
        }
        catch (IOException ioe) {
            WsProfileAdminRequester.log("Could not aquire file lock to file: " + this.m_fileRequest.getAbsolutePath() + " As an IOException was encountered.");
            WsProfileAdminRequester.log("Received an IOException: " + ioe.getMessage());
            WsProfileAdminRequester.log(WsProfileAdminRequester.getExceptionStackTraceAsString(ioe));
            throw ioe;
        }
    }

    private int parseReturnCode(String sReturnCode) {
        int nReturnCode = -1;
        try {
            if (sReturnCode == null || RETURN_CODE_PREFIX.length() > sReturnCode.length()) {
                nReturnCode = -1;
                return -1;
            }
            nReturnCode = Integer.parseInt(sReturnCode.substring(RETURN_CODE_PREFIX.length()));
        }
        catch (NumberFormatException nfe) {
            WsProfileAdminRequester.log("NumberFormatException: " + nfe.getMessage());
            nfe.printStackTrace();
            nReturnCode = -1;
        }
        return nReturnCode;
    }

    private int processResponse() throws FileLockerException, IOException {
        int nReturnCode = -1;
        long retryInterval = 200L;
        int retryCount = m_nRetryCount;
        for (int i = 0; i < retryCount; ++i) {
            if (this.isResponseAvailable()) {
                WsProfileAdminRequester.log("wsadmin response available");
                String sRawResponse = this.readResponse();
                if (!this.isInitMessageRecieved(sRawResponse)) {
                    nReturnCode = this.parseReturnCode(sRawResponse);
                    WsProfileAdminRequester.log("Return Code = " + nReturnCode);
                    break;
                }
                WsProfileAdminRequester.log("Recieved an initialization message. Waiting for response to wsadmin request.");
            }
            try {
                Thread.sleep(retryInterval);
                continue;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        if (nReturnCode == -1) {
            WsProfileAdminRequester.log("Could not aquire file lock to file: " + this.m_fileResponse.getAbsolutePath() + " within timeout period. Either file does not exit, or the lock is unavailable.");
        }
        WsProfileAdminRequester.log("Returning with returnCode=" + nReturnCode);
        return nReturnCode;
    }

    private boolean isCommunicationsFileChanged(String sNewCommunicationBaseFilename) {
        return m_sCommunicationBaseFilename == null && sNewCommunicationBaseFilename != null || m_sCommunicationBaseFilename != null && !m_sCommunicationBaseFilename.equals(sNewCommunicationBaseFilename);
    }

    private boolean isResponseAvailable() throws FileLockerException, IOException {
        if (this.m_fileResponse.exists()) {
            try {
                this.m_flResponse.acquireFileLock(200L, m_nRetryCount);
                return true;
            }
            catch (FileLockerException fle) {
                WsProfileAdminRequester.log("Could not aquire file lock to file: " + this.m_fileResponse.getAbsolutePath() + " within timeout period. Either file does not exit, or the lock is unavailable.");
                WsProfileAdminRequester.log("Received a FileLockerException: " + fle.getMessage());
                WsProfileAdminRequester.log(WsProfileAdminRequester.getExceptionStackTraceAsString(fle));
                throw fle;
            }
            catch (IOException ioe) {
                WsProfileAdminRequester.log("Could not aquire file lock to file: " + this.m_fileResponse.getAbsolutePath() + " As an IOException was encountered.");
                WsProfileAdminRequester.log("Received an IOException: " + ioe.getMessage());
                WsProfileAdminRequester.log(WsProfileAdminRequester.getExceptionStackTraceAsString(ioe));
                throw ioe;
            }
        }
        return false;
    }

    private boolean isFatalFailure(int nReturnCode) {
        for (int i = 0; i < NA_SUCCESSFUL_WSADMIN_RETURN_CODES.length; ++i) {
            if (nReturnCode != NA_SUCCESSFUL_WSADMIN_RETURN_CODES[i]) continue;
            return false;
        }
        boolean isConfigActionFatal = new Boolean(System.getProperty("isConfigActionFatal"));
        if (isConfigActionFatal) {
            WsProfileAdminRequester.log("Failure detected in fatal config action.");
        } else {
            WsProfileAdminRequester.log("Failure detected in non-fatal config action.");
        }
        return isConfigActionFatal;
    }

    private boolean isInitMessageRecieved(String sResponse) {
        return sResponse != null && sResponse.indexOf("wsadmin Listener initialized") != -1;
    }

    private String readResponse() throws FileLockerException, IOException {
        String rawData = WsProfileAdminRequester.readFromFile(this.m_fileResponse);
        this.m_fileResponse.delete();
        try {
            this.m_flResponse.releaseFileLock();
        }
        catch (FileLockerException fle) {
            WsProfileAdminRequester.log("Could not release file lock to file: " + this.m_fileResponse.getAbsolutePath());
            WsProfileAdminRequester.log("Received a FileLockerException: " + fle.getMessage());
            WsProfileAdminRequester.log(WsProfileAdminRequester.getExceptionStackTraceAsString(fle));
            throw fle;
        }
        return rawData;
    }

    private void stopListener() {
        WsProfileAdminRequester.log("Signalling wsadmin listener to stop.");
        try {
            this.m_flRequest.acquireFileLock(200L, m_nShutdownRetryCount);
            WsProfileAdminRequester.writeToFile(this.m_fileRequest, "Finished Processing");
            this.m_flRequest.releaseFileLock();
        }
        catch (FileLockerException fle) {
            try {
                WsProfileAdminRequester.writeToFile(this.m_fileRequest, "Finished Processing");
            }
            catch (IOException innerIoe) {
                WsProfileAdminRequester.log("Error received stopping wsadmin listener.  The listener will timeout, or can be stopped manually.");
                WsProfileAdminRequester.log("The error message was: " + innerIoe.getMessage());
                WsProfileAdminRequester.log(WsProfileAdminRequester.getExceptionStackTraceAsString(innerIoe));
            }
        }
        catch (IOException ioe) {
            WsProfileAdminRequester.log("Error received stopping wsadmin listener.  The listener will timeout, or can be stopped manually.");
            WsProfileAdminRequester.log("The error message was: " + ioe.getMessage());
            WsProfileAdminRequester.log(WsProfileAdminRequester.getExceptionStackTraceAsString(ioe));
        }
    }

    private boolean isListenerAvailable() {
        if (!m_fIsListenerAvailable) {
            m_fIsListenerAvailable = this.isListenerInitialized();
        }
        WsProfileAdminRequester.log("Is wsadmin listener available? " + m_fIsListenerAvailable);
        return m_fIsListenerAvailable;
    }

    private boolean isListenerInitialized() {
        WsProfileAdminRequester.log("Checking for wsadmin listener initialization");
        boolean fIsInitialized = false;
        int retryCount = m_nInitRetryCount;
        long retryInterval = 200L;
        for (int i = 0; i < retryCount; ++i) {
            if (this.m_fileResponse.exists()) {
                try {
                    this.m_flResponse.acquireFileLock(200L, m_nInitRetryCount);
                    String sRawResponseData = WsProfileAdminRequester.readFromFile(this.m_fileResponse);
                    WsProfileAdminRequester.log("wsadmin listener initalized status: [" + sRawResponseData + "]");
                    if (this.isInitMessageRecieved(sRawResponseData)) {
                        WsProfileAdminRequester.log("wsadmin listener is initialized.");
                        fIsInitialized = true;
                    } else {
                        WsProfileAdminRequester.log("wsadmin listener is not initialized.");
                        fIsInitialized = false;
                    }
                    this.m_fileResponse.delete();
                    this.m_flResponse.releaseFileLock();
                }
                catch (FileLockerException fle) {
                    WsProfileAdminRequester.log("Could not aquire file lock to file: " + this.m_fileResponse.getAbsolutePath() + " within timeout period. Either file does not exit, or the lock is unavailable.");
                    WsProfileAdminRequester.log("Received a FileLockerException: " + fle.getMessage());
                    WsProfileAdminRequester.log(WsProfileAdminRequester.getExceptionStackTraceAsString(fle));
                    fIsInitialized = false;
                }
                catch (IOException ioe) {
                    WsProfileAdminRequester.log("Could not aquire file lock to file: " + this.m_fileResponse.getAbsolutePath() + " As an IOException was encountered.");
                    WsProfileAdminRequester.log("Received an IOException: " + ioe.getMessage());
                    WsProfileAdminRequester.log(WsProfileAdminRequester.getExceptionStackTraceAsString(ioe));
                    fIsInitialized = false;
                }
                break;
            }
            if (i >= retryCount - 1) continue;
            try {
                Thread.sleep(retryInterval);
                continue;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        return fIsInitialized;
    }

    private void resetTimeouts() {
        WsProfileAdminRequester.log("setting wsadmin requester timeouts");
        m_nInitRetryCount = 30000;
        m_nShutdownRetryCount = 1;
        m_nRetryCount = 30000;
        try {
            WSProfileProperties wsppProperties = new WSProfileProperties();
            String sRetryCount = wsppProperties.getProperty(S_RETRY_COUNT_PROPERTY);
            String sShutdownRetryCount = wsppProperties.getProperty(S_SHUTDOWN_RETRY_COUNT_PROPERTY);
            String sInitRetryCount = wsppProperties.getProperty(S_INIT_RETRY_COUNT_PROPERTY);
            if (sRetryCount != null) {
                try {
                    m_nRetryCount = Integer.parseInt(sRetryCount);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (sShutdownRetryCount != null) {
                try {
                    m_nShutdownRetryCount = Integer.parseInt(sShutdownRetryCount);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (sInitRetryCount != null) {
                try {
                    m_nInitRetryCount = Integer.parseInt(sInitRetryCount);
                }
                catch (NumberFormatException nfe) {}
            }
        }
        catch (FileNotFoundException fne) {
            WsProfileAdminRequester.log("wasprofile.properties file not found. Default timeouts will be used");
        }
        catch (IOException ioe) {
            WsProfileAdminRequester.log("IOException accessing wasprofile.properties file. Default timeouts will be used");
        }
        WsProfileAdminRequester.log("wsadmin requester retry count = " + m_nRetryCount + ", initialization retry count = " + m_nInitRetryCount + ", shutdown retry count = " + m_nShutdownRetryCount);
    }

    private static void log(String sMessage) {
        System.out.println(sMessage);
    }
}

