/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.wsadmin;

import com.ibm.ws.profile.bootstrap.WSProfileProperties;
import com.ibm.ws.profile.utils.FileLocker;
import com.ibm.ws.profile.utils.FileLockerException;
import com.ibm.ws.profile.wsadmin.WsProfileAdminService;
import com.ibm.ws.scripting.WasxShell;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;

public class WsProfileAdminListener
extends WsProfileAdminService {
    private static WasxShell m_wsadmin;
    private File m_FileTraceLogFileName = null;
    private static FileWriter fwLogger;
    public static final String S_RETURN_CODE_PREFIX = "returnCode=";
    public static final String S_FINISHED_PROCESSING = "Finished Processing";
    public static final String S_INITIALIZATION_MESSAGE = "wsadmin Listener initialized";
    private static final String S_REQUEST_FILE_EXTENSION = ".request";
    private static final String S_RESPONSE_FILE_EXTENSION = ".response";
    private static final String S_FINISHED_FILE_EXTENSION = ".finished";
    private static final String S_DASH = "-";
    private static final String S_EMPTY = "";
    private static final String S_SPACE = " ";
    private static final String S_NEWLINE = "\n";
    private static final String S_TRACEFILE = "tracefile";
    private static final String S_PASSWD_PARAMETER = "winservicePassword";
    private static final String S_PASSWD_HIDE = "****************";
    private File m_fileRequest;
    private File m_fileResponse;
    private File m_fileFinished;
    private FileLocker m_flRequest;
    private FileLocker m_flResponse;
    private String m_sFileEncoding;
    public static final int N_SINGLE_WSADMIN_ERROR_CODE = -1;
    private static final long L_LOCK_RETRY_INTERVAL = 50L;
    private static final String S_RETRY_COUNT_PROPERTY = "WS_WSADMIN_LISTENER_LOCK_RETRY_COUNT";
    private static final String S_INIT_RETRY_COUNT_PROPERTY = "WS_WSADMIN_LISTENER_INITIALIZATION_LOCK_RETRY_COUNT";
    private static final int N_DEFAULT_RETRY_COUNT = 30000;
    private static final int N_DEFAULT_INIT_RETRY_COUNT = 1500;
    private static int m_nInitRetryCount;
    private static int m_nRetryCount;

    public static void main(String[] args) {
        WsProfileAdminListener wspalListener = new WsProfileAdminListener();
        try {
            if (!wspalListener.init(args)) {
                System.err.println("Could not initialize WsProfileAdminListener");
            }
            wspalListener.serviceRequests();
        }
        catch (Throwable t) {
            System.err.println("The WsProfileAdminListener class is exiting, due to an Exception.");
            System.err.println("An Exception was encountered in the WsProfileAdminListener class" + t.getMessage());
            t.printStackTrace();
        }
    }

    private boolean init(String[] args) throws IOException {
        if (args.length != 3) {
            System.err.println("Invalid Arguments. The expected arguments are: IPCfilename logname");
            return false;
        }
        String sCommunicationsFilename = args[0];
        String sLogFilename = args[1];
        this.m_sFileEncoding = args[2];
        this.m_fileRequest = new File(sCommunicationsFilename + S_REQUEST_FILE_EXTENSION);
        this.m_fileResponse = new File(sCommunicationsFilename + S_RESPONSE_FILE_EXTENSION);
        this.m_fileFinished = new File(sCommunicationsFilename + S_FINISHED_FILE_EXTENSION);
        this.cleanupPreviousFinishFile();
        this.initializeLogger(sLogFilename);
        this.log("Listener started");
        this.loadTimeouts();
        m_wsadmin = new WasxShell();
        try {
            this.m_flRequest = new FileLocker(sCommunicationsFilename + S_REQUEST_FILE_EXTENSION);
            this.m_flResponse = new FileLocker(sCommunicationsFilename + S_RESPONSE_FILE_EXTENSION);
        }
        catch (IOException ioe) {
            this.log("Could not initialize file lockers. Received IO Exception: " + ioe.getMessage());
            this.log(WsProfileAdminListener.getExceptionStackTraceAsString(ioe));
            return false;
        }
        return this.sendInitializedMessage();
    }

    public void serviceRequests() throws FileLockerException, IOException {
        boolean fFinished = false;
        while (!fFinished) {
            int i;
            long retryInterval = 50L;
            int retryCount = m_nRetryCount;
            for (i = 0; i < retryCount; ++i) {
                if (this.isRequestAvailable()) {
                    fFinished = this.processRequest();
                    break;
                }
                if (i >= retryCount - 1) continue;
                try {
                    Thread.sleep(retryInterval);
                    continue;
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            if (i != retryCount) continue;
            this.log("Could not aquire file lock to file: " + this.m_fileRequest.getAbsolutePath() + " within timeout period. Either file does not exist, or the lock is unavailable.  Exiting listener.");
            fFinished = true;
        }
        if (fFinished) {
            this.m_fileRequest.delete();
            try {
                this.m_flRequest.releaseFileLock();
            }
            catch (FileLockerException fileLockerException) {
                // empty catch block
            }
            this.log("Exiting");
            this.closelog();
        }
    }

    private boolean processRequest() throws IOException, FileLockerException {
        String rawInput = WsProfileAdminListener.readFromFile(this.m_fileRequest, this.m_sFileEncoding);
        if (this.isEndOfProcessing(rawInput)) {
            this.log(S_FINISHED_PROCESSING);
            return true;
        }
        String[] cmdArgs = WsProfileAdminListener.unformatArgs(rawInput);
        String logfileName = this.getArgument(cmdArgs, S_TRACEFILE);
        cmdArgs = this.stripLogfileFromArgs(cmdArgs);
        int nReturnCode = -1;
        try {
            this.openTraceFile(logfileName);
            nReturnCode = this.runCommand(cmdArgs);
            this.closeTraceFile();
        }
        catch (Throwable t) {
            this.log("Error encountered running wsadmin: " + t.getMessage());
            this.log(WsProfileAdminListener.getExceptionStackTraceAsString(t));
            this.log("Returning with error code: " + nReturnCode);
        }
        this.log(S_RETURN_CODE_PREFIX + nReturnCode);
        try {
            this.m_fileRequest.delete();
            this.m_flRequest.releaseFileLock();
        }
        catch (FileLockerException fle) {
            this.log("Could not release lock for: " + this.m_fileRequest.getAbsolutePath());
            this.log("Received a FileLockerException: " + fle.getMessage());
            this.log(WsProfileAdminListener.getExceptionStackTraceAsString(fle));
            throw fle;
        }
        try {
            this.m_flResponse.acquireFileLock(50L, m_nRetryCount);
            WsProfileAdminListener.writeToFile(this.m_fileResponse, this.m_sFileEncoding, S_RETURN_CODE_PREFIX + Integer.toString(nReturnCode));
            this.m_flResponse.releaseFileLock();
        }
        catch (FileLockerException fle) {
            this.log("Could not aquire file lock to file: " + this.m_fileResponse.getAbsolutePath() + " within timeout period. Either file does not exist, or the lock is unavailable.  Exiting listener.");
            this.log("Received a FileLockerException: " + fle.getMessage());
            this.log(WsProfileAdminListener.getExceptionStackTraceAsString(fle));
            throw fle;
        }
        catch (IOException ioe) {
            this.log("Could not aquire file lock to file: " + this.m_fileResponse.getAbsolutePath() + " As an IOException was encountered. Exiting Listener.");
            this.log("Received an IOException: " + ioe.getMessage());
            this.log(WsProfileAdminListener.getExceptionStackTraceAsString(ioe));
            throw ioe;
        }
        return false;
    }

    private String[] stripLogfileFromArgs(String[] cmdArgs) {
        if (this.getArgument(cmdArgs, S_TRACEFILE) != null) {
            String[] modifiedCmdArgs = new String[cmdArgs.length - 2];
            int j = 0;
            try {
                for (int i = 0; i < cmdArgs.length; ++i) {
                    if (cmdArgs[i].equals("-tracefile")) {
                        i += 2;
                    }
                    if (i >= cmdArgs.length || j >= modifiedCmdArgs.length) continue;
                    modifiedCmdArgs[j] = cmdArgs[i];
                    ++j;
                }
            }
            catch (RuntimeException e) {
                this.log("Error in removing the tracefile from the args");
                this.log(WsProfileAdminListener.getExceptionStackTraceAsString(e));
                return cmdArgs;
            }
            return modifiedCmdArgs;
        }
        return cmdArgs;
    }

    private boolean isRequestAvailable() throws FileLockerException, IOException {
        if (this.m_fileRequest.exists()) {
            try {
                this.m_flRequest.acquireFileLock(50L, m_nRetryCount);
                return true;
            }
            catch (FileLockerException fle) {
                this.log("Could not aquire file lock to file: " + this.m_fileRequest.getAbsolutePath() + " within timeout period. Either file does not exist, or the lock is unavailable.  Exiting listener.");
                this.log("Received a FileLockerException: " + fle.getMessage());
                this.log(WsProfileAdminListener.getExceptionStackTraceAsString(fle));
                throw fle;
            }
            catch (IOException ioe) {
                this.log("Could not aquire file lock to file: " + this.m_fileRequest.getAbsolutePath() + " As an IOException was encountered. Exiting Listener.");
                this.log("Received an IOException: " + ioe.getMessage());
                this.log(WsProfileAdminListener.getExceptionStackTraceAsString(ioe));
                throw ioe;
            }
        }
        return false;
    }

    private void openTraceFile(String tracefilename) throws FileNotFoundException {
        this.log("switching trace logging to file: " + tracefilename);
        boolean fIsAppendTracefile = !this.isTraceFileSwitchNeeded(tracefilename);
        this.m_FileTraceLogFileName = new File(tracefilename);
        this.redirectSystemOut(fIsAppendTracefile);
    }

    private int runCommand(String[] cmdArgs) {
        this.log("**** Running Command");
        String[] loggableArgs = this.hidePasswordArgs(cmdArgs);
        for (int i = 0; i < loggableArgs.length; ++i) {
            this.log("args[" + i + "]=" + loggableArgs[i] + S_SPACE);
        }
        this.log("****");
        m_wsadmin.run(cmdArgs);
        return m_wsadmin.getReturnCode();
    }

    private boolean isEndOfProcessing(String rawInput) {
        return rawInput.indexOf(S_FINISHED_PROCESSING) == 0;
    }

    private boolean isTraceFileSwitchNeeded(String newTraceFileName) {
        File fileNewLog = new File(newTraceFileName);
        return this.m_FileTraceLogFileName == null && newTraceFileName != null || !this.m_FileTraceLogFileName.equals(fileNewLog);
    }

    private void initializeLogger(String logName) throws IOException {
        try {
            fwLogger = new FileWriter(new File(logName), true);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw ioe;
        }
    }

    private void log(String sOutputString) {
        try {
            fwLogger.write(sOutputString + S_NEWLINE);
            fwLogger.flush();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void closelog() {
        try {
            fwLogger.flush();
            fwLogger.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void cleanupPreviousFinishFile() {
        if (this.m_fileFinished != null && this.m_fileFinished.exists()) {
            this.m_fileFinished.delete();
        }
    }

    private void redirectSystemOut(boolean isAppend) throws FileNotFoundException {
        PrintStream sout = null;
        try {
            sout = new PrintStream(new FileOutputStream(this.m_FileTraceLogFileName, isAppend));
        }
        catch (FileNotFoundException fnf) {
            this.log("File does not exist (or can not be created) to redirect outpt to: " + this.m_FileTraceLogFileName.toString());
            fnf.printStackTrace();
            throw fnf;
        }
        System.setOut(sout);
        System.setErr(sout);
    }

    private boolean sendInitializedMessage() {
        try {
            this.m_flResponse.acquireFileLock(50L, m_nInitRetryCount);
            WsProfileAdminListener.writeToFile(this.m_fileResponse, this.m_sFileEncoding, S_INITIALIZATION_MESSAGE);
            this.m_flResponse.releaseFileLock();
            this.log("Sent initialization status: [wsadmin Listener initialized]");
            return true;
        }
        catch (FileLockerException fle) {
            this.log("Could not aquire file lock to file: " + this.m_fileResponse.getAbsolutePath() + " within timeout period. Either file does not exist, or the lock is unavailable.  Exiting listener.");
            this.log("Received a FileLockerException: " + fle.getMessage());
            this.log(WsProfileAdminListener.getExceptionStackTraceAsString(fle));
        }
        catch (IOException ioe) {
            this.log("Could not aquire file lock to file: " + this.m_fileResponse.getAbsolutePath() + " As an IOException was encountered. Exiting Listener.");
            this.log("Received an IOException: " + ioe.getMessage());
            this.log(WsProfileAdminListener.getExceptionStackTraceAsString(ioe));
        }
        return false;
    }

    private void closeTraceFile() {
        System.out.flush();
        System.out.close();
    }

    private String getArgument(String[] args, String sArgument) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(S_DASH + sArgument) || i >= args.length - 1 || args[i + 1].startsWith(S_DASH)) continue;
            return args[i + 1];
        }
        return null;
    }

    private String[] hidePasswordArgs(String[] args) {
        String[] sArgsLogs = new String[args.length];
        System.arraycopy(args, 0, sArgsLogs, 0, args.length);
        String[] sMaskableActionArguments = this.getMaskableArgs();
        if (sMaskableActionArguments == null) {
            return sArgsLogs;
        }
        for (int i = 0; i < sArgsLogs.length; ++i) {
            for (int j = 0; j < sMaskableActionArguments.length; ++j) {
                if (sArgsLogs[i].indexOf(S_DASH + sMaskableActionArguments[j]) == -1) continue;
                sArgsLogs[i] = this.maskArgWithinString(sArgsLogs[i], sMaskableActionArguments[j]);
            }
        }
        return sArgsLogs;
    }

    private String maskArgWithinString(String sUnmaskedString, String sToMask) {
        String sMaskedString = S_EMPTY;
        String sCurrentToken = S_EMPTY;
        boolean fMaskArg = false;
        StringTokenizer st = new StringTokenizer(sUnmaskedString, S_SPACE);
        while (st.hasMoreTokens()) {
            sCurrentToken = st.nextToken();
            if (fMaskArg) {
                sMaskedString = sMaskedString + "**************** ";
                fMaskArg = false;
            } else {
                sMaskedString = sMaskedString + sCurrentToken + S_SPACE;
            }
            if (!sCurrentToken.equals(S_DASH + sToMask)) continue;
            fMaskArg = true;
        }
        return sMaskedString;
    }

    private String[] getMaskableArgs() {
        String sMaskableArgs = S_EMPTY;
        try {
            sMaskableArgs = new WSProfileProperties().getProperty("WS_WSPROFILE_MASKABLE_ACTION_ARGUMENTS");
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (sMaskableArgs.indexOf(S_PASSWD_PARAMETER) == -1) {
            sMaskableArgs = "winservicePassword;" + sMaskableArgs;
        }
        String[] sMaskableArgsList = sMaskableArgs.split(";");
        return sMaskableArgsList;
    }

    private void loadTimeouts() {
        m_nInitRetryCount = 30000;
        m_nRetryCount = 30000;
        try {
            WSProfileProperties wsppProperties = new WSProfileProperties();
            String sRetryCount = wsppProperties.getProperty(S_RETRY_COUNT_PROPERTY);
            String sInitRetryCount = wsppProperties.getProperty(S_INIT_RETRY_COUNT_PROPERTY);
            if (sRetryCount != null) {
                try {
                    m_nRetryCount = Integer.parseInt(sRetryCount);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (sInitRetryCount != null) {
                try {
                    m_nInitRetryCount = Integer.parseInt(sInitRetryCount);
                }
                catch (NumberFormatException nfe) {}
            }
        }
        catch (FileNotFoundException fne) {
            this.log("wasprofile.properties file not found. Default timeouts will be used");
        }
        catch (IOException ioe) {
            this.log("IOException accessing wasprofile.properties file. Default timeouts will be used");
        }
        this.log("wsadmin listener retry count = " + m_nRetryCount + ", initialization retry count = " + m_nInitRetryCount);
    }

    static {
        m_nInitRetryCount = 1500;
        m_nRetryCount = 30000;
    }
}

