/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.validators.DirectoryValidator;
import java.io.File;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebServerProperlyFormedPathValidator
extends DirectoryValidator {
    public static final String S_VALID_DRIVE_LETTER_REGEX = "\\A[a-zA-Z]\\z";
    public static final String S_INVALID_DOT_COMBINATION = "[\\.]{1,}[\\s]{0,}[\\" + File.separator + "]";
    public static final String S_INVALID_DOT_COMBINATION2 = "[\\.]{1,}\\z";
    public static final String S_INVALID_SPACES = "[\\" + File.separator + "/][\\s]{1,}[\\" + File.separator + "/]";
    public static final String[] SA_SERVER_TYPES_REQUIRING_VALIDATION = new String[]{"IHS"};
    private static final String S_KEY_NOT_SET_KEY = "key.notset";
    private static final String S_WEBSERVER_PATH_EXCEEDS_MAX_LENGTH_KEY = "webServerPath.exceedsMaxLength";
    private static final String S_PATH_NOT_WELL_FORMED_KEY = "path.notWellFormed.webServer";
    private static final Logger LOGGER = LoggerFactory.createLogger(WebServerProperlyFormedPathValidator.class);
    private static final String S_CLASS_NAME = WebServerProperlyFormedPathValidator.class.getName();

    public boolean runValidator() {
        LOGGER.entering(S_CLASS_NAME, "runValidator");
        String sWebServerOS = System.getProperty("webServerOS");
        if (sWebServerOS == null || sWebServerOS.equals("")) {
            this.sErrorMessage = this.getKeyNotSetString();
            LOGGER.exiting(S_CLASS_NAME, "runValidator");
            return false;
        }
        if (!this.isValidPathLength(sWebServerOS)) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
            LOGGER.exiting(S_CLASS_NAME, "runValidator");
            return false;
        }
        if (!this.isValidPathFormation(sWebServerOS)) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
            LOGGER.exiting(S_CLASS_NAME, "runValidator");
            return false;
        }
        if (!this.isValidPathCharacters(sWebServerOS)) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
            LOGGER.exiting(S_CLASS_NAME, "runValidator");
            return false;
        }
        LOGGER.exiting(S_CLASS_NAME, "runValidator");
        return true;
    }

    public boolean doIRun() {
        LOGGER.entering(S_CLASS_NAME, "doIRun");
        this.bDoIRun = true;
        String sWebServerCheck = System.getProperty("webServerCheck");
        String sWebServerType = System.getProperty("webServerType");
        if (sWebServerCheck == null || !sWebServerCheck.equals("true")) {
            this.bDoIRun = false;
        } else {
            String sArg = this.getValidatorArgKey();
            if (sArg != null && sWebServerType != null && sArg.equals("webServerInstallPath")) {
                if (this.inListOfInstallPathRequiringTypes(sWebServerType)) {
                    LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", sWebServerType + " in list of webServerTypes requiring webServerInstallPath is set.");
                    this.bDoIRun = true;
                } else {
                    LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", sWebServerType + " not in list of webServerTypes requiring webServerInstallPath is set. No validation required.");
                    this.bDoIRun = false;
                }
            }
        }
        LOGGER.exiting(S_CLASS_NAME, "doIRun");
        return this.bDoIRun;
    }

    protected boolean isValidPathLength(String sPlatform) {
        LOGGER.entering(S_CLASS_NAME, "isValidPathLength");
        boolean result = true;
        if (sPlatform.equals("windows") && this.sValidatorArgValue.length() > 80) {
            result = false;
        }
        if (!result) {
            this.sErrorMessage = this.getPathExceedsMaxLengthString();
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "isValidPathLength", this.sErrorMessage);
        }
        LOGGER.exiting(S_CLASS_NAME, "isValidPathLength");
        return result;
    }

    protected boolean isValidPathFormation(String sPlatform) {
        LOGGER.entering(S_CLASS_NAME, "isValidPathFormation");
        boolean result = true;
        if (sPlatform.equals("windows")) {
            int nDriveLocation = this.sValidatorArgValue.indexOf(":");
            if (!this.isValidDriveLocation(sPlatform) || !this.evaluateRegex(S_VALID_DRIVE_LETTER_REGEX, this.sValidatorArgValue.substring(0, nDriveLocation)) || this.evaluateRegex(S_INVALID_DOT_COMBINATION, this.sValidatorArgValue.substring(nDriveLocation + 1)) || this.evaluateRegex(S_INVALID_DOT_COMBINATION2, this.sValidatorArgValue.substring(nDriveLocation + 1)) || this.evaluateRegex(S_INVALID_SPACES, this.sValidatorArgValue.substring(nDriveLocation + 1))) {
                result = false;
            }
        } else if (!this.sValidatorArgValue.startsWith("/") || this.evaluateRegex(S_INVALID_SPACES, this.sValidatorArgValue)) {
            result = false;
        }
        if (!result) {
            this.sErrorMessage = this.getPathNotWellFormedString();
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "isValidPathFormation", this.sErrorMessage);
        }
        LOGGER.exiting(S_CLASS_NAME, "isValidPathFormation");
        return result;
    }

    protected String getKeyNotSetString() {
        return MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString(S_KEY_NOT_SET_KEY, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), "webServerOS");
    }

    protected String getPathExceedsMaxLengthString() {
        return MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString(S_WEBSERVER_PATH_EXCEEDS_MAX_LENGTH_KEY, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.sValidatorArgKey);
    }

    protected String getPathNotWellFormedString() {
        return ResourceBundleUtils.getResourceBundleLocaleString(S_PATH_NOT_WELL_FORMED_KEY, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
    }

    protected boolean inListOfInstallPathRequiringTypes(String arg) {
        for (int i = 0; i < SA_SERVER_TYPES_REQUIRING_VALIDATION.length; ++i) {
            if (!SA_SERVER_TYPES_REQUIRING_VALIDATION[i].equals(arg)) continue;
            return true;
        }
        return false;
    }
}

