/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.validators.GenericWebServerValidator;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebServerDefinitionComboValidator
extends GenericWebServerValidator {
    private String[] sWindows_combinations = new String[]{"IHS", "IIS", "SUNJAVASYSTEM", "DOMINO", "APACHE"};
    private String[] sAIX_combinations = new String[]{"IHS", "SUNJAVASYSTEM", "DOMINO", "APACHE"};
    private String[] sSolaris_combinations = new String[]{"IHS", "SUNJAVASYSTEM", "DOMINO", "APACHE"};
    private String[] sHP_combinations = new String[]{"IHS", "SUNJAVASYSTEM", "DOMINO", "APACHE"};
    private String[] sLinux_combinations = new String[]{"IHS", "SUNJAVASYSTEM", "DOMINO", "APACHE"};
    private String[] sZOS_combinations = new String[]{"IHS", "HTTPSERVER_ZOS"};
    private String[] sISERIES_combinations = new String[]{"IHS", "DOMINO"};
    private boolean bIsInitialized = false;
    private Map<String, String[]> mCombinationMap = null;
    private final String S_KEY_NOT_SET_KEY = "key.notset";
    private final String S_WEB_SERVER_DEFINITION_INVALID_COMBO_KEY = "webServerDefinition.invalid.combo";
    private static final Logger LOGGER = LoggerFactory.createLogger(WebServerDefinitionComboValidator.class);
    private static final String S_CLASS_NAME = WebServerDefinitionComboValidator.class.getName();

    public boolean runValidator() {
        String sWebServerType;
        String sWebServerOS;
        LOGGER.entering(WebServerDefinitionComboValidator.class.getName(), "runValidator");
        if ("webServerOS".equals(this.sValidatorArgKey)) {
            sWebServerOS = this.sValidatorArgValue;
            sWebServerType = System.getProperty("webServerType");
        } else {
            sWebServerOS = System.getProperty("webServerOS");
            sWebServerType = this.sValidatorArgValue;
        }
        if (sWebServerOS == null || sWebServerType == null) {
            this.sErrorMessage = sWebServerOS == null ? MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("key.notset", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), "webServerOS") : MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("key.notset", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), "webServerType");
            LOGGER.exiting(WebServerDefinitionComboValidator.class.getName(), "runValidator");
            return false;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runValidator", "Validating with: webServerOS=" + sWebServerOS + " and webServerType=" + sWebServerType);
        this.initializeComboMap();
        boolean result = this.properCombination(sWebServerOS, sWebServerType);
        if (!result) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("webServerDefinition.invalid.combo", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.exiting(WebServerDefinitionComboValidator.class.getName(), "runValidator");
            return false;
        }
        LOGGER.exiting(WebServerDefinitionComboValidator.class.getName(), "runValidator");
        return true;
    }

    private void initializeComboMap() {
        LOGGER.entering(WebServerDefinitionComboValidator.class.getName(), "initializeComboMap");
        if (!this.bIsInitialized) {
            this.mCombinationMap = new Hashtable<String, String[]>();
            this.mCombinationMap.put("windows", this.sWindows_combinations);
            this.mCombinationMap.put("linux", this.sLinux_combinations);
            this.mCombinationMap.put("aix", this.sAIX_combinations);
            this.mCombinationMap.put("hpux", this.sHP_combinations);
            this.mCombinationMap.put("solaris", this.sSolaris_combinations);
            this.mCombinationMap.put("os390", this.sZOS_combinations);
            this.mCombinationMap.put("os400", this.sISERIES_combinations);
            this.bIsInitialized = true;
        }
        LOGGER.exiting(WebServerDefinitionComboValidator.class.getName(), "initializeComboMap");
    }

    private boolean properCombination(String OS, String type) {
        LOGGER.entering(WebServerDefinitionComboValidator.class.getName(), "properCombination");
        String[] saAcceptableTypes = this.mCombinationMap.get(OS);
        if (saAcceptableTypes == null) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "properCombination", "Invalid OS specified:" + OS);
            LOGGER.exiting(WebServerDefinitionComboValidator.class.getName(), "properCombination");
            return false;
        }
        int nType_location = this.find(type, saAcceptableTypes);
        if (nType_location == -1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "properCombination", "Invalid Type specified:" + type);
            LOGGER.exiting(WebServerDefinitionComboValidator.class.getName(), "properCombination");
            return false;
        }
        LOGGER.exiting(WebServerDefinitionComboValidator.class.getName(), "properCombination");
        return true;
    }
}

