/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.WASUtilities;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.validators.UserValidator;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class UserAdminPrivilegeValidator
extends UserValidator {
    private final String S_USER_ADMIN_PRIVILEGE_NOT_SET_KEY = "user.adminPrivilege.notset";
    private final String S_USER_VALIDATION_ERROR_KEY = "user.validation.error";
    private final String S_PLATFORM_NOT_SUPPORT_SERVICE_KEY = "user.servicesupport.error";
    private static final Logger LOGGER = LoggerFactory.createLogger(UserAdminPrivilegeValidator.class);

    public boolean runValidator() {
        LOGGER.entering(UserAdminPrivilegeValidator.class.getName(), "runValidator");
        int rCode = -1;
        int supported = 1;
        int permission = 1;
        if (WASUtilities.isLinux()) {
            s_linux_validate_cmd = "-issupportedplatform";
            supported = UserAdminPrivilegeValidator.validate(null, null);
            if (supported == 0) {
                s_linux_validate_cmd = "-hasInstallpermissions";
                permission = UserAdminPrivilegeValidator.validate(null, null);
            } else {
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("user.servicesupport.error", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                LOGGER.exiting(UserAdminPrivilegeValidator.class.getName(), "runValidator");
                return false;
            }
        }
        if (WASUtilities.isWindows()) {
            rCode = UserAdminPrivilegeValidator.validate(null, null);
            permission = 0;
        }
        if (rCode == 0 || permission == 1) {
            String userName = System.getProperty("user.name");
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("user.adminPrivilege.notset", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), userName);
            LOGGER.exiting(UserAdminPrivilegeValidator.class.getName(), "runValidator");
            return false;
        }
        if (WASUtilities.isWindows() && rCode == -1 || WASUtilities.isLinux() && permission != 0 && permission != 1) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("user.validation.error", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.exiting(UserAdminPrivilegeValidator.class.getName(), "runValidator");
            return false;
        }
        LOGGER.exiting(UserAdminPrivilegeValidator.class.getName(), "runValidator");
        return true;
    }

    public boolean doIRun() {
        String serviceCheck;
        LOGGER.entering(UserAdminPrivilegeValidator.class.getName(), "doIRun");
        if (WASUtilities.isWindows()) {
            serviceCheck = System.getProperty("winserviceCheck");
            this.bDoIRun = true;
            if (serviceCheck == null || !serviceCheck.equals("true")) {
                this.bDoIRun = false;
            }
        }
        if (WASUtilities.isLinux()) {
            serviceCheck = System.getProperty("enableService");
            this.bDoIRun = true;
            if (serviceCheck == null || !serviceCheck.equals("true")) {
                this.bDoIRun = false;
            }
        }
        LOGGER.exiting(UserAdminPrivilegeValidator.class.getName(), "doIRun");
        return this.bDoIRun;
    }
}

