/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.validators.ConflictingArgsAreNotSetValidator;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SigningCertValidityPeriodValidator
extends ConflictingArgsAreNotSetValidator {
    private final int N_MIN = 15;
    private final int N_MAX = 25;
    private final String S_KEY_VALIDITY_PERIOD_OUT_OF_RANGE = "SigningCertValidityPeriodValidator.invalid.range";
    private final String S_KEY_NOT_INTEGER_ERROR = "integer.error.invalidInt";
    private static final Logger LOGGER = LoggerFactory.createLogger(SigningCertValidityPeriodValidator.class);
    private static final String S_CLASS_NAME = SigningCertValidityPeriodValidator.class.getName();

    public SigningCertValidityPeriodValidator() {
        if (this.getValidatorArgKey() != null && this.getValidatorArgKey().equals("signingCertValidityPeriod")) {
            this.m_asConflictingArgs = new String[]{"importSigningCertKS"};
        }
        this.N_MIN = 15;
        this.N_MAX = 25;
        this.S_KEY_VALIDITY_PERIOD_OUT_OF_RANGE = "SigningCertValidityPeriodValidator.invalid.range";
        this.S_KEY_NOT_INTEGER_ERROR = "integer.error.invalidInt";
    }

    public boolean runValidator() {
        LOGGER.entering(S_CLASS_NAME, "runValidator");
        boolean result = false;
        int nValidityPeriod = 0;
        try {
            nValidityPeriod = Integer.parseInt(this.sValidatorArgValue);
            if (nValidityPeriod >= 15 && nValidityPeriod <= 25) {
                result = true;
            }
            if (!result) {
                this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("SigningCertValidityPeriodValidator.invalid.range", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.sValidatorArgValue, Integer.toString(15), Integer.toString(25));
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "runValidator", this.getErrorOutput());
            }
        }
        catch (NumberFormatException numFormatEx) {
            result = false;
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("integer.error.invalidInt", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.sValidatorArgValue);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runValidator", this.sErrorMessage);
        }
        LOGGER.exiting(S_CLASS_NAME, "runValidator");
        return result;
    }
}

