/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.TargetPlatform;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.validators.UserValidator;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class ServiceUserAccountValidator
extends UserValidator {
    private String f_sUserName = null;
    private String f_sPassword = null;
    private final String S_KEY_NOT_SET_KEY = "key.notset";
    private final String S_SEVICE_ACCOUNT_INVALID_KEY = "service.account.invalid";
    private final String S_USER_VALIDATION_ERROR = "user.validation.error";
    private static final Logger LOGGER = LoggerFactory.createLogger(ServiceUserAccountValidator.class);

    public boolean runValidator() {
        LOGGER.entering(ServiceUserAccountValidator.class.getName(), "runValidator");
        if (!this.isUserNameAndPasswordSet()) {
            LOGGER.exiting(ServiceUserAccountValidator.class.getName(), "runValidator");
            return false;
        }
        int rCode = -1;
        if (TargetPlatform.isLinux()) {
            rCode = ServiceUserAccountValidator.validate(this.f_sUserName, null);
        } else if (TargetPlatform.isWindows()) {
            rCode = ServiceUserAccountValidator.validate(this.f_sUserName, this.f_sPassword);
        }
        if (rCode == 0 || rCode == 255) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("service.account.invalid", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.f_sUserName);
            LOGGER.exiting(ServiceUserAccountValidator.class.getName(), "runValidator");
            return false;
        }
        if (rCode == -1) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("user.validation.error", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.exiting(ServiceUserAccountValidator.class.getName(), "runValidator");
            return false;
        }
        LOGGER.exiting(ServiceUserAccountValidator.class.getName(), "runValidator");
        return true;
    }

    public boolean runValidatorDisconnected() {
        LOGGER.entering(ServiceUserAccountValidator.class.getName(), "runValidatorDisconnected");
        if (!this.isUserNameAndPasswordSet()) {
            LOGGER.exiting(ServiceUserAccountValidator.class.getName(), "runValidatorDisconnected");
            return false;
        }
        LOGGER.exiting(ServiceUserAccountValidator.class.getName(), "runValidatorDisconnected");
        return true;
    }

    private boolean isUserNameAndPasswordSet() {
        if (TargetPlatform.isWindows()) {
            if ("winserviceUserName".equals(this.sValidatorArgKey)) {
                this.f_sUserName = System.getProperty(this.sValidatorArgKey);
                this.f_sPassword = System.getProperty("winservicePassword");
            } else if ("winservicePassword".equals(this.sValidatorArgKey)) {
                this.f_sUserName = System.getProperty("winserviceUserName");
                this.f_sPassword = System.getProperty(this.sValidatorArgKey);
            }
            if (this.f_sUserName == null || this.f_sPassword == null || this.f_sUserName.equals("") || this.f_sPassword.equals("")) {
                this.sErrorMessage = this.f_sUserName == null || this.f_sUserName.equals("") ? MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("key.notset", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), "winserviceUserName") : MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("key.notset", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), "winservicePassword");
                LOGGER.exiting(ServiceUserAccountValidator.class.getName(), "isUserNameAndPasswordSet");
                return false;
            }
        } else if (TargetPlatform.isLinux()) {
            if ("serviceUserName".equals(this.sValidatorArgKey)) {
                this.f_sUserName = System.getProperty(this.sValidatorArgKey);
                if (this.f_sUserName == null || this.f_sUserName.equals("")) {
                    this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("key.notset", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), "serviceUserName");
                    LOGGER.exiting(ServiceUserAccountValidator.class.getName(), "isUserNameAndPasswordSet");
                    return false;
                }
            }
        } else {
            LOGGER.exiting(ServiceUserAccountValidator.class.getName(), "isUserNameAndPasswordSet");
            return false;
        }
        LOGGER.exiting(ServiceUserAccountValidator.class.getName(), "isUserNameAndPasswordSet");
        return true;
    }

    public boolean doIRun() {
        String serviceCheck;
        LOGGER.entering(ServiceUserAccountValidator.class.getName(), "doIRun");
        if (TargetPlatform.isWindows()) {
            String serviceType;
            serviceCheck = System.getProperty("winserviceCheck");
            this.bDoIRun = true;
            if (serviceCheck == null || !serviceCheck.equals("true")) {
                this.bDoIRun = false;
            }
            if ((serviceType = System.getProperty("winserviceAccountType")) == null || !serviceType.equals("specifieduser")) {
                if (this.bDoIRun) {
                    // empty if block
                }
                this.bDoIRun = false;
            }
        }
        if (TargetPlatform.isLinux()) {
            serviceCheck = System.getProperty("enableService");
            this.bDoIRun = true;
            if (serviceCheck == null || !serviceCheck.equals("true")) {
                this.bDoIRun = false;
            }
        }
        LOGGER.exiting(ServiceUserAccountValidator.class.getName(), "doIRun");
        return this.bDoIRun;
    }
}

