/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.validators.DirectoryValidator;
import com.ibm.wsspi.profile.validators.GenericValidator;
import java.io.File;
import java.util.logging.Logger;

public class ProperlyFormedPathValidator
extends GenericValidator {
    public final String sCOLON = ":";
    private final String S_PATH_NOT_WELL_FORMED_KEY = "path.notWellFormed";
    private static final Logger LOGGER = LoggerFactory.createLogger(ProperlyFormedPathValidator.class);

    public boolean runValidator() {
        LOGGER.entering(ProperlyFormedPathValidator.class.getName(), "runValidator");
        if (PlatformConstants.isCurrentPlatformWindows()) {
            int nDriveLocation = this.sValidatorArgValue.indexOf(":");
            if (nDriveLocation == -1 || this.sValidatorArgValue.charAt(nDriveLocation + 1) != '\\' && this.sValidatorArgValue.charAt(nDriveLocation + 1) != '/') {
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("path.notWellFormed", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                LOGGER.exiting(ProperlyFormedPathValidator.class.getName(), "runValidator");
                return false;
            }
            String driveLetter = this.sValidatorArgValue.substring(0, nDriveLocation + 2);
            File fRoot = new File(driveLetter);
            if (!fRoot.exists()) {
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("path.notWellFormed", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                LOGGER.exiting(ProperlyFormedPathValidator.class.getName(), "runValidator");
                return false;
            }
            LOGGER.exiting(ProperlyFormedPathValidator.class.getName(), "runValidator");
            return true;
        }
        if (!this.sValidatorArgValue.startsWith("/")) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("path.notWellFormed", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.exiting(DirectoryValidator.class.getName(), "runValidator");
            return false;
        }
        LOGGER.exiting(ProperlyFormedPathValidator.class.getName(), "runValidator");
        return true;
    }
}

