/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.utils.PortResolutionUtils;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.WSProfileTemplate;
import com.ibm.wsspi.profile.validators.GenericValidator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PortsCmdLineValidation
extends GenericValidator {
    private static final int I_MODE_INVALID = -1;
    private static final int I_MODE_RECOMMEND_PORTS = 0;
    private static final int I_MODE_STARTING_PORT = 1;
    private static final int I_MODE_PORTS_FILE = 2;
    private static final int I_MODE_DEFAULT_PORTS = 3;
    private static final String S_ARGS_VALIDATION_KEY = "validatePorts";
    private static final String S_ARGS_STARTING_PORT_KEY = "startingPort";
    private static final String S_ARGS_PORTS_FILE_KEY = "portsFile";
    private static final String S_ARGS_DEFAULT_PORTS_KEY = "defaultPorts";
    private static final String S_ARGS_NODE_STARTING_PORT_KEY = "nodeStartingPort";
    private static final String S_ARGS_NODE_PORTS_FILE_KEY = "nodePortsFile";
    private Vector<String> lErrorMessages = new Vector();
    private static final String S_ERROR_MESSAGE_TEMPLATE_PATH_NOT_SET = "portsCmdLineValidation.templatePathNotSet";
    private static final String S_ERROR_MESSAGE_DEFAULT_PORTS_NOT_FREE = "portsCmdLineValidation.defaultPortsNotFree";
    private static final String S_ERROR_MESSAGE_EXCEPTION_VALIDATING_DEFAULT_PORTS = "portsCmdLineValidation.exceptionDuringValidation";
    private static final String S_ERROR_MESSAGE_PORTS_FILE_NOT_SET = "portsCmdLineValidation.portsFileNotSet";
    private static final String S_ERROR_MESSAGE_NODE_PORTS_FILE_NOT_SET = "portsCmdLineValidation.nodePortsFileNotSet";
    private static final String S_ERROR_MESSAGE_FILE_NOT_FOUND_OR_NOT_ACCESSIBLE = "portsCmdLineValidation.fileNotFoundOrNotAccessible";
    private static final String S_ERROR_MESSAGE_PORTS_FILE_NOT_VALID = "portsCmdLineValidation.portsFilePortsNotFree";
    private static final String S_ERROR_MESSAGE_EXCEPTION_VALIDATING_PORTS_FILE = "portsCmdLineValidation.exceptionDuringValidation";
    private static final String S_ERROR_MESSAGE_MULTIPLE_OPTIONS_SELECTED = "portsCmdLineValidation.multipleCommandLineOptions";
    private static final String S_ERROR_MESSAGE_MULTIPLE_NODE_OPTIONS_SELECTED = "portsCmdLineValidation.multipleCommandLineOptions.node";
    private static final String S_ERROR_MESSAGE_INVALID_PORTS_FILE = "portsCmdLineValidation.invalidFile";
    private static final Logger LOGGER = LoggerFactory.createLogger(PortsCmdLineValidation.class);
    private static final String S_CLASS_NAME = PortsCmdLineValidation.class.getName();

    public boolean runValidator() {
        LOGGER.entering(PortsCmdLineValidation.class.getName(), "runValidator");
        boolean fArePortsValid = false;
        switch (this.determineMode()) {
            case 0: 
            case 1: {
                fArePortsValid = true;
                break;
            }
            case 2: {
                fArePortsValid = this.validateForModePortsFile();
                break;
            }
            case 3: {
                fArePortsValid = this.validateForModeDefaultPorts();
                break;
            }
            default: {
                fArePortsValid = false;
            }
        }
        boolean fFirstResult = fArePortsValid;
        if (!fFirstResult) {
            this.lErrorMessages.add(this.sErrorMessage);
        }
        if (this.isCellProfile()) {
            switch (this.determineCellMode()) {
                case 0: 
                case 1: {
                    fArePortsValid = true;
                    break;
                }
                case 2: {
                    fArePortsValid = this.validateForModeNodePortsFile();
                    break;
                }
                case 3: {
                    fArePortsValid = this.validateForModeDefaultPorts();
                    break;
                }
                default: {
                    fArePortsValid = false;
                }
            }
            if (!fArePortsValid) {
                this.lErrorMessages.add(this.sErrorMessage);
            }
            if (!fFirstResult || !fArePortsValid) {
                fArePortsValid = fFirstResult && fArePortsValid;
            }
        }
        LOGGER.exiting(PortsCmdLineValidation.class.getName(), "runValidator");
        return fArePortsValid;
    }

    private int determineCellMode() {
        int iMode = 0;
        int numModes = 0;
        if (this.isModeNodeStartingPorts()) {
            iMode = 1;
            ++numModes;
        }
        if (this.isModeNodePortsFile()) {
            iMode = 2;
            ++numModes;
        }
        if (this.isModeDefaultPorts()) {
            iMode = 3;
            ++numModes;
        }
        if (numModes > 1) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString(S_ERROR_MESSAGE_MULTIPLE_NODE_OPTIONS_SELECTED, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            iMode = -1;
        }
        return iMode;
    }

    private boolean isCellProfile() {
        String s_templatePath = System.getProperty("templatePath");
        if (s_templatePath == null || s_templatePath.equals("")) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "isCellProfile", "templatePath is not set in the system properties");
            return false;
        }
        try {
            WSProfileTemplate wspt = new WSProfileTemplate(new File(s_templatePath));
            return wspt.getType().equals("cell.dmgr") || wspt.getType().equals("cell.node");
        }
        catch (WSProfileException e) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "isCellProfile", "There were problems creating a template object with the path:" + s_templatePath);
            LogUtils.logException(LOGGER, e, Level.FINE);
            return false;
        }
    }

    public boolean doIRun() {
        String sArgValue;
        boolean fReturnResult = false;
        fReturnResult = this.isArgumentAvailable(S_ARGS_VALIDATION_KEY) ? (sArgValue = this.getArgumentValue(S_ARGS_VALIDATION_KEY)).equalsIgnoreCase("true") || sArgValue.equalsIgnoreCase("") : false;
        return fReturnResult;
    }

    public boolean isValidatorArgValueValidToUse(String sValidatorArgValue) {
        return true;
    }

    private boolean validateForModeDefaultPorts() {
        boolean fAreValidPorts = false;
        if (!this.isArgumentAvailable("templatePath")) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString(S_ERROR_MESSAGE_TEMPLATE_PATH_NOT_SET, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "validateForModeDefaultPorts", "Argument templatePath was not set");
            return false;
        }
        try {
            Properties propsDefaultPorts = PortResolutionUtils.determineBasePorts(this.getArgumentValue("templatePath"));
            fAreValidPorts = PortResolutionUtils.validatePorts(propsDefaultPorts);
            if (this.isCellProfile()) {
                propsDefaultPorts = (Properties)PortResolutionUtils.determineBasePorts(this.getArgumentValue("templatePath"), new String[]{"nodeportdef.props"}).get("nodeportdef.props");
                boolean bl = fAreValidPorts = fAreValidPorts && PortResolutionUtils.validatePorts(propsDefaultPorts);
            }
            if (!fAreValidPorts) {
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString(S_ERROR_MESSAGE_DEFAULT_PORTS_NOT_FREE, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "validateForModeDefaultPorts", "Some or all of the default ports for template " + this.getArgumentValue("templatePath") + " are currently in use");
            }
        }
        catch (WSProfileException wspe) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("portsCmdLineValidation.exceptionDuringValidation", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LogUtils.logException(LOGGER, wspe, Level.FINE);
            return false;
        }
        return fAreValidPorts;
    }

    private String getArgumentValue(String sArgumentKey) {
        return System.getProperty(sArgumentKey);
    }

    private boolean validateForModePortsFile() {
        if (!this.isArgumentAvailable(S_ARGS_PORTS_FILE_KEY)) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString(S_ERROR_MESSAGE_PORTS_FILE_NOT_SET, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "validateForModePortsFile", "Argument portsFile was not set");
            return false;
        }
        return this.validatePortsFromFile(this.getArgumentValue(S_ARGS_PORTS_FILE_KEY));
    }

    private boolean validateForModeNodePortsFile() {
        if (!this.isArgumentAvailable(S_ARGS_NODE_PORTS_FILE_KEY)) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString(S_ERROR_MESSAGE_NODE_PORTS_FILE_NOT_SET, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "validateForModeNodePortsFile", "Argument nodePortsFile was not set");
            return false;
        }
        return this.validatePortsFromFile(this.getArgumentValue(S_ARGS_NODE_PORTS_FILE_KEY));
    }

    private int determineMode() {
        int iMode = 0;
        int numModes = 0;
        if (this.isModeStartingPorts()) {
            iMode = 1;
            ++numModes;
        }
        if (this.isModePortsFile()) {
            iMode = 2;
            ++numModes;
        }
        if (this.isModeDefaultPorts()) {
            iMode = 3;
            ++numModes;
        }
        if (numModes > 1) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString(S_ERROR_MESSAGE_MULTIPLE_OPTIONS_SELECTED, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            iMode = -1;
        }
        return iMode;
    }

    private boolean isModeDefaultPorts() {
        return this.isArgumentAvailable(S_ARGS_DEFAULT_PORTS_KEY);
    }

    private boolean isModePortsFile() {
        return this.isArgumentAvailable(S_ARGS_PORTS_FILE_KEY);
    }

    private boolean isModeNodePortsFile() {
        return this.isArgumentAvailable(S_ARGS_NODE_PORTS_FILE_KEY);
    }

    private boolean isModeStartingPorts() {
        return this.isArgumentAvailable(S_ARGS_STARTING_PORT_KEY);
    }

    private boolean isModeNodeStartingPorts() {
        return this.isArgumentAvailable(S_ARGS_NODE_STARTING_PORT_KEY);
    }

    private boolean isArgumentAvailable(String sArgumentKey) {
        return System.getProperty(sArgumentKey) != null;
    }

    private boolean validatePortsFromFile(String sPortsFile) {
        boolean fIsPortsFileValid = true;
        File filePortsFile = new File(sPortsFile);
        Properties propPorts = new Properties();
        try {
            propPorts.load(new FileInputStream(filePortsFile));
        }
        catch (FileNotFoundException fnfe) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString(S_ERROR_MESSAGE_FILE_NOT_FOUND_OR_NOT_ACCESSIBLE, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), sPortsFile);
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "validatePortsFromFile", "File " + filePortsFile + " was not found");
            LogUtils.logException(LOGGER, fnfe, Level.FINE);
            fIsPortsFileValid = false;
            return fIsPortsFileValid;
        }
        catch (IOException ioe) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString(S_ERROR_MESSAGE_FILE_NOT_FOUND_OR_NOT_ACCESSIBLE, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), sPortsFile);
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "validatePortsFromFile", "File " + filePortsFile + " was not found or was not accessible");
            LogUtils.logException(LOGGER, ioe, Level.FINE);
            fIsPortsFileValid = false;
            return fIsPortsFileValid;
        }
        try {
            fIsPortsFileValid = PortResolutionUtils.validatePorts(propPorts);
            if (!fIsPortsFileValid) {
                this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString(S_ERROR_MESSAGE_PORTS_FILE_NOT_VALID, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), sPortsFile);
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "validatePortsFromFile", "The ports file " + sPortsFile + " contains used or reserved ports");
            }
        }
        catch (WSProfileException wspe) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("portsCmdLineValidation.exceptionDuringValidation", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), sPortsFile);
            LogUtils.logException(LOGGER, wspe, Level.FINE);
            fIsPortsFileValid = false;
            return fIsPortsFileValid;
        }
        catch (NumberFormatException e) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString(S_ERROR_MESSAGE_INVALID_PORTS_FILE, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), sPortsFile);
            LogUtils.logException(LOGGER, e, Level.FINE);
            fIsPortsFileValid = false;
            return fIsPortsFileValid;
        }
        return fIsPortsFileValid;
    }

    public String getErrorOutput() {
        LOGGER.entering(PortsCmdLineValidation.class.getName(), "getErrorOutput");
        String sTemp = "";
        for (int i = 0; i < this.lErrorMessages.size(); ++i) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getErrorOutput", "Returning error message:" + this.sErrorMessage);
            sTemp = sTemp + "validationErrorMessage=" + this.lErrorMessages.get(i) + "\n";
        }
        LOGGER.exiting(PortsCmdLineValidation.class.getName(), "getErrorOutput");
        return sTemp;
    }
}

