/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.validators.ConflictingArgsAreNotSetValidator;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PersonalCertValidityPeriodValidator
extends ConflictingArgsAreNotSetValidator {
    private final int N_MIN = 1;
    private final int N_MAX = 15;
    private final String S_KEY_VALIDITY_PERIOD_OUT_OF_RANGE = "PersonalCertValidityPeriodValidator.invalid.range";
    private final String S_KEY_NOT_INTEGER_ERROR = "integer.error.invalidInt";
    private static final Logger LOGGER = LoggerFactory.createLogger(PersonalCertValidityPeriodValidator.class);
    private static final String S_CLASS_NAME = PersonalCertValidityPeriodValidator.class.getName();

    public PersonalCertValidityPeriodValidator() {
        if (this.getValidatorArgKey() != null && this.getValidatorArgKey().equals("personalCertValidityPeriod")) {
            this.m_asConflictingArgs = new String[]{"importPersonalCertKS"};
        }
        this.N_MIN = 1;
        this.N_MAX = 15;
        this.S_KEY_VALIDITY_PERIOD_OUT_OF_RANGE = "PersonalCertValidityPeriodValidator.invalid.range";
        this.S_KEY_NOT_INTEGER_ERROR = "integer.error.invalidInt";
    }

    public boolean runValidator() {
        LOGGER.entering(S_CLASS_NAME, "runValidator");
        boolean result = true;
        int nValidityPeriod = 0;
        try {
            nValidityPeriod = Integer.parseInt(this.sValidatorArgValue);
            if (nValidityPeriod >= 1 && nValidityPeriod <= 15) {
                result = true;
            } else {
                result = false;
                this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("PersonalCertValidityPeriodValidator.invalid.range", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.sValidatorArgValue, Integer.toString(1), Integer.toString(15));
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "runValidator", this.getErrorOutput());
            }
        }
        catch (NumberFormatException numFormatEx) {
            result = false;
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("integer.error.invalidInt", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.sValidatorArgValue);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runValidator", this.sErrorMessage);
        }
        LOGGER.exiting(S_CLASS_NAME, "runValidator");
        return result;
    }
}

