/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.validators.DirectoryValidator;
import java.io.File;
import java.util.LinkedList;
import java.util.logging.Logger;

public class PathIsValidAndWritableValidator
extends DirectoryValidator {
    private static final Logger LOGGER = LoggerFactory.createLogger(PathIsValidAndWritableValidator.class);

    protected boolean isValidDir(String dir, File f) {
        File testDir;
        boolean canWrite;
        LOGGER.entering(PathIsValidAndWritableValidator.class.getName(), "isValidDir");
        boolean result = false;
        if (!f.exists()) {
            LOGGER.fine(f.getAbsolutePath() + " does not exist");
            File parent = f.getParentFile();
            LinkedList<File> parents = new LinkedList<File>();
            if (parent == null) {
                result = f.canWrite();
                LOGGER.fine("Is " + f.getAbsolutePath() + " writable? " + result);
            }
            while (parent != null && !parent.exists()) {
                parents.add(parent);
                parent = parent.getParentFile();
            }
            result = f.mkdirs();
            if (result) {
                f.delete();
                for (int i = 0; i < parents.size(); ++i) {
                    File tmpParent = (File)parents.get(i);
                    tmpParent.delete();
                }
            }
            LOGGER.exiting(PathIsValidAndWritableValidator.class.getName(), "isValidDir");
            return result;
        }
        if (f.isDirectory() && f.canWrite() && (canWrite = (testDir = new File(f.getAbsolutePath() + File.separatorChar + "testWrite")).mkdirs())) {
            testDir.delete();
            LOGGER.exiting(PathIsValidAndWritableValidator.class.getName(), "isValidDir");
            return true;
        }
        LOGGER.exiting(PathIsValidAndWritableValidator.class.getName(), "isValidDir");
        return false;
    }
}

