/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.validators.GenericValidator;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class MgmtServerNameValidator
extends GenericValidator {
    private final String S_NAME_INVALID_SERVERNAME = "name.invalid.serverName";
    private static final Logger LOGGER = LoggerFactory.createLogger(MgmtServerNameValidator.class);

    public boolean runValidator() throws WSProfileException {
        LOGGER.entering(MgmtServerNameValidator.class.getName(), "runValidator");
        String serverType = System.getProperty("serverType");
        if (PlatformConstants.isCurrentPlatformOS400()) {
            if ((serverType.equals("JOB_MANAGER") || serverType.equals("ADMIN_AGENT")) && !this.sValidatorArgValue.equals(System.getProperty("profileName"))) {
                this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("name.invalid.serverName", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.sValidatorArgValue, serverType, "the profile name");
                LOGGER.exiting(MgmtServerNameValidator.class.getName(), "runValidator");
                return false;
            }
            LOGGER.exiting(MgmtServerNameValidator.class.getName(), "runValidator");
            return true;
        }
        if (serverType.equals("JOB_MANAGER") && !this.sValidatorArgValue.equals("jobmgr")) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("name.invalid.serverName", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.sValidatorArgValue, serverType, "jobmgr");
            LOGGER.exiting(MgmtServerNameValidator.class.getName(), "runValidator");
            return false;
        }
        if (serverType.equals("DEPLOYMENT_MANAGER") && !this.sValidatorArgValue.equals("dmgr")) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("name.invalid.serverName", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.sValidatorArgValue, serverType, "dmgr");
            LOGGER.exiting(MgmtServerNameValidator.class.getName(), "runValidator");
            return false;
        }
        if (serverType.equals("ADMIN_AGENT") && !this.sValidatorArgValue.equals("adminagent")) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("name.invalid.serverName", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.sValidatorArgValue, serverType, "adminagent");
            LOGGER.exiting(MgmtServerNameValidator.class.getName(), "runValidator");
            return false;
        }
        LOGGER.exiting(MgmtServerNameValidator.class.getName(), "runValidator");
        return true;
    }
}

