/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.websphere.crypto.KeyException;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.validators.ConflictingArgsAreNotSetValidator;
import com.ibm.ws.ssl.utils.ProfileKeystoreUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImportCertKSValidator
extends ConflictingArgsAreNotSetValidator {
    private final String S_EMPTY = "";
    private final String S_PARAM_NOT_SPECIFIED = "ImportCertKSAliasValidator.requiredParam.notSpecified";
    private final String S_KEY_STORE_KEY_INVALID = "ImportCertKSValidator.invalid.keystore";
    private final String S_KEY_STORE_KEY_INVALID_NO_CERT = "ImportCertKSValidator.invalid.keystore.notpersonal";
    private String m_sKeyStoreKey;
    private String m_sKeyStoreTypeKey;
    private String m_sKeyStorePasswordKey;
    private static final Logger LOGGER = LoggerFactory.createLogger(ImportCertKSValidator.class);
    private static final String S_CLASS_NAME = ImportCertKSValidator.class.getName();

    public ImportCertKSValidator() {
        if (this.getValidatorArgKey() != null) {
            if (this.getValidatorArgKey().equals("importPersonalCertKS")) {
                this.m_asConflictingArgs = new String[]{"personalCertDN"};
            } else if (this.getValidatorArgKey().equals("importSigningCertKS")) {
                this.m_asConflictingArgs = new String[]{"signingCertDN"};
            }
        }
        this.S_EMPTY = "";
        this.S_PARAM_NOT_SPECIFIED = "ImportCertKSAliasValidator.requiredParam.notSpecified";
        this.S_KEY_STORE_KEY_INVALID = "ImportCertKSValidator.invalid.keystore";
        this.S_KEY_STORE_KEY_INVALID_NO_CERT = "ImportCertKSValidator.invalid.keystore.notpersonal";
        this.m_sKeyStoreKey = "";
        this.m_sKeyStoreTypeKey = "";
        this.m_sKeyStorePasswordKey = "";
    }

    public boolean runValidator() {
        LOGGER.entering(S_CLASS_NAME, "runValidator");
        boolean result = false;
        if (this.sValidatorArgKey.equals("importPersonalCertKS")) {
            this.m_sKeyStoreKey = "importPersonalCertKS";
            this.m_sKeyStoreTypeKey = "importPersonalCertKSType";
            this.m_sKeyStorePasswordKey = "importPersonalCertKSPassword";
        } else if (this.sValidatorArgKey.equals("importSigningCertKS")) {
            this.m_sKeyStoreKey = "importSigningCertKS";
            this.m_sKeyStoreTypeKey = "importSigningCertKSType";
            this.m_sKeyStorePasswordKey = "importSigningCertKSPassword";
        }
        String sKeyStorePath = System.getProperty(this.m_sKeyStoreKey);
        String sKeyStoreType = System.getProperty(this.m_sKeyStoreTypeKey);
        String sKeyStorePassword = System.getProperty(this.m_sKeyStorePasswordKey);
        if (sKeyStorePath == null || sKeyStorePath.equals("")) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("ImportCertKSAliasValidator.requiredParam.notSpecified", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.m_sKeyStoreKey);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runValidator", this.sErrorMessage);
            LOGGER.exiting(S_CLASS_NAME, "runValidator");
            return false;
        }
        if (sKeyStoreType == null || sKeyStoreType.equals("")) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("ImportCertKSAliasValidator.requiredParam.notSpecified", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.m_sKeyStoreTypeKey);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runValidator", this.sErrorMessage);
            LOGGER.exiting(S_CLASS_NAME, "runValidator");
            return false;
        }
        if (sKeyStorePassword == null || sKeyStorePassword.equals("")) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("ImportCertKSAliasValidator.requiredParam.notSpecified", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.m_sKeyStorePasswordKey);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runValidator", this.sErrorMessage);
            LOGGER.exiting(S_CLASS_NAME, "runValidator");
            return false;
        }
        try {
            result = ProfileKeystoreUtils.checkKeyStoreInfo((String)sKeyStoreType, (String)sKeyStorePath, (String)sKeyStorePassword);
        }
        catch (KeyException keyEx) {
            result = false;
            this.sErrorMessage = keyEx.getLocalizedMessage();
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runValidator", this.sErrorMessage);
        }
        catch (Exception ex) {
            result = false;
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("ImportCertKSValidator.invalid.keystore", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.sValidatorArgValue);
        }
        if (result) {
            try {
                ArrayList aliases = ProfileKeystoreUtils.getKeyStoreAliases((String)sKeyStoreType, (String)sKeyStorePath, (String)sKeyStorePassword);
                if (aliases.size() <= 0) {
                    result = false;
                    this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("ImportCertKSValidator.invalid.keystore.notpersonal", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.sValidatorArgValue);
                }
            }
            catch (Exception e) {
                result = false;
                this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("ImportCertKSValidator.invalid.keystore", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.sValidatorArgValue);
            }
        }
        LOGGER.exiting(S_CLASS_NAME, "runValidator");
        return result;
    }
}

