/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.ijc.IJC;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.WASUtilities;
import com.ibm.ws.profile.bootstrap.WSProfileProperties;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.validators.WebServerDefinitionComboValidator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class GenericValidator
implements IJC {
    protected String sErrorMessage;
    protected boolean bDoIRun;
    protected boolean bValidationResult;
    protected String sValidatorArgKey;
    protected String sValidatorArgValue;
    protected static String[] sMaskableArgsList;
    protected static final String S_EMPTY = " ";
    protected static final String S_PASSWD_PARAMETER = "winservicePassword";
    protected static final String S_PASSWD_HIDE = "**********";
    private static final Logger LOGGER;
    private static final String S_CLASS_NAME;

    public boolean execute() {
        LOGGER.entering(GenericValidator.class.getName(), "execute");
        try {
            this.bDoIRun = this.doIRun();
            if (this.bDoIRun) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "execute", "Executing validator:" + this.getClass().getName());
                this.sValidatorArgKey = this.getValidatorArgKey();
                if (!this.isValidatorArgKeyValidToUse(this.sValidatorArgKey)) {
                    this.bValidationResult = false;
                    this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("argkey.notset", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                    return this.bValidationResult;
                }
                this.sValidatorArgValue = this.getValidatorArgValue();
                if (!this.isValidatorArgValueValidToUse(this.sValidatorArgValue)) {
                    this.bValidationResult = false;
                    this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("key.notset", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                    return this.bValidationResult;
                }
                LOGGER.logp(Level.FINE, S_CLASS_NAME, "execute", "Running validation for parameter:" + this.sValidatorArgKey + " with value:" + WASUtilities.hideArgValueIfNecessary(this.sValidatorArgKey, this.sValidatorArgValue, GenericValidator.getMaskableArgs()));
                this.bValidationResult = this.runValidator();
                LOGGER.exiting(GenericValidator.class.getName(), "execute");
                return this.bValidationResult;
            }
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "execute", this.getClass().getName() + " did not run");
            LOGGER.exiting(GenericValidator.class.getName(), "execute");
            return true;
        }
        catch (Exception e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "An exception occurred while validating");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Exception text:\n" + e.getMessage());
            LogUtils.logException(LOGGER, e);
            this.sErrorMessage = e.getMessage();
            return false;
        }
    }

    public boolean doIRun() {
        LOGGER.entering(GenericValidator.class.getName(), "doIRun");
        LOGGER.exiting(GenericValidator.class.getName(), "doIRun");
        return true;
    }

    public abstract boolean runValidator() throws Exception;

    public String getErrorOutput() {
        LOGGER.entering(GenericValidator.class.getName(), "getErrorOutput");
        if (this.sErrorMessage != null) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "getErrorOutput", "Returning error message:" + this.sErrorMessage);
        }
        LOGGER.exiting(GenericValidator.class.getName(), "getErrorOutput");
        return "validationErrorMessage=" + this.sErrorMessage;
    }

    public String getOutput() {
        LOGGER.entering(GenericValidator.class.getName(), "getOutput");
        if (this.bDoIRun) {
            LOGGER.exiting(GenericValidator.class.getName(), "getOutput");
            if (this.bValidationResult) {
                return "validationValue=" + this.bValidationResult;
            }
            return "validationValue=" + this.bValidationResult + "\n" + "validationErrorMessage=" + this.sErrorMessage;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getOutput", "The validator was skipped, returning true");
        LOGGER.exiting(GenericValidator.class.getName(), "getOutput");
        return "validationValue=true";
    }

    public boolean isValidatorArgKeyValidToUse(String sValidatorArgKey) {
        boolean fIsValid = !this.isStringEmpty(sValidatorArgKey);
        return fIsValid;
    }

    public boolean isValidatorArgValueValidToUse(String sValidatorArgValue) {
        boolean fIsValid = !this.isStringEmpty(sValidatorArgValue);
        return fIsValid;
    }

    public String getValidatorArgKey() {
        return System.getProperty("validatorArgKey");
    }

    public String getValidatorArgValue() {
        if (this.sValidatorArgKey != null) {
            return System.getProperty(this.sValidatorArgKey);
        }
        return System.getProperty(this.getValidatorArgKey());
    }

    public void setValidatorArgKey(String argKey) {
        this.sValidatorArgKey = argKey;
    }

    public void setValidatorArgValue(String argValue) {
        this.sValidatorArgValue = argValue;
    }

    public int find(String type, String[] typeList) {
        LOGGER.entering(GenericValidator.class.getName(), "find");
        for (int i = 0; i < typeList.length; ++i) {
            if (!typeList[i].equals(type)) continue;
            LOGGER.exiting(WebServerDefinitionComboValidator.class.getName(), "find");
            return i;
        }
        LOGGER.exiting(GenericValidator.class.getName(), "find");
        return -1;
    }

    private boolean isStringEmpty(String sCurrent) {
        return sCurrent == null || sCurrent.equals("");
    }

    public static String[] getMaskableArgs() {
        LOGGER.entering(GenericValidator.class.getName(), "getMaskableArgs");
        String sMaskableArgs = S_EMPTY;
        if (sMaskableArgsList == null) {
            try {
                sMaskableArgs = new WSProfileProperties().getProperty("WS_WSPROFILE_MASKABLE_ACTION_ARGUMENTS");
            }
            catch (FileNotFoundException e) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getMaskableArgs", "No Maskable Action Arguments found in wasprofile.properties");
            }
            catch (IOException e) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getMaskableArgs", "No Maskable Action Arguments found in wasprofile.properties");
            }
            catch (NullPointerException e) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getMaskableArgs", "No Maskable Action Arguments found in wasprofile.properties");
            }
            if (sMaskableArgs.indexOf(S_PASSWD_PARAMETER) == -1) {
                sMaskableArgs = "winservicePassword;" + sMaskableArgs;
            }
            sMaskableArgsList = sMaskableArgs.split(";");
        }
        LOGGER.exiting(GenericValidator.class.getName(), "getMaskableArgs");
        return sMaskableArgsList;
    }

    static {
        LOGGER = LoggerFactory.createLogger(GenericValidator.class);
        S_CLASS_NAME = GenericValidator.class.getName();
    }
}

