/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.management.ostools.WASServiceUtility;
import com.ibm.ws.management.ostools.unix.WASServiceException;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.validators.GenericValidator;
import java.util.logging.Logger;

public class EnableServiceValidator
extends GenericValidator {
    private static String S_PLATFORM_NO_SUPPORT_SERVICE_KEY = "EnableServiceValidator.serviceNotSupported";
    private static String S_USER_NO_INSTALL_SERVICE_KEY = "EnableServiceValidator.serviceNotAllowed";
    private static final Logger LOGGER = LoggerFactory.createLogger(EnableServiceValidator.class);

    public boolean doIRun() {
        LOGGER.entering(EnableServiceValidator.class.getName(), "doIRun");
        this.bDoIRun = false;
        if (PlatformConstants.getCurrentPlatform() == 4 && this.getValidatorArgValue() != null && this.getValidatorArgValue().trim().equalsIgnoreCase("true")) {
            this.bDoIRun = true;
        }
        LOGGER.exiting(EnableServiceValidator.class.getName(), "doIRun");
        return this.bDoIRun;
    }

    public boolean runValidator() {
        LOGGER.entering(EnableServiceValidator.class.getName(), "runValidator");
        boolean result = true;
        try {
            if (!WASServiceUtility.isSupportedPlatform()) {
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString(S_PLATFORM_NO_SUPPORT_SERVICE_KEY, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                result = false;
            } else if (!WASServiceUtility.hasInstallPermissions()) {
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString(S_USER_NO_INSTALL_SERVICE_KEY, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                result = false;
            }
        }
        catch (WASServiceException wse) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString(S_USER_NO_INSTALL_SERVICE_KEY, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            result = false;
        }
        LOGGER.exiting(EnableServiceValidator.class.getName(), "runValidator");
        return result;
    }
}

