/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.ClassPathModifier;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.validators.GenericFederateLaterValidator;
import com.ibm.ws.ssl.utils.RetrieveSigners;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class DmgrConnectionValidator
extends GenericFederateLaterValidator {
    private String logfile;
    private boolean trace = true;
    private boolean replacelog = true;
    AdminClient adminClient = null;
    private static final String S_WAS_HOME = "WAS_HOME";
    private static final String S_LIB = "lib";
    private static final String S_PLUGINS = "plugins";
    private static final String S_TRUST_STORE_FILE_PREFIX = "trust";
    private static final String S_TRUST_STORE_FILE_SUFFIX = ".p12";
    private static final String S_KEY_STORE_FILE_PREFIX = "key";
    private static final String S_KEY_STORE_FILE_SUFFIX = ".p12";
    private static final String S_DMGR_CONNECTION_TMP_FILE_PREFIX = "dmgrConnection";
    private static final String S_DMGR_CONNECTION_TMP_FILE_SUFFIX = "tmp";
    private static final String S_DMGR_CONNECTION_PSSWD = "dmgrConnectionTest";
    private static final String[] ARR_DEPENDENT_JARS_PLUGINS = new String[]{"com.ibm.ws.emf.jar", "org.eclipse.core.runtime_.jar", "org.eclipse.osgi_.jar", "com.ibm.ws.bootstrap.jar", "com.ibm.ws.security.crypto.jar"};
    private static final String[] ARR_DEPENDENT_JARS_LIB = new String[]{"bootstrap.jar", "j2ee.jar"};
    private static final Logger LOGGER = LoggerFactory.createLogger(DmgrConnectionValidator.class);
    private static final String S_CLASS_NAME = DmgrConnectionValidator.class.getName();
    private static PrintStream m_SystemOut = System.out;
    private static PrintStream m_SystemErr = System.err;
    private File tmpFile = null;
    private File keyStoreTmpFile = null;
    private File trustStoreTmpFile = null;

    public static void main(String[] args) {
        DmgrConnectionValidator validator = new DmgrConnectionValidator();
        boolean valid = validator.execute();
        if (valid) {
            System.out.println("[valid]");
        } else {
            System.out.println("[" + validator.getErrorOutput() + "]");
        }
    }

    public boolean runValidator() {
        LOGGER.entering(DmgrConnectionValidator.class.getName(), "execute");
        if (!this.addJarsToRunTime()) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "Failure: Couldn't add the required jars to the classpath.");
            return false;
        }
        String dmgrHost = System.getProperty("dmgrHost");
        String dmgrPort = System.getProperty("dmgrPort");
        if (dmgrHost == null && dmgrPort == null) {
            boolean result = true;
            LOGGER.exiting(DmgrConnectionValidator.class.getName(), "execute");
            return result;
        }
        if (dmgrHost != null && dmgrPort == null) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("dmgrConnection.noDmgrPort", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            boolean result = false;
            LOGGER.exiting(DmgrConnectionValidator.class.getName(), "execute");
            return result;
        }
        if (dmgrHost == null && dmgrPort != null) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("dmgrConnection.noDmgrHost", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            boolean result = false;
            LOGGER.exiting(DmgrConnectionValidator.class.getName(), "execute");
            return result;
        }
        String dmgrAdminUserName = System.getProperty("dmgrAdminUserName");
        String dmgrAdminPassword = System.getProperty("dmgrAdminPassword");
        if (dmgrAdminUserName == null && dmgrAdminPassword == null) {
            boolean result = this.checkDmgrConnection(dmgrHost, dmgrPort);
            LOGGER.exiting(DmgrConnectionValidator.class.getName(), "execute");
            return result;
        }
        if (dmgrAdminUserName != null && dmgrAdminPassword == null) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("dmgrConnection.noDmgrAdminPassword", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            boolean result = false;
            LOGGER.exiting(DmgrConnectionValidator.class.getName(), "execute");
            return result;
        }
        if (dmgrAdminUserName == null && dmgrAdminPassword != null) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("dmgrConnection.noDmgrAdminUserName", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            boolean result = false;
            LOGGER.exiting(DmgrConnectionValidator.class.getName(), "execute");
            return result;
        }
        boolean result = this.checkDmgrConnection(dmgrHost, dmgrPort, dmgrAdminUserName, dmgrAdminPassword);
        LOGGER.exiting(DmgrConnectionValidator.class.getName(), "execute");
        return result;
    }

    private boolean checkDmgrConnection(String dmgrHost, String dmgrPort) {
        return this.checkDmgrConnection(dmgrHost, dmgrPort, "", "");
    }

    private boolean checkDmgrConnection(String dmgrHost, String dmgrPort, String dmgrAdminUserName, String dmgrAdminPassword) {
        Properties clientProperties = new Properties();
        try {
            this.redirectSystemOut();
            this.doSOAP(clientProperties, dmgrHost, dmgrPort, dmgrAdminUserName, dmgrAdminPassword);
            this.adminClient = AdminClientFactory.createAdminClient(clientProperties);
            String processType = (String)this.adminClient.getAttribute(this.adminClient.getServerMBean(), "processType");
            String netmgrName = Utils.getNetmgrName(this.adminClient);
            ObjectName dmgr = this.getMBeanByType("DeploymentManager", netmgrName);
            this.removeKeyAndTrustTempFiles();
            this.restoreSystemOut();
            if (dmgr != null) {
                return true;
            }
        }
        catch (Throwable t) {
            this.restoreSystemOut();
            this.removeKeyAndTrustTempFiles();
            if (this.isMessageInException("ADMN0022E", t)) {
                LogUtils.logException(LOGGER, t, Level.FINE);
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("dmgrConnection.badCredentials", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                return false;
            }
            if (this.isMessageInException("ADMC0016E", t) || this.isMessageInException("ADMC0018E", t)) {
                LogUtils.logException(LOGGER, t, Level.FINE);
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("dmgrConnection.noConnection", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                return false;
            }
            if (this.isMessageInException("ADMC0053E", t) || this.isMessageInException("ADMC0018E", t)) {
                LogUtils.logException(LOGGER, t, Level.FINE);
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("dmgrConnection.noSecureConnection", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                return false;
            }
            LogUtils.logException(LOGGER, t, Level.FINE);
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("dmgrConnection.noConnection", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            return false;
        }
        return false;
    }

    private void doSOAP(Properties clientProperties, String dmgrHost, String dmgrPort, String dmgrAdminUserName, String dmgrAdminPassword) {
        clientProperties.setProperty("type", "SOAP");
        clientProperties.setProperty("host", dmgrHost);
        clientProperties.setProperty("port", dmgrPort);
        if (!dmgrAdminUserName.equals("") && !dmgrAdminPassword.equals("")) {
            clientProperties.setProperty("securityEnabled", "true");
            clientProperties.setProperty("username", dmgrAdminUserName);
            clientProperties.setProperty("password", dmgrAdminPassword);
        }
        this.doSSLConfig(dmgrHost, dmgrPort, dmgrAdminUserName, dmgrAdminPassword);
    }

    private void doSSLConfig(String dmgrHost, String dmgrPort, String dmgrAdminUserName, String dmgrAdminPassword) {
        Properties sslProperties = new Properties();
        this.setupSSLProperties(sslProperties);
        String[] args = new String[]{"CellDefaultTrustStore", "ClientDefaultTrustStore", "-autoAcceptBootstrapSigner", "-host", dmgrHost, "-port", dmgrPort, "-user", dmgrAdminUserName, "-password", dmgrAdminPassword, "-conntype", "SOAP"};
        JSSEHelper jsseHelper = JSSEHelper.getInstance();
        jsseHelper.reinitializeClientDefaultSSLProperties();
        jsseHelper.setSSLPropertiesOnThread(sslProperties);
        RetrieveSigners.mainForInProcess((String[])args);
    }

    private void setupSSLProperties(Properties sslProperties) {
        String keyStoreLocation = null;
        String keyStoreName = null;
        String keyStorePassword = null;
        String trustStoreLocation = null;
        String trustStorePassword = null;
        try {
            this.keyStoreTmpFile = File.createTempFile(S_KEY_STORE_FILE_PREFIX, ".p12");
            this.trustStoreTmpFile = File.createTempFile(S_TRUST_STORE_FILE_PREFIX, ".p12");
            keyStoreLocation = this.keyStoreTmpFile.getAbsolutePath();
            keyStoreName = this.keyStoreTmpFile.getName();
            keyStorePassword = S_DMGR_CONNECTION_PSSWD;
            trustStoreLocation = this.trustStoreTmpFile.getAbsolutePath();
            trustStorePassword = S_DMGR_CONNECTION_PSSWD;
            this.trustStoreTmpFile.delete();
            this.keyStoreTmpFile.delete();
        }
        catch (FileNotFoundException e) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "setupSSLProperties", "Error writing temp files for dmgr connection");
            LogUtils.logException(LOGGER, e, Level.FINE);
        }
        catch (IOException e) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "setupSSLProperties", "Error writing temp files for dmgr connection");
            LogUtils.logException(LOGGER, e, Level.FINE);
        }
        sslProperties.put("com.ibm.ssl.defaultAlias", "DefaultSSLSettings");
        sslProperties.put("com.ibm.ssl.performURLHostNameVerification", "false");
        sslProperties.put("com.ibm.ssl.validationEnabled", "false");
        sslProperties.put("com.ibm.ssl.alias", keyStoreName);
        sslProperties.put("com.ibm.ssl.protocol", "SSL_TLS");
        sslProperties.put("com.ibm.ssl.clientAuthentication", "false");
        sslProperties.put("com.ibm.ssl.clientAuthenticationSupported", "false");
        sslProperties.put("com.ibm.ssl.trustManager", "IbmX509");
        sslProperties.put("com.ibm.ssl.keyManager", "IbmX509");
        sslProperties.put("com.ibm.ssl.contextProvider", "IBMJSSE2");
        sslProperties.put("com.ibm.ssl.enableSignerExchangePrompt", "false");
        sslProperties.put("com.ibm.ssl.keyStoreClientAlias", "default");
        sslProperties.put("com.ibm.ssl.keyStoreName", "ClientDefaultKeyStore");
        sslProperties.put("com.ibm.ssl.keyStore", keyStoreLocation);
        sslProperties.put("com.ibm.ssl.keyStorePassword", keyStorePassword);
        sslProperties.put("com.ibm.ssl.keyStoreType", "PKCS12");
        sslProperties.put("com.ibm.ssl.keyStoreProvider", "IBMJCE");
        sslProperties.put("com.ibm.ssl.keyStoreFileBased", "true");
        sslProperties.put("com.ibm.ssl.trustStoreName", "ClientDefaultTrustStore");
        sslProperties.put("com.ibm.ssl.trustStore", trustStoreLocation);
        sslProperties.put("com.ibm.ssl.trustStorePassword", trustStorePassword);
        sslProperties.put("com.ibm.ssl.trustStoreType", "PKCS12");
        sslProperties.put("com.ibm.ssl.trustStoreProvider", "IBMJCE");
        sslProperties.put("com.ibm.ssl.trustStoreFileBased", "true");
    }

    protected ObjectName getMBeanByType(String type, String processName) throws Exception {
        if (this.adminClient == null) {
            return null;
        }
        ObjectName handle = null;
        try {
            String queryStr = "WebSphere:*,process=" + processName + ",type=" + type;
            ObjectName queryName = new ObjectName(queryStr);
            Set s = this.adminClient.queryNames(queryName, null);
            Iterator iter = s.iterator();
            if (iter.hasNext()) {
                handle = (ObjectName)iter.next();
            }
        }
        catch (Exception e) {
            LogUtils.logException(LOGGER, e, Level.FINE);
            throw e;
        }
        return handle;
    }

    private boolean setTrace() {
        String spec = null;
        spec = this.trace ? "com.ibm.ws.management.*=all=enabled:com.ibm.websphere.management.*=all=enabled:com.ibm.ws.ssl.*=all=enabled:SSL=all=enabled:com.ibm.ws.security.*=all=enabled:SASRas=all=enabled" : "";
        if (this.logfile == null) {
            this.logfile = this.getDefaultTraceFile();
        }
        boolean writeToFile = true;
        if (!ManagerAdmin.isLogFileWriteable(this.logfile)) {
            writeToFile = false;
        }
        if (writeToFile) {
            ManagerAdmin.configureClientTrace(spec, "named file", this.logfile, this.replacelog, "basic", false);
        }
        return true;
    }

    protected String getDefaultTraceFile() {
        String defaultTraceFile = System.getProperty("user.install.root");
        if (defaultTraceFile == null || defaultTraceFile.length() <= 0) {
            defaultTraceFile = System.getProperty("was.install.root");
        }
        defaultTraceFile = defaultTraceFile + File.separator + "logs";
        defaultTraceFile = defaultTraceFile + File.separator + "trace.out";
        return defaultTraceFile;
    }

    private boolean isMessageInException(String message, Throwable t) {
        if (t == null || t.getMessage() == null) {
            return false;
        }
        if (t.getMessage().indexOf(message) >= 0) {
            return true;
        }
        return this.isMessageInException(message, t.getCause());
    }

    private void redirectSystemOut() {
        FileOutputStream fos = null;
        try {
            this.tmpFile = File.createTempFile(S_DMGR_CONNECTION_TMP_FILE_PREFIX, S_DMGR_CONNECTION_TMP_FILE_SUFFIX);
            fos = new FileOutputStream(this.tmpFile);
        }
        catch (FileNotFoundException e) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "redirectSystemOut", "Error writing temp file for dmgr connection");
            LogUtils.logException(LOGGER, e, Level.FINE);
        }
        catch (IOException e) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "redirectSystemOut", "Error writing temp file for dmgr connection");
            LogUtils.logException(LOGGER, e, Level.FINE);
        }
        PrintStream sout = new PrintStream(fos);
        System.setOut(sout);
        System.setErr(sout);
    }

    private void restoreSystemOut() {
        System.setOut(m_SystemOut);
        System.setErr(m_SystemErr);
        if (this.tmpFile != null) {
            this.logFileContents(this.tmpFile);
            this.tmpFile.delete();
        }
    }

    private void removeKeyAndTrustTempFiles() {
        if (this.keyStoreTmpFile != null && this.keyStoreTmpFile.exists()) {
            this.keyStoreTmpFile.delete();
        }
        if (this.trustStoreTmpFile != null && this.trustStoreTmpFile.exists()) {
            this.trustStoreTmpFile.delete();
        }
    }

    private void logFileContents(File myFile) {
        FileReader myR = null;
        try {
            int char_read;
            myR = new FileReader(myFile);
            char[] buffer = new char[1024];
            while ((char_read = myR.read(buffer)) != -1) {
                String temp = null;
                for (int i = 0; i < buffer.length; ++i) {
                    temp = temp + Character.toString(buffer[i]);
                }
                if (temp == null) continue;
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "logFileContents", temp);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "logFileContents", "Error reading temp file from dmgr connection");
            LogUtils.logException(LOGGER, e, Level.FINE);
        }
        catch (IOException e) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "logFileContents", "Error reading temp file from dmgr connection");
            LogUtils.logException(LOGGER, e, Level.FINE);
        }
    }

    private boolean addJarsToRunTime() {
        LOGGER.entering(DmgrConnectionValidator.class.getName(), "addJarsToRunTime");
        String sWasHome = System.getProperty(S_WAS_HOME);
        File fileWasHome = new File(sWasHome);
        if (sWasHome == null) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "addJarsToRunTime", "Could not located WAS_HOME when trying to add jars.");
            return false;
        }
        try {
            int i;
            String sLibDir = fileWasHome.getAbsolutePath() + File.separator + S_LIB;
            String sPluginsDir = fileWasHome.getAbsolutePath() + File.separator + S_PLUGINS;
            for (i = 0; i < ARR_DEPENDENT_JARS_LIB.length; ++i) {
                ClassPathModifier.addFileToClassPath(sLibDir + File.separator + ARR_DEPENDENT_JARS_LIB[i]);
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "addJarsToRunTime", "Added jar: " + sPluginsDir + File.separator + ARR_DEPENDENT_JARS_LIB[i]);
            }
            for (i = 0; i < ARR_DEPENDENT_JARS_PLUGINS.length; ++i) {
                ClassPathModifier.addFileToClassPath(sPluginsDir + File.separator + ARR_DEPENDENT_JARS_PLUGINS[i]);
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "addJarsToRunTime", "Added jar: " + sPluginsDir + File.separator + ARR_DEPENDENT_JARS_PLUGINS[i]);
            }
        }
        catch (IOException e) {
            LogUtils.logException(LOGGER, e, Level.FINE);
            return false;
        }
        LOGGER.exiting(DmgrConnectionValidator.class.getName(), "addJarsToRunTime");
        return true;
    }
}

