/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.io.file.NativeFile;
import com.ibm.io.file.exception.AccessDeniedException;
import com.ibm.io.file.exception.NativeFileIOException;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.bootstrap.WSProfileProperties;
import com.ibm.ws.profile.utils.PrereqTemplateUtils;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.validators.GenericValidator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DiskSpaceValidator
extends GenericValidator {
    private static final Logger LOGGER = LoggerFactory.createLogger(DiskSpaceValidator.class);
    private static final String S_CLASS_NAME = DiskSpaceValidator.class.getName();

    public boolean runValidator() {
        LOGGER.entering(DiskSpaceValidator.class.getName(), "runValidator");
        boolean result = false;
        String sProfilePath = System.getProperty(this.sValidatorArgKey);
        String sTemplatePath = System.getProperty("templatePath");
        String sProfileName = System.getProperty("profileName");
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "runValidator", "profilePath:" + sProfilePath);
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "runValidator", "templatePath:" + sTemplatePath);
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "runValidator", "profileName:" + sProfileName);
        String sModeCreate = System.getProperty("create");
        String sModeAugment = System.getProperty("augment");
        String sMode = null;
        if (sModeCreate == null && sModeAugment == null) {
            result = false;
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("diskspace.error.noModeSpecified", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.exiting(DiskSpaceValidator.class.getName(), "runValidator");
            return false;
        }
        if (sModeCreate == null && sModeAugment.equals("")) {
            sMode = "augment";
        } else if (sModeCreate.equals("") && sModeAugment == null) {
            sMode = "create";
        } else if (sModeCreate.equals("") && sModeAugment.equals("")) {
            result = false;
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("diskspace.error.tooManyModes", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.exiting(DiskSpaceValidator.class.getName(), "runValidator");
            return result;
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "runValidator", "Current mode:" + sMode);
        int nRequiredSizeInMB = 0;
        if ((sProfilePath == null || sProfilePath.equals("")) && !sMode.equals("augment")) {
            result = false;
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("key.notset", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.sValidatorArgKey);
            LOGGER.exiting(DiskSpaceValidator.class.getName(), "runValidator");
            return result;
        }
        if (sTemplatePath == null || sTemplatePath.equals("")) {
            result = false;
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("key.notset", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), "templatePath");
            LOGGER.exiting(DiskSpaceValidator.class.getName(), "runValidator");
            return result;
        }
        if (sMode.equals("augment") && (sProfileName == null || sProfileName.equals(""))) {
            result = false;
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("key.notset", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), "profileName");
            LOGGER.exiting(DiskSpaceValidator.class.getName(), "runValidator");
            return result;
        }
        try {
            if (sMode.equals("create")) {
                nRequiredSizeInMB = PrereqTemplateUtils.getTotalTemplateSizeForStackCreation(new File(sTemplatePath));
            } else if (sMode.equals("augment")) {
                nRequiredSizeInMB = PrereqTemplateUtils.getTotalTemplateSizeForStackAugmentation(new File(sTemplatePath), sProfileName);
                sProfilePath = WSProfile.getProfile(sProfileName).getPath().getCanonicalPath();
            }
        }
        catch (WSProfileException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "WSProfileException - reading requried size");
            LogUtils.logException(LOGGER, e, Level.FINE);
            ResourceBundleUtils.getResourceBundleLocaleString("diskspace.invalid.params", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
        }
        catch (IOException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "IOException - reading required size");
            LogUtils.logException(LOGGER, e, Level.FINE);
            ResourceBundleUtils.getResourceBundleLocaleString("diskspace.invalid.params", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runValidator", "Detected required space (MB): " + nRequiredSizeInMB);
        double nFreeSpace = 0.0;
        try {
            String JNILocation = new WSProfileProperties().getProperty("WS_NATIVE_FILE_JNI_DIRECTORY");
            NativeFile.initializeLibrary(new File(JNILocation), null, true);
            if (!NativeFile.isNativeFileFunctionalityAvailable()) {
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "NativeFile functionality is not available");
                result = false;
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("diskspace.invalid.params", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                LOGGER.exiting(DiskSpaceValidator.class.getName(), "runValidator");
                return result;
            }
            NativeFile nfProfilePath = new NativeFile(new File(sProfilePath).getAbsolutePath());
            nFreeSpace = this.convertBytesToMB(nfProfilePath.getFreeSpace());
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runValidator", "Detected free space before conversion: " + nfProfilePath.getFreeSpace());
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runValidator", "Detected free space (MB): " + nFreeSpace);
        }
        catch (AccessDeniedException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "AccessDeniedException - reading free space");
            LogUtils.logException(LOGGER, e, Level.FINE);
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("diskspace.invalid.params", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
        }
        catch (NullPointerException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "NullPointerException - reading free space");
            LogUtils.logException(LOGGER, e, Level.FINE);
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("diskspace.invalid.params", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
        }
        catch (NativeFileIOException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "NativeFileIOException - reading free space");
            LogUtils.logException(LOGGER, e, Level.FINE);
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("diskspace.invalid.params", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
        }
        catch (FileNotFoundException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "FileNotFoundException - reading free space");
            LogUtils.logException(LOGGER, e, Level.FINE);
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("diskspace.invalid.params", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
        }
        catch (IOException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "IOException - reading free space");
            LogUtils.logException(LOGGER, e, Level.FINE);
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("diskspace.invalid.params", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
        }
        boolean bl = result = nFreeSpace > (double)nRequiredSizeInMB;
        if (!result) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("diskspace.insufficient", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
        }
        LOGGER.exiting(DiskSpaceValidator.class.getName(), "runValidator");
        return result;
    }

    private double convertBytesToMB(long bytes) {
        double dMB = 0.0;
        dMB = (double)bytes / 1024.0 / 1024.0;
        return dMB;
    }
}

