/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.validators.ConflictingArgsAreNotSetValidator;
import com.ibm.ws.ssl.utils.ProfileKeystoreUtils;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CertificateDNValidator
extends ConflictingArgsAreNotSetValidator {
    private static final String S_KEY_INVALID_DN = "CertificateDNValidator.invalid.dn";
    private static final Logger LOGGER = LoggerFactory.createLogger(CertificateDNValidator.class);
    private static final String S_CLASS_NAME = CertificateDNValidator.class.getName();

    public CertificateDNValidator() {
        if (this.getValidatorArgKey() != null) {
            if (this.getValidatorArgKey().equals("personalCertDN")) {
                this.m_asConflictingArgs = new String[]{"importPersonalCertKS"};
            } else if (this.getValidatorArgKey().equals("signingCertDN")) {
                this.m_asConflictingArgs = new String[]{"importSigningCertKS"};
            }
        }
    }

    public boolean runValidator() {
        LOGGER.entering(S_CLASS_NAME, "runValidator");
        boolean result = false;
        try {
            result = ProfileKeystoreUtils.checkDNString((String)this.sValidatorArgValue);
        }
        catch (Exception ex) {
            result = false;
        }
        if (!result) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString(S_KEY_INVALID_DN, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.sValidatorArgValue);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runValidator", this.getErrorOutput());
        }
        LOGGER.exiting(S_CLASS_NAME, "runValidator");
        return result;
    }
}

