/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import java.util.Vector;

public class VerifyLibraryAccess {
    public static void main(String[] args) {
        boolean fail = false;
        Vector<String> failedList = new Vector<String>(args.length);
        for (int i = 0; i < args.length; ++i) {
            String lib = args[i];
            System.out.println("Verfying shell can locate library " + lib + "....");
            try {
                System.loadLibrary(lib);
                continue;
            }
            catch (UnsatisfiedLinkError ule) {
                fail = true;
                failedList.add(lib);
                System.out.println("Unable to locate library " + lib + "!");
            }
        }
        if (fail) {
            String libString = "";
            for (int i = 0; i < failedList.size(); ++i) {
                libString = libString + " " + (String)failedList.elementAt(i);
            }
            System.out.println("***************************************************************************");
            System.out.println("The WebSphere for z/OS customization job was unable to access the following");
            System.out.println("libraries required by the customization process:");
            System.out.println(" ");
            System.out.println(libString);
            System.out.println(" ");
            System.out.println("Please verify that you have correctly followed the customization instructions");
            System.out.println("for STEPLIB or LPA/LNKLST before submitting this job again");
            System.out.println("****************************************************************************");
            System.exit(1);
        }
    }
}

