/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.utils.WSProfileUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemPropertiesUtils
extends com.ibm.ws.install.configmanager.utils.SystemPropertiesUtils {
    private static final String S_EMPTY = "";
    private static final Logger LOGGER = LoggerFactory.createLogger(SystemPropertiesUtils.class);
    private static final String S_CLASS_NAME = SystemPropertiesUtils.class.getName();

    public static void setJavaSystemPropertiesForConfigManagerBasedOnActionRegistry(String sProfileName, String sProfilePath, String sTemplatePath, String sNodeName, String sCellName, String sHostName, Map mapOptionalArgMap, String[] disabledActions, File fileActionRegistry) {
        LOGGER.entering(WSProfile.class.getName(), "setJavaSystemPropertiesForConfigManagerProfileBasedOnActionRegistry");
        System.setProperty("WS_CMT_ACTION_REGISTRY", fileActionRegistry.getAbsolutePath());
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "setJavaSystemPropertiesForConfigManagerBasedOnActionRegistry", "Action registry set to: " + fileActionRegistry.getAbsolutePath());
        SystemPropertiesUtils.setJavaSystemPropertiesForConfigManagerProfileOperation(sProfileName, sProfilePath, sTemplatePath, sNodeName, sCellName, sHostName, disabledActions, mapOptionalArgMap);
        LOGGER.exiting(WSProfile.class.getName(), "setJavaSystemPropertiesForConfigManagerProfileBasedOnActionRegistry");
    }

    public static void setJavaSystemPropertiesForConfigManagerProfileOperation(String sProfileName, String sProfilePath, String sTemplatePath, String sNodeName, String sCellName, String sHostName, String[] saDisabledActions, Map mapOptionalArgMap) {
        LOGGER.entering(WSProfile.class.getName(), "setJavaSystemPropertiesForConfigManagerProfileOperation");
        SystemPropertiesUtils.setJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap(mapOptionalArgMap);
        SystemPropertiesUtils.setSystemPropertyIfGivenValueIsNotNull("WS_CMT_CONF_DIR", sTemplatePath);
        SystemPropertiesUtils.setSystemPropertyForDisabledActions("WS_CMT_DISABLED_ACTIONS", saDisabledActions);
        SystemPropertiesUtils.setSystemPropertyIfGivenValueIsNotNull("WS_CMT_NODE_NAME", sNodeName);
        SystemPropertiesUtils.setSystemPropertyIfGivenValueIsNotNull("WS_CMT_CELL_NAME", sCellName);
        SystemPropertiesUtils.setSystemPropertyIfGivenValueIsNotNull("WS_CMT_HOST_NAME", sHostName);
        SystemPropertiesUtils.setSystemPropertyIfGivenValueIsNotNull("profilePath", sProfilePath);
        SystemPropertiesUtils.setSystemPropertyIfGivenValueIsNotNull("templatePath", sTemplatePath);
        SystemPropertiesUtils.setSystemPropertyIfGivenValueIsNotNull("profileName", sProfileName);
        LOGGER.exiting(WSProfile.class.getName(), "setJavaSystemPropertiesForConfigManagerProfileOperation");
    }

    public static void resetJavaSystemPropertiesForConfigManagerProfileCreationOrDeletion(Map mapOptionalArgMap) {
        LOGGER.entering(WSProfile.class.getName(), "resetJavaSystemPropertiesForConfigManagerProfileCreationOrDeletion");
        Properties propertiesCurrent = System.getProperties();
        propertiesCurrent.remove("WS_CMT_ACTION_REGISTRY");
        propertiesCurrent.remove("WS_CMT_CONF_DIR");
        propertiesCurrent.remove("WS_CMT_NODE_NAME");
        propertiesCurrent.remove("WS_CMT_CELL_NAME");
        propertiesCurrent.remove("WS_CMT_HOST_NAME");
        propertiesCurrent.remove("profilePath");
        propertiesCurrent.remove("templatePath");
        propertiesCurrent.remove("profileName");
        SystemPropertiesUtils.resetJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap(mapOptionalArgMap, propertiesCurrent);
        System.setProperties(propertiesCurrent);
        LOGGER.exiting(WSProfile.class.getName(), "resetJavaSystemPropertiesForConfigManagerProfileCreationOrDeletion");
    }

    private static void setSystemPropertyIfGivenValueIsNotNull(String sPropertyName, String sValue) {
        LOGGER.entering(WSProfile.class.getName(), "setSystemPropertyIfGivenValueIsNotNull");
        if (sValue != null) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "setSystemPropertyIfGivenValueIsNotNull", "Setting system property: " + sPropertyName);
            System.setProperty(sPropertyName, sValue);
        } else {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "setSystemPropertyIfGivenValueIsNotNull", "Skipping to set system property: " + sPropertyName + " as its value specified was null");
        }
        LOGGER.exiting(WSProfile.class.getName(), "setSystemPropertyIfGivenValueIsNotNull");
    }

    public static void setSystemPropertyForDisabledActions(String sPropertyName, String[] disabledActions) {
        String propertyValue = null;
        propertyValue = disabledActions == null || disabledActions.length == 0 ? S_EMPTY : SystemPropertiesUtils.buildProperty(disabledActions);
        System.setProperty(sPropertyName, propertyValue);
    }

    private static String buildProperty(String[] sa) {
        if (sa == null || sa.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < sa.length; ++i) {
            sb.append(sa[i]);
            sb.append(";");
        }
        return sb.toString();
    }

    public static Properties setJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap(Map mapOptionalArgMap) {
        LOGGER.entering(WSProfile.class.getName(), "setJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap");
        Properties propertiesCurrentSystem = (Properties)System.getProperties().clone();
        for (Object oKey : mapOptionalArgMap.keySet()) {
            String sKey = oKey.toString();
            Vector vsValues = (Vector)mapOptionalArgMap.get(oKey);
            if (vsValues.size() > 1) {
                for (int i = 0; i < vsValues.size(); ++i) {
                    System.setProperty(sKey + (i + 1), vsValues.elementAt(i).toString());
                }
            }
            if (vsValues.size() == 1) {
                System.setProperty(sKey, vsValues.elementAt(0).toString());
            }
            if (vsValues.size() != 0) continue;
            System.setProperty(sKey, S_EMPTY);
        }
        LOGGER.exiting(WSProfile.class.getName(), "setJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap");
        return propertiesCurrentSystem;
    }

    public static void resetJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap(Map mapOptionalArgMap, Properties propertiesCurrent) {
        LOGGER.entering(WSProfile.class.getName(), "resetJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap");
        for (Object oKey : mapOptionalArgMap.keySet()) {
            String sKey = oKey.toString();
            Vector vsValues = (Vector)mapOptionalArgMap.get(oKey);
            if (vsValues.size() > 1) {
                for (int i = 0; i < vsValues.size(); ++i) {
                    propertiesCurrent.remove(sKey + (i + 1));
                }
            }
            if (vsValues.size() > 1) continue;
            propertiesCurrent.remove(sKey);
        }
        LOGGER.exiting(WSProfile.class.getName(), "resetJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap");
    }

    public static void resetJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap(Map mapOptionalArgMap) {
        LOGGER.entering(WSProfile.class.getName(), "resetJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap");
        Properties propertiesCurrent = System.getProperties();
        SystemPropertiesUtils.resetJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap(mapOptionalArgMap, propertiesCurrent);
        LOGGER.exiting(WSProfile.class.getName(), "resetJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap");
    }

    public static void resetJavaSystemProperties(Properties previousSystemProperties) {
        LOGGER.entering(WSProfile.class.getName(), "resetJavaSystemProperties");
        System.setProperties(previousSystemProperties);
        LOGGER.exiting(WSProfile.class.getName(), "resetJavaSystemProperties");
    }

    public static String getWasInstallLocation() {
        LOGGER.entering(S_CLASS_NAME, "getWasInstallLocation");
        String sWasInstallLocation = null;
        sWasInstallLocation = System.getProperty("WAS_HOME");
        if (sWasInstallLocation != null && !sWasInstallLocation.equals(S_EMPTY)) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "getWasInstallLocation", "Returning WAS_HOME" + sWasInstallLocation);
            LOGGER.exiting(S_CLASS_NAME, "getWasInstallLocation");
            return sWasInstallLocation;
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "getWasInstallLocation", "WAS_HOME has not been specified");
        LOGGER.exiting(S_CLASS_NAME, "getWasInstallLocation");
        return sWasInstallLocation;
    }

    public static void setTemplateStackIntoSystemProperties(List<WSProfileTemplate> l_wsptTemplateStack) {
        LOGGER.entering(S_CLASS_NAME, "setTemplateStackIntoSystemProperties");
        for (int i = 0; i < l_wsptTemplateStack.size(); ++i) {
            System.setProperty("WS_CMT_TEMPLATE_STACK" + i, l_wsptTemplateStack.get(i).getProfileTemplatePath().getPath());
        }
        LOGGER.exiting(S_CLASS_NAME, "setTemplateStackIntoSystemProperties");
    }

    public static Vector<String> getTemplateStackFromSystemProperties() {
        LOGGER.entering(S_CLASS_NAME, "getTemplateStackFromSystemProperties");
        Vector<String> returnList = new Vector<String>();
        String sTemplateStack = new String();
        int i = 0;
        while ((sTemplateStack = System.getProperty("WS_CMT_TEMPLATE_STACK" + i)) != null) {
            returnList.add(sTemplateStack);
            ++i;
        }
        LOGGER.exiting(S_CLASS_NAME, "getTemplateStackFromSystemProperties");
        return returnList;
    }

    public static String getBaseLevelTemplateInStackFromSystemProperties() {
        LOGGER.entering(S_CLASS_NAME, "getBaseLevelTemplateInStackFromSystemProperties");
        Vector<String> l_sTemplateStack = SystemPropertiesUtils.getTemplateStackFromSystemProperties();
        if (l_sTemplateStack == null || l_sTemplateStack.isEmpty()) {
            LOGGER.exiting(S_CLASS_NAME, "getBaseLevelTemplateInStackFromSystemProperties");
            return null;
        }
        LOGGER.exiting(S_CLASS_NAME, "getBaseLevelTemplateInStackFromSystemProperties");
        return WSProfileUtils.getBaseLevelTemplateInStack(l_sTemplateStack);
    }

    public static String getTopLevelTemplateInStackFromSystemProperties() {
        LOGGER.entering(S_CLASS_NAME, "getTopLevelTemplateInStackFromSystemProperties");
        Vector<String> l_sTemplateStack = SystemPropertiesUtils.getTemplateStackFromSystemProperties();
        if (l_sTemplateStack == null || l_sTemplateStack.isEmpty()) {
            LOGGER.exiting(S_CLASS_NAME, "getTopLevelTemplateInStackFromSystemProperties");
            return null;
        }
        LOGGER.exiting(S_CLASS_NAME, "getTopLevelTemplateInStackFromSystemProperties");
        return WSProfileUtils.getTopLevelTemplateInStack(l_sTemplateStack);
    }
}

