/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResponseFileUtils {
    private static final Logger LOGGER = LoggerFactory.createLogger(ResponseFileUtils.class);
    private static final String S_CLASS_NAME = ResponseFileUtils.class.getName();
    private static char[] AC_SPECIAL_CHARS_NOT_TO_UNICODE_ESCAPE = new char[]{'\b', '\t', '\n', '\f', '\r', '\"', '\'', '\\'};
    private static final String S_UNICODE_ESCAPE_STRING = "\\u";
    private static final char C_LOWER_ASCII_LIMIT = ' ';
    private static final char C_UPPER_ASCII_LIMIT = '~';
    private static final String S_DEFAULT_OUTPUT_ENCODING = "ISO-8859-1";
    private static final String S_JAVA_FILE_ENCODING_PROPERTY = "file.encoding";

    public static String encodeResponseFile(String sInputResponseFilePath) throws FileNotFoundException, IOException {
        LOGGER.entering(ResponseFileUtils.class.getName(), "encodeResponseFile");
        File fileInputFile = new File(sInputResponseFilePath);
        String sOutputFileName = ResponseFileUtils.createEncodedFileName(fileInputFile.getName());
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "encodeResponseFile", "Encoded response file name =" + sOutputFileName);
        String sEncoding = ResponseFileUtils.determineNativeEncoding();
        ResponseFileUtils.encodeFile(sEncoding, sInputResponseFilePath, sOutputFileName);
        ResponseFileUtils.markFileForDeletionOnExit(sOutputFileName);
        LOGGER.exiting(ResponseFileUtils.class.getName(), "encodeResponseFile");
        return sOutputFileName;
    }

    private static void encodeFile(String sEncoding, String sInputResponseFilePath, String sOutputFileName) throws FileNotFoundException, IOException {
        int len;
        FileInputStream fisInputFile = null;
        FileOutputStream fosOutputFile = null;
        BufferedReader brInputFile = null;
        BufferedWriter bwOutputFile = null;
        fisInputFile = new FileInputStream(sInputResponseFilePath);
        brInputFile = new BufferedReader(new InputStreamReader((InputStream)fisInputFile, sEncoding));
        fosOutputFile = new FileOutputStream(sOutputFileName);
        bwOutputFile = new BufferedWriter(new OutputStreamWriter((OutputStream)fosOutputFile, S_DEFAULT_OUTPUT_ENCODING));
        char[] buffer = new char[4096];
        while ((len = brInputFile.read(buffer)) != -1) {
            bwOutputFile.write(ResponseFileUtils.escapeBuffer(buffer, len));
        }
        brInputFile.close();
        bwOutputFile.flush();
        bwOutputFile.close();
    }

    private static String escapeBuffer(char[] buffer, int length) {
        String escapedString = "";
        for (int i = 0; i < length; ++i) {
            escapedString = ResponseFileUtils.doesCharNeedUnicodeEscape(buffer[i]) ? escapedString + ResponseFileUtils.createUnicodeEscapedString(buffer[i]) : escapedString + buffer[i];
        }
        return escapedString;
    }

    private static String createUnicodeEscapedString(char charToEscape) {
        String escapedString = "";
        String unicodeEscapeString = S_UNICODE_ESCAPE_STRING;
        String hexEscapedString = Integer.toHexString(charToEscape);
        while (hexEscapedString.length() < 4) {
            hexEscapedString = "0" + hexEscapedString;
        }
        escapedString = escapedString + unicodeEscapeString;
        escapedString = escapedString + hexEscapedString;
        return escapedString;
    }

    private static void markFileForDeletionOnExit(String sOutputFileName) {
        LOGGER.entering(ResponseFileUtils.class.getName(), "markFileForDeletionOnExit");
        File fileToDelete = new File(sOutputFileName);
        fileToDelete.deleteOnExit();
        LOGGER.exiting(ResponseFileUtils.class.getName(), "markFileForDeletionOnExit");
    }

    private static String createEncodedFileName(String inputFileName) throws IOException {
        LOGGER.entering(ResponseFileUtils.class.getName(), "");
        String sFileName = null;
        File fileEncodedFile = File.createTempFile(inputFileName, null);
        sFileName = fileEncodedFile.getCanonicalPath();
        fileEncodedFile.delete();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "createEncodedFileName", "Encoded file name=" + sFileName);
        LOGGER.exiting(ResponseFileUtils.class.getName(), "");
        return sFileName;
    }

    private static String determineNativeEncoding() {
        LOGGER.entering(ResponseFileUtils.class.getName(), "determineNativeEncoding");
        String sPlatformEncoding = System.getProperty(S_JAVA_FILE_ENCODING_PROPERTY);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "determineNativeEncoding", "Native file encoding=" + sPlatformEncoding);
        LOGGER.exiting(ResponseFileUtils.class.getName(), "determineNativeEncoding");
        return sPlatformEncoding;
    }

    private static boolean doesCharNeedUnicodeEscape(char charToBeScrutinized) {
        LOGGER.entering(ResponseFileUtils.class.getName(), "doesCharNeedUnicodeEscape");
        if (charToBeScrutinized >= ' ' && charToBeScrutinized <= '~' || ResponseFileUtils.isSpecialCharacter(charToBeScrutinized)) {
            return false;
        }
        LOGGER.logp(Level.FINER, S_CLASS_NAME, "doesCharNeedUnicodeEscape", "Does character " + charToBeScrutinized + " need a unicode escape " + true);
        LOGGER.exiting(ResponseFileUtils.class.getName(), "doesCharNeedUnicodeEscape");
        return true;
    }

    private static boolean isSpecialCharacter(char charToBeScrutinized) {
        LOGGER.entering(ResponseFileUtils.class.getName(), "isSpecialCharacter");
        for (int i = 0; i < AC_SPECIAL_CHARS_NOT_TO_UNICODE_ESCAPE.length; ++i) {
            if (charToBeScrutinized != AC_SPECIAL_CHARS_NOT_TO_UNICODE_ESCAPE[i]) continue;
            return true;
        }
        LOGGER.exiting(ResponseFileUtils.class.getName(), "isSpecialCharacter");
        return false;
    }

    public static Map retrieveResponseFileArgs(String sPath) throws IOException {
        String sEncodedResponseFilePath = ResponseFileUtils.encodeResponseFile(sPath);
        Properties propertiesIn = new Properties();
        FileInputStream fis = new FileInputStream(sEncodedResponseFilePath);
        propertiesIn.load(fis);
        new File(sEncodedResponseFilePath).delete();
        if (fis != null) {
            fis.close();
        }
        return propertiesIn;
    }
}

