/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.ws.profile.prereqtree.DataExpressionTree;
import com.ibm.ws.profile.prereqtree.ExpressionTreeConstants;
import com.ibm.ws.profile.prereqtree.OperatorExpressionTree;
import com.ibm.wsspi.profile.prereqtree.GenericExpressionTree;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrereqTreeUtils {
    private static boolean checkIfComplete(GenericExpressionTree tree, boolean currentStatus) {
        if (!tree.isLeaf() && currentStatus) {
            if (!tree.isRoot() && PrereqTreeUtils.isRootAnOR(tree) && PrereqTreeUtils.isRootAnAND(tree.getParent())) {
                return false;
            }
            return PrereqTreeUtils.checkIfComplete(tree.getLeftChild(), true) && PrereqTreeUtils.checkIfComplete(tree.getRightChild(), true);
        }
        return tree.isLeaf() && currentStatus;
    }

    public static boolean treeHasORAfterAND(GenericExpressionTree tree) {
        return !PrereqTreeUtils.checkIfComplete(tree, true);
    }

    public static GenericExpressionTree convertToDNF(GenericExpressionTree expTree) {
        expTree = PrereqTreeUtils.convertToDNFRepresentation(expTree);
        while (PrereqTreeUtils.treeHasORAfterAND(expTree)) {
            expTree = PrereqTreeUtils.convertToDNFRepresentation(expTree);
        }
        return expTree;
    }

    private static GenericExpressionTree convertToDNFRepresentation(GenericExpressionTree expTree) {
        if (PrereqTreeUtils.isRootAnOR(expTree)) {
            expTree.setLeftChild(PrereqTreeUtils.convertToDNFRepresentation(expTree.getLeftChild()));
            expTree.getLeftChild().setParent(expTree);
            expTree.setRightChild(PrereqTreeUtils.convertToDNFRepresentation(expTree.getRightChild()));
            expTree.getRightChild().setParent(expTree);
            return expTree;
        }
        if (PrereqTreeUtils.isRootAnAND(expTree)) {
            if (PrereqTreeUtils.isRootAnOR(expTree.getRightChild()) || PrereqTreeUtils.isRootAnOR(expTree.getLeftChild())) {
                expTree = PrereqTreeUtils.performORTransform(expTree);
                expTree = PrereqTreeUtils.convertToDNFRepresentation(expTree);
                return expTree;
            }
            expTree.setLeftChild(PrereqTreeUtils.convertToDNFRepresentation(expTree.getLeftChild()));
            expTree.getLeftChild().setParent(expTree);
            expTree.setRightChild(PrereqTreeUtils.convertToDNFRepresentation(expTree.getRightChild()));
            expTree.getRightChild().setParent(expTree);
            return expTree;
        }
        return expTree;
    }

    private static GenericExpressionTree performORTransform(GenericExpressionTree expTree) {
        OperatorExpressionTree newRoot = new OperatorExpressionTree("OR", null, null);
        OperatorExpressionTree newLeft = new OperatorExpressionTree("AND", null, null);
        OperatorExpressionTree newRight = new OperatorExpressionTree("AND", null, null);
        if (PrereqTreeUtils.isRootAnOR(expTree.getLeftChild())) {
            newLeft.setLeftChild(expTree.getLeftChild().getLeftChild());
            newLeft.setRightChild(expTree.getRightChild());
            newLeft.setParent(newRoot);
            newRight.setLeftChild(expTree.getLeftChild().getRightChild());
            newRight.setRightChild(expTree.getRightChild());
            newRight.setParent(newRoot);
        } else if (PrereqTreeUtils.isRootAnOR(expTree.getRightChild())) {
            newLeft.setLeftChild(expTree.getLeftChild());
            newLeft.setRightChild(expTree.getRightChild().getLeftChild());
            newLeft.setParent(newRoot);
            newRight.setLeftChild(expTree.getLeftChild());
            newRight.setRightChild(expTree.getRightChild().getRightChild());
            newRight.setParent(newRoot);
        }
        newRoot.setLeftChild(newLeft);
        newRoot.setRightChild(newRight);
        if (!expTree.isRoot()) {
            GenericExpressionTree parent = expTree.getParent();
            if (parent.isEqualToLeftChild(expTree)) {
                parent.setLeftChild(newRoot);
                newRoot.setParent(parent);
            } else {
                parent.setRightChild(newRoot);
                newRoot.setParent(parent);
            }
        }
        expTree = newRoot;
        return expTree;
    }

    public static List getExpressionsFromExpressionTree(GenericExpressionTree expTree) {
        Vector v_expressions = new Vector();
        v_expressions = (Vector)PrereqTreeUtils.getExpressionsFromExpressionTree(expTree, v_expressions);
        return v_expressions;
    }

    private static List<List> getExpressionsFromExpressionTree(GenericExpressionTree expTree, List<List> v_expressions) {
        String s_value = expTree.getData().toString();
        if (s_value != null && s_value.equals("AND")) {
            v_expressions.add(PrereqTreeUtils.getLeafsAsNodes(expTree));
            return v_expressions;
        }
        if (expTree.isLeaf()) {
            v_expressions.add(PrereqTreeUtils.getLeafsAsNodes(expTree));
            return v_expressions;
        }
        v_expressions = PrereqTreeUtils.getExpressionsFromExpressionTree(expTree.getLeftChild(), v_expressions);
        return PrereqTreeUtils.getExpressionsFromExpressionTree(expTree.getRightChild(), v_expressions);
    }

    public static Vector<GenericExpressionTree> getAllANDExpressionTrees(GenericExpressionTree expTree) {
        Vector<GenericExpressionTree> v_expressions = new Vector<GenericExpressionTree>();
        v_expressions = PrereqTreeUtils.getAllANDExpressionTrees(expTree, v_expressions);
        return v_expressions;
    }

    private static Vector<GenericExpressionTree> getAllANDExpressionTrees(GenericExpressionTree expTree, Vector<GenericExpressionTree> v_expressions) {
        if (expTree.isLeaf()) {
            v_expressions.add(expTree);
            return v_expressions;
        }
        String s_value = (String)expTree.getData();
        if (s_value != null && s_value.equals("AND")) {
            v_expressions.add(expTree);
            return v_expressions;
        }
        v_expressions = PrereqTreeUtils.getAllANDExpressionTrees(expTree.getLeftChild(), v_expressions);
        return PrereqTreeUtils.getAllANDExpressionTrees(expTree.getRightChild(), v_expressions);
    }

    public static Vector<GenericExpressionTree> getLeafsAsNodes(GenericExpressionTree expTree) {
        Vector vector = new Vector();
        vector = (Vector)PrereqTreeUtils.getLeafsAsNodes(expTree, vector);
        return vector;
    }

    private static List<GenericExpressionTree> getLeafsAsNodes(GenericExpressionTree expTree, List<GenericExpressionTree> v_leafs) {
        if (expTree.isLeaf()) {
            v_leafs.add(expTree);
            return v_leafs;
        }
        v_leafs = PrereqTreeUtils.getLeafsAsNodes(expTree.getLeftChild(), v_leafs);
        return PrereqTreeUtils.getLeafsAsNodes(expTree.getRightChild(), v_leafs);
    }

    public static boolean isRootAnOR(GenericExpressionTree tree) {
        if (tree instanceof OperatorExpressionTree) {
            return tree.getData().equals("OR");
        }
        return false;
    }

    public static boolean isRootAnAND(GenericExpressionTree tree) {
        if (tree instanceof OperatorExpressionTree) {
            return tree.getData().equals("AND");
        }
        return false;
    }

    public static boolean isRootAnOperator(GenericExpressionTree tree) {
        return tree instanceof OperatorExpressionTree;
    }

    public static boolean isRootAnOperand(GenericExpressionTree tree) {
        return tree instanceof DataExpressionTree;
    }

    public static GenericExpressionTree getANDNode() {
        OperatorExpressionTree tree = new OperatorExpressionTree(null, null);
        tree.setData("AND");
        return tree;
    }

    public static GenericExpressionTree getORNode() {
        OperatorExpressionTree tree = new OperatorExpressionTree(null, null);
        tree.setData("OR");
        return tree;
    }

    public static boolean treeContainsLeafs(GenericExpressionTree tree, List l_leafs) {
        if (tree == null) {
            return false;
        }
        Vector<GenericExpressionTree> treeLeafs = PrereqTreeUtils.getLeafsAsNodes(tree);
        for (int i = 0; i < l_leafs.size(); ++i) {
            GenericExpressionTree currentCheck = (GenericExpressionTree)l_leafs.get(i);
            Object data = currentCheck.getData();
            boolean found = false;
            for (int j = 0; j < treeLeafs.size() && !found; ++j) {
                GenericExpressionTree control = treeLeafs.get(j);
                Object controlData = control.getData();
                if (!controlData.equals(data)) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnOperator(String s_name) {
        if (s_name == null) {
            return false;
        }
        for (int i = 0; i < ExpressionTreeConstants.SA_OPERATOR_TAGS.length; ++i) {
            if (!s_name.equalsIgnoreCase(ExpressionTreeConstants.SA_OPERATOR_TAGS[i])) continue;
            return true;
        }
        return false;
    }
}

