/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.ws.install.configmanager.ConfigManager;
import com.ibm.ws.install.configmanager.actionengine.ConfigAction;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.utils.PrereqTemplateUtils;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionalConfigUtils {
    private static final Logger LOGGER = LoggerFactory.createLogger(OptionalConfigUtils.class);
    private static final String S_CLASS_NAME = OptionalConfigUtils.class.getName();

    public static List getOptionalConfigActionsList(String s_templatePath, String s_mode, String s_profileName) {
        LOGGER.entering(OptionalConfigUtils.class.getName(), "getOptionalConfigActionsList");
        Vector v_optionalConfigActions = new Vector();
        Vector v_templatePrereqs = (Vector)PrereqTemplateUtils.getListOfTemplatePathsForMode(s_mode, s_profileName, s_templatePath);
        Vector v_nonOptionalConfigActions = (Vector)OptionalConfigUtils.getRequiredConfigActions(v_templatePrereqs);
        for (int i = v_templatePrereqs.size() - 1; i >= 0; --i) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getOptionalConfigActionsList", "Scanning for optional config actions in: " + ((WSProfileTemplate)v_templatePrereqs.get(i)).getProfileTemplatePath().getAbsolutePath());
            Vector temp = new Vector();
            temp = (Vector)ConfigManager.getOptionalConfigActionsList(((WSProfileTemplate)v_templatePrereqs.get(i)).getProfileTemplatePath().getAbsolutePath());
            v_optionalConfigActions = (Vector)OptionalConfigUtils.add(temp, v_optionalConfigActions, v_nonOptionalConfigActions);
        }
        LOGGER.exiting(OptionalConfigUtils.class.getName(), "getOptionalConfigActionsList");
        return v_optionalConfigActions;
    }

    private static List getRequiredConfigActions(Vector<WSProfileTemplate> wsptPrereqs) {
        Vector<String> v_list = new Vector<String>();
        if (wsptPrereqs.size() <= 0) {
            return v_list;
        }
        for (int i = 0; i < wsptPrereqs.size(); ++i) {
            WSProfileTemplate wspt = wsptPrereqs.get(i);
            Vector tmp = (Vector)ConfigManager.getRequiredConfigActionsList(wspt.getProfileTemplatePath().getAbsolutePath());
            for (int j = 0; j < tmp.size(); ++j) {
                ConfigAction ca_tmp = (ConfigAction)tmp.get(j);
                if (v_list.contains(ca_tmp.getActionName())) continue;
                v_list.add(ca_tmp.getActionName());
            }
        }
        return v_list;
    }

    private static List<ConfigAction> add(List<ConfigAction> src, List<ConfigAction> dest, List<ConfigAction> noAdd) {
        for (int i = 0; i < src.size(); ++i) {
            if (noAdd.contains(src.get(i).getActionName())) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "add", src.get(i).getActionName() + " is required in at least one occurence, " + "not included in list of available optional config actions");
                continue;
            }
            if (dest.contains(src.get(i))) continue;
            if (dest.size() == 0) {
                dest.add(src.get(i));
                continue;
            }
            int index = OptionalConfigUtils.findIndexOfCAWithSameName(dest, src.get(i).getActionName());
            if (index == -1) {
                dest.add(src.get(i));
                continue;
            }
            dest.add(index + 1, src.get(i));
        }
        return dest;
    }

    private static int findIndexOfCAWithSameName(List dest, String actionName) {
        int index = -1;
        for (int i = dest.size() - 1; i >= 0; --i) {
            if (!((ConfigAction)dest.get(i)).getActionName().equals(actionName)) continue;
            index = i;
            break;
        }
        return index;
    }
}

