/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.io.file.NativeFile;
import com.ibm.io.file.exception.AccessDeniedException;
import com.ibm.io.file.exception.NativeFileIOException;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.profile.bootstrap.WSProfileProperties;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.registry.Profile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils
extends com.ibm.ws.install.configmanager.utils.FileUtils {
    private static final int N_IO_BUFFER_SIZE = 4096;
    private static final String S_TMP_FILE_PREFIX = "~$WSP";
    private static final Logger LOGGER = LoggerFactory.createLogger(FileUtils.class);
    private static final String S_CLASS_NAME = FileUtils.class.getName();
    private static final String S_ZIP_READING_ERROR = "WSProfile.WSProfile.zipReadingError";
    private static final String S_YES = "yes";
    private static final String S_INDENT_AMOUNT = "{http://xml.apache.org/xslt}indent-amount";
    private static final String S_N_INDENT_AMOUNT = "4";

    public static void copyFile(File fileSource, File fileDestination) throws FileNotFoundException, IOException {
        int nBytesRead;
        FileInputStream inputstream = new FileInputStream(fileSource);
        FileOutputStream outputstream = new FileOutputStream(fileDestination);
        byte[] abBuffer = new byte[4096];
        while ((nBytesRead = ((InputStream)inputstream).read(abBuffer)) > 0) {
            ((OutputStream)outputstream).write(abBuffer, 0, nBytesRead);
        }
        ((InputStream)inputstream).close();
        ((OutputStream)outputstream).close();
    }

    public static void createShellScript(File file, String sText) throws FileNotFoundException, IOException {
        FileOutputStream outputstream = new FileOutputStream(file);
        String sEncoding = PlatformConstants.getProperEncodingForCurrentOSShellScripts();
        ((OutputStream)outputstream).write(sText.getBytes(sEncoding));
        ((OutputStream)outputstream).close();
    }

    public static boolean isDirectoryWritable(File filePath) {
        if (filePath.exists()) {
            try {
                File fileTmp = File.createTempFile(S_TMP_FILE_PREFIX, null, filePath);
                fileTmp.delete();
            }
            catch (IOException e) {
                return false;
            }
        } else {
            if (!filePath.mkdirs()) {
                return false;
            }
            filePath.delete();
        }
        return true;
    }

    public static String readShellScript(File file) throws IOException {
        if (file != null && file.exists()) {
            String sEncoding = PlatformConstants.getProperEncodingForCurrentOSShellScripts();
            FileInputStream fileinputstream = null;
            fileinputstream = new FileInputStream(file.getAbsolutePath());
            byte[] abBuffer = new byte[fileinputstream.available()];
            fileinputstream.read(abBuffer);
            String sFileContents = new String(abBuffer, sEncoding);
            fileinputstream.close();
            return sFileContents;
        }
        return null;
    }

    public static Vector convertStringListToFileVector(List listPaths) {
        Vector<File> v_filePaths = new Vector<File>(listPaths.size());
        for (int i = 0; i < listPaths.size(); ++i) {
            v_filePaths.add(new File((String)listPaths.get(i)));
        }
        return v_filePaths;
    }

    public static void intializeNativeFileFunctionality() {
        String JNILocation = null;
        try {
            JNILocation = new WSProfileProperties().getProperty("WS_NATIVE_FILE_JNI_DIRECTORY");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        NativeFile.initializeLibrary(new File(JNILocation), null, true);
    }

    public static boolean isNativeFileFunctionalityAvailable() {
        try {
            String JNILocation = new WSProfileProperties().getProperty("WS_NATIVE_FILE_JNI_DIRECTORY");
            NativeFile.initializeLibrary(new File(JNILocation), null, true);
            if (!NativeFile.isNativeFileFunctionalityAvailable()) {
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "NativeFile functionality is not available");
                LOGGER.exiting(FileUtils.class.getName(), "runValidator");
                return false;
            }
        }
        catch (AccessDeniedException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "AccessDeniedException - reading free space");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", ResourceBundleUtils.getResourceBundleLocaleString("diskspace.invalid.params", "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"));
        }
        catch (NullPointerException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "NullPointerException - reading free space");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", ResourceBundleUtils.getResourceBundleLocaleString("diskspace.invalid.params", "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"));
        }
        catch (NativeFileIOException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "NativeFileIOException - reading free space");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", ResourceBundleUtils.getResourceBundleLocaleString("diskspace.invalid.params", "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"));
        }
        catch (FileNotFoundException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "FileNotFoundException - reading free space");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", ResourceBundleUtils.getResourceBundleLocaleString("diskspace.invalid.params", "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"));
        }
        catch (IOException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "IOException - reading free space");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", ResourceBundleUtils.getResourceBundleLocaleString("diskspace.invalid.params", "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"));
        }
        return true;
    }

    public static String getProfileFileSystemSize(Profile profile) {
        long profileSize = 0L;
        FileUtils.intializeNativeFileFunctionality();
        if (FileUtils.isNativeFileFunctionalityAvailable()) {
            File profileFile = null;
            try {
                profileFile = WSProfile.getProfileLocation(profile.getName());
            }
            catch (WSProfileException e) {
                e.printStackTrace();
            }
            NativeFile backupProfile = new NativeFile(profileFile);
            try {
                profileSize = backupProfile.getFileSystemSize();
            }
            catch (AccessDeniedException e) {
                e.printStackTrace();
            }
            catch (NativeFileIOException e) {
                e.printStackTrace();
            }
        }
        return String.valueOf(profileSize);
    }

    public static double convertBytesToMB(long bytes) {
        double dMB = 0.0;
        dMB = (double)bytes / 1024.0 / 1024.0;
        return dMB;
    }

    public static InputStream getInputStreamFromZipFile(String backupFile, String fileName) throws WSProfileException {
        InputStream is;
        try {
            ZipFile zipfileBackup = new ZipFile(backupFile);
            is = zipfileBackup.getInputStream(zipfileBackup.getEntry(fileName));
        }
        catch (ZipException e) {
            LogUtils.logException(LOGGER, e);
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_ZIP_READING_ERROR, fileName));
        }
        catch (IOException e) {
            LogUtils.logException(LOGGER, e);
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_ZIP_READING_ERROR, fileName));
        }
        return is;
    }

    public static void saveDocumentToFile(Document document, File file) throws WSProfileException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource domsource = new DOMSource(document);
            StreamResult streamresult = new StreamResult(file);
            transformer.setOutputProperty("indent", S_YES);
            transformer.setOutputProperty(S_INDENT_AMOUNT, S_N_INDENT_AMOUNT);
            transformer.transform(domsource, streamresult);
        }
        catch (TransformerConfigurationException e) {
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
        }
        catch (TransformerException e) {
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
        }
    }

    public static List<File> convertFileListIntoCanonicalForm(List listFiles) throws IOException {
        Vector<File> listCanonicalFiles = new Vector<File>();
        for (int i = 0; i < listFiles.size(); ++i) {
            listCanonicalFiles.add(i, ((File)listFiles.get(i)).getCanonicalFile());
        }
        return listCanonicalFiles;
    }
}

