/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.datastore.WSProfileDataStore;
import com.ibm.ws.profile.prereqtree.WSProfileDisabledAction;
import com.ibm.ws.profile.prereqtree.WSProfileTemplateExpressionTree;
import com.ibm.ws.profile.utils.PrereqTreeUtils;
import com.ibm.wsspi.profile.WSProfileTemplate;
import com.ibm.wsspi.profile.prereqtree.GenericExpressionTree;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisabledActionsUtil {
    private static final String S_LEFT_DELIM = "<";
    private static final String S_RIGHT_DELIM = ">";
    private static final String S_DELIM_PATTERN = "<|>";
    private static final Logger LOGGER = LoggerFactory.createLogger(DisabledActionsUtil.class);
    private static final String S_CLASS_NAME = DisabledActionsUtil.class.getName();

    public Vector<WSProfileTemplate> decorateProfileTemplatesWithDisabledActions(Vector<WSProfileTemplate> v) {
        LOGGER.entering(S_CLASS_NAME, "decorateProfileTemplateWithDisabledActions");
        if (v == null || v.size() == 0) {
            LOGGER.exiting(S_CLASS_NAME, "decorateProfileTemplateWithDisabledActions");
            return v;
        }
        HashMap<Object, Object> templateDisabledActionsHash = new HashMap();
        templateDisabledActionsHash = this.getCompleteTemplateDisabledActionsMapping(v);
        for (int i = 0; i < v.size(); ++i) {
            WSProfileTemplate t = v.get(i);
            String k = t.getProfileTemplatePath().getAbsolutePath();
            Vector das = (Vector)templateDisabledActionsHash.get(k);
            Vector<String> dasas = this.convertWSProfileDisabledActionsToStrings(das);
            t.setDisabledActions(dasas);
            if (dasas == null || dasas.size() <= 0) continue;
            String[] s = new String[]{};
            String[] disabledActions = dasas.toArray(s);
            WSProfileDataStore.setDisabledActions(k, disabledActions);
        }
        LOGGER.exiting(S_CLASS_NAME, "decorateProfileTemplateWithDisabledActions");
        return v;
    }

    protected HashMap<String, Vector<WSProfileDisabledAction>> getCompleteTemplateDisabledActionsMapping(Vector<WSProfileTemplate> templates) {
        LOGGER.entering(S_CLASS_NAME, "getCompleteTemplateDisabledActionsMapping");
        HashMap<String, Vector<WSProfileDisabledAction>> templateDisabledActionsHash = new HashMap<String, Vector<WSProfileDisabledAction>>();
        StringBuffer qualifiedHashKey = new StringBuffer();
        for (int i = templates.size() - 1; i >= 0; --i) {
            WSProfileTemplate t = templates.get(i);
            qualifiedHashKey = qualifiedHashKey.append(S_LEFT_DELIM + t.getProfileTemplatePath() + S_RIGHT_DELIM);
            GenericExpressionTree dnfTree = t.getPrereqTemplateTree();
            if (dnfTree != null) {
                dnfTree = PrereqTreeUtils.convertToDNF(dnfTree);
            }
            templateDisabledActionsHash = this.buildTemplateDisabledActionsHash(dnfTree, templateDisabledActionsHash, templates, qualifiedHashKey);
        }
        HashMap<String, Vector<WSProfileDisabledAction>> unqualifiedTemplateDisabledActionsHash = new HashMap<String, Vector<WSProfileDisabledAction>>();
        Set keys = templateDisabledActionsHash.keySet();
        for (String qualifiedKey : keys) {
            Vector qdas = (Vector)templateDisabledActionsHash.get(qualifiedKey);
            String[] qualifiedKeyComponents = qualifiedKey.split(S_DELIM_PATTERN);
            String unqualifiedKey = qualifiedKeyComponents[qualifiedKeyComponents.length - 1];
            if (!unqualifiedTemplateDisabledActionsHash.containsKey(unqualifiedKey)) {
                unqualifiedTemplateDisabledActionsHash.put(unqualifiedKey, qdas);
                continue;
            }
            Vector<WSProfileDisabledAction> uda = unqualifiedTemplateDisabledActionsHash.get(unqualifiedKey);
            for (int i = 0; i < qdas.size(); ++i) {
                boolean disabledActionAlreadyPercolated = false;
                for (int j = 0; j < uda.size(); ++j) {
                    if (!((WSProfileDisabledAction)qdas.get(i)).getDisabledActionAlias().equals(uda.get(j).getDisabledActionAlias())) continue;
                    disabledActionAlreadyPercolated = true;
                    break;
                }
                if (disabledActionAlreadyPercolated) continue;
                uda.add((WSProfileDisabledAction)qdas.get(i));
            }
        }
        LOGGER.exiting(S_CLASS_NAME, "getCompleteTemplateDisabledActionsMapping");
        return unqualifiedTemplateDisabledActionsHash;
    }

    protected HashMap<String, Vector<WSProfileDisabledAction>> buildTemplateDisabledActionsHash(GenericExpressionTree e, HashMap<String, Vector<WSProfileDisabledAction>> hash, Vector<WSProfileTemplate> relevantTemplates, StringBuffer qualifiedHashKey) {
        LOGGER.entering(S_CLASS_NAME, "buildTemplateDisabledActionHash");
        if (e == null) {
            LOGGER.exiting(S_CLASS_NAME, "buildTemplateDisabledActionHash");
            return hash;
        }
        if (e.getType().equals("expressionType.template")) {
            WSProfileTemplateExpressionTree pet = (WSProfileTemplateExpressionTree)e;
            if (this.isPrereqFileRelevant(pet.getPrereqData().getPrereqFile().getAbsolutePath(), relevantTemplates)) {
                String k = pet.getPrereqData().getPrereqFile().getAbsolutePath();
                k = qualifiedHashKey + S_LEFT_DELIM + k + S_RIGHT_DELIM;
                if (!hash.containsKey(k)) {
                    Vector<WSProfileDisabledAction> v = pet.getPrereqData().getDisabledActions();
                    hash.put(k, v);
                }
            }
            LOGGER.exiting(S_CLASS_NAME, "buildTemplateDisabledActionHash");
            return hash;
        }
        if (e.getData().toString().equals("AND") && !this.isBranchRelevant(e, relevantTemplates)) {
            LOGGER.exiting(S_CLASS_NAME, "buildTemplateDisabledActionHash");
            return hash;
        }
        hash = this.buildTemplateDisabledActionsHash(e.getLeftChild(), hash, relevantTemplates, qualifiedHashKey);
        hash = this.buildTemplateDisabledActionsHash(e.getRightChild(), hash, relevantTemplates, qualifiedHashKey);
        LOGGER.exiting(S_CLASS_NAME, "buildTemplateDisabledActionHash");
        return hash;
    }

    public boolean isBranchRelevant(GenericExpressionTree e, Vector<WSProfileTemplate> relevantTemplates) {
        LOGGER.entering(S_CLASS_NAME, "isBranchRelevant");
        if (e == null) {
            LOGGER.exiting(S_CLASS_NAME, "isBranchRelevant");
            return true;
        }
        if (e.getType().equals("expressionType.template")) {
            LOGGER.exiting(S_CLASS_NAME, "isBranchRelevant");
            return this.isPrereqFileRelevant(((WSProfileTemplateExpressionTree)e).getPrereqData().getPrereqFile().getAbsolutePath(), relevantTemplates);
        }
        LOGGER.exiting(S_CLASS_NAME, "isBranchRelevant");
        return this.isBranchRelevant(e.getLeftChild(), relevantTemplates) && this.isBranchRelevant(e.getRightChild(), relevantTemplates);
    }

    private boolean isPrereqFileRelevant(String prereqFilePath, Vector<WSProfileTemplate> relevantTemplates) {
        LOGGER.entering(S_CLASS_NAME, "isPrereqFileRelevant");
        for (int i = 0; i < relevantTemplates.size(); ++i) {
            if (!prereqFilePath.equals(relevantTemplates.get(i).getProfileTemplatePath().getAbsolutePath())) continue;
            LOGGER.exiting(S_CLASS_NAME, "isPrereqFileRelevant");
            return true;
        }
        LOGGER.exiting(S_CLASS_NAME, "isPrereqFileRelevant");
        return false;
    }

    public String buildDisabledActionsProperty(Vector<String> v) {
        LOGGER.entering(S_CLASS_NAME, "buildDisabledActionsProperty");
        if (v == null || v.isEmpty()) {
            LOGGER.exiting(S_CLASS_NAME, "buildDisabledActionsProperty");
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < v.size(); ++i) {
            sb.append(v.get(i));
            sb.append(";");
        }
        LOGGER.exiting(S_CLASS_NAME, "buildDisabledActionsProperty");
        return sb.toString();
    }

    public Vector<String> convertWSProfileDisabledActionsToStrings(Vector<WSProfileDisabledAction> v) {
        LOGGER.entering(S_CLASS_NAME, "convertWSProfileDisabledActionsToStrings");
        if (v == null) {
            LOGGER.exiting(S_CLASS_NAME, "convertWSProfileDisabledActionsToStrings");
            return null;
        }
        Vector<String> v2 = new Vector<String>();
        for (int i = 0; i < v.size(); ++i) {
            v2.addElement(v.get(i).getDisabledActionAlias());
        }
        LOGGER.exiting(S_CLASS_NAME, "convertWSProfileDisabledActionsToStrings");
        return v2;
    }

    public String[] convertVectorOfStringsToStringArray(Vector<String> vos) {
        LOGGER.entering(S_CLASS_NAME, "convertVectorOfStringsToStringArray");
        String[] aos = new String[vos.size()];
        for (int i = 0; i < vos.size(); ++i) {
            aos[i] = vos.get(i);
        }
        LOGGER.exiting(S_CLASS_NAME, "convertVectorOfStringsToStringArray");
        return aos;
    }
}

