/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.DefaultValueManager;
import com.ibm.ws.install.configmanager.utils.SystemPropertiesUtils;
import com.ibm.ws.profile.utils.CommandLineArgumentsUtils;
import com.ibm.ws.profile.utils.PrereqTemplateUtils;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValueManagerUtils {
    private static List m_listSortedDefaultValueManagers = null;
    private static Hashtable m_hashtableDVMCache = null;
    private static final String S_EMPTY = "";
    private static final Logger LOGGER = LoggerFactory.createLogger(DefaultValueManagerUtils.class);
    private static final String S_CLASS_NAME = DefaultValueManagerUtils.class.getName();

    public static String getDefaultValue(String sArgumentKey) {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "getDefaultValue");
        String[] saArgumentKeys = new String[]{sArgumentKey};
        Hashtable hashtableDefaultedValues = DefaultValueManagerUtils.getDefaultValues(saArgumentKeys, new Hashtable());
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "getDefaultValue");
        return (String)hashtableDefaultedValues.get(sArgumentKey);
    }

    public static String getDefaultValue(String sArgumentKey, Map mapAllActionArguments) {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "getDefaultValue");
        String[] saArgumentKeys = new String[]{sArgumentKey};
        Hashtable hashtableDefaultedValues = DefaultValueManagerUtils.getDefaultValues(saArgumentKeys, mapAllActionArguments);
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "getDefaultValue");
        return (String)hashtableDefaultedValues.get(sArgumentKey);
    }

    public static Hashtable getDefaultValues(String[] saArgumentKeys, Map mapAllActionArguments) {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "getDefaultValues");
        Properties propertiesSystemProps = SystemPropertiesUtils.setArgumentsIntoSystemProperties(mapAllActionArguments);
        DefaultValueManagerUtils.initialize();
        Map hashtableDefaultValueManagersAndArgs = DefaultValueManagerUtils.matchArgumentsToDefaultValueManager(saArgumentKeys);
        Hashtable hashtableDefaultedValues = DefaultValueManagerUtils.executeAllDefaulters(hashtableDefaultValueManagersAndArgs, mapAllActionArguments);
        SystemPropertiesUtils.resetSystemProperties(propertiesSystemProps);
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "getDefaultValues");
        return hashtableDefaultedValues;
    }

    public static Hashtable getDefaultValues(String sMode, String[] saArgumentKeys, Map mapAllActionArguments, List<WSProfileTemplate> lwsptTemplateStack) {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "getDefaultValues");
        Properties propertiesSystemProps = SystemPropertiesUtils.setArgumentsIntoSystemProperties(mapAllActionArguments);
        DefaultValueManagerUtils.initialize(sMode, lwsptTemplateStack);
        Map hashtableDefaultValueManagersAndArgs = DefaultValueManagerUtils.matchArgumentsToDefaultValueManager(saArgumentKeys);
        Hashtable hashtableDefaultedValues = DefaultValueManagerUtils.executeAllDefaulters(hashtableDefaultValueManagersAndArgs, mapAllActionArguments);
        SystemPropertiesUtils.resetSystemProperties(propertiesSystemProps);
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "getDefaultValues");
        return hashtableDefaultedValues;
    }

    public static String getDefaultValue(String sArgumentKey, String[] saAllArgs) {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "getDefaultValue");
        String[] saArgumentKeys = new String[]{sArgumentKey};
        Hashtable hashtableCommandLineArgs = CommandLineArgumentsUtils.convertCommandLineToHashtable(saAllArgs);
        Hashtable hashtableDefaultedValues = DefaultValueManagerUtils.getDefaultValues(saArgumentKeys, hashtableCommandLineArgs);
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "getDefaultValue");
        return (String)hashtableDefaultedValues.get(sArgumentKey);
    }

    public static Hashtable getDefaultValues(String[] saArgumentKeys, String[] saAllArgs) {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "getDefaultValues");
        Hashtable hashtableCommandLineArgs = CommandLineArgumentsUtils.convertCommandLineToHashtable(saAllArgs);
        Hashtable hashtableDefaultedValues = DefaultValueManagerUtils.getDefaultValues(saArgumentKeys, hashtableCommandLineArgs);
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "getDefaultValues");
        return hashtableDefaultedValues;
    }

    public static void reinitialize() {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "reInitialize");
        m_listSortedDefaultValueManagers = null;
        m_hashtableDVMCache = null;
        DefaultValueManagerUtils.initialize();
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "reInitialize");
    }

    private static Hashtable executeAllDefaulters(Map mapArgsToDvms, Map mapSetArgs) {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "executeAllDefaulters");
        Hashtable hashtableDefaultedValues = new Hashtable();
        Iterator iteratorArguments = mapArgsToDvms.keySet().iterator();
        while (iteratorArguments.hasNext()) {
            Vector<String> vsArgKey = new Vector<String>();
            String sArgKey = (String)iteratorArguments.next();
            vsArgKey.add(sArgKey);
            DefaultValueManager dvmCurrent = (DefaultValueManager)mapArgsToDvms.get(sArgKey);
            Hashtable hashtableDefaultedArgsForThisDVM = dvmCurrent.getDefaultValues(vsArgKey, mapSetArgs);
            hashtableDefaultedValues.putAll(hashtableDefaultedArgsForThisDVM);
            mapSetArgs.putAll(hashtableDefaultedArgsForThisDVM);
        }
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "executeAllDefaulters");
        return hashtableDefaultedValues;
    }

    private static void initialize() {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "initialize");
        if (m_hashtableDVMCache == null) {
            m_hashtableDVMCache = new Hashtable();
        }
        String sTemplatePath = DefaultValueManagerUtils.determineTemplatePath();
        String sMode = DefaultValueManagerUtils.determineCurrentMode();
        String sProfileName = DefaultValueManagerUtils.determineProfileName();
        List<WSProfileTemplate> listTemplates = PrereqTemplateUtils.getListOfTemplatePathsForMode(sMode, sProfileName, sTemplatePath);
        DefaultValueManagerUtils.createDefaultValueManagers(listTemplates, sMode);
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "initialize");
    }

    private static void initialize(String mode, List<WSProfileTemplate> l_wsptTemplateStack) {
        DefaultValueManagerUtils.createDefaultValueManagers(l_wsptTemplateStack, mode);
    }

    private static DefaultValueManager findDefaultValueManagerForArgument(String sArgumentKey) {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "findDefaultValueManagerForArgument");
        for (int i = m_listSortedDefaultValueManagers.size() - 1; i >= 0; --i) {
            DefaultValueManager dvmCurrent = (DefaultValueManager)m_listSortedDefaultValueManagers.get(i);
            if (!dvmCurrent.isArgumentAvailableForDefaulting(sArgumentKey)) continue;
            LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "findDefaultValueManagerForArgument");
            return dvmCurrent;
        }
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "findDefaultValueManagerForArgument");
        return null;
    }

    private static Map matchArgumentsToDefaultValueManager(String[] saArgumentKeys) {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "matchArgumentsToDefaultValueManager");
        LinkedHashMap<String, DefaultValueManager> mapArgsAndDvms = new LinkedHashMap<String, DefaultValueManager>();
        if (m_listSortedDefaultValueManagers != null) {
            for (int i = 0; i < m_listSortedDefaultValueManagers.size(); ++i) {
                DefaultValueManager dvmCurrent = (DefaultValueManager)m_listSortedDefaultValueManagers.get(i);
                String[] saTempArgKeys = dvmCurrent.getAllArgsInDefaultingOrder(saArgumentKeys);
                for (int j = 0; j < saTempArgKeys.length; ++j) {
                    String sCurrentArg = saTempArgKeys[j];
                    if (!dvmCurrent.isArgumentAvailableForDefaulting(sCurrentArg)) continue;
                    mapArgsAndDvms.put(sCurrentArg, dvmCurrent);
                }
            }
        }
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "matchArgumentsToDefaultValueManager");
        return mapArgsAndDvms;
    }

    private static void createDefaultValueManagers(List<WSProfileTemplate> l_wsptTemplateStack, String sMode) {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "createDefaultValueManagers");
        Vector<DefaultValueManager> listDefaultValueManagers = new Vector<DefaultValueManager>();
        if (m_hashtableDVMCache == null) {
            m_hashtableDVMCache = new Hashtable();
        }
        for (int i = 0; i < l_wsptTemplateStack.size(); ++i) {
            DefaultValueManager dvmCurrent;
            File fileProfileTemplate = l_wsptTemplateStack.get(i).getProfileTemplatePath();
            if (m_hashtableDVMCache.get(fileProfileTemplate) != null) {
                dvmCurrent = (DefaultValueManager)m_hashtableDVMCache.get(fileProfileTemplate);
            } else {
                String sTemplatePath = fileProfileTemplate.getAbsolutePath();
                String sActionRegistry = DefaultValueManagerUtils.determineActionRegistryFileName();
                dvmCurrent = new DefaultValueManager(sTemplatePath, sTemplatePath + File.separator + sActionRegistry);
                m_hashtableDVMCache.put(fileProfileTemplate, dvmCurrent);
            }
            listDefaultValueManagers.add(dvmCurrent);
        }
        m_listSortedDefaultValueManagers = listDefaultValueManagers;
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "createDefaultValueManagers");
    }

    private static String determineActionRegistry() {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "determineActionRegistry");
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "determineActionRegistry");
        return System.getProperty("WS_CMT_ACTION_REGISTRY");
    }

    private static String determineActionRegistryFileName() {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "determineActionRegistryFileName");
        String sFullActionRegistryName = DefaultValueManagerUtils.determineActionRegistry();
        if (sFullActionRegistryName != null && !sFullActionRegistryName.equals(S_EMPTY)) {
            File fileActionRegistry = new File(sFullActionRegistryName);
            LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "determineActionRegistryFileName");
            return fileActionRegistry.getName();
        }
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "determineActionRegistryFileName");
        return S_EMPTY;
    }

    private static String determineTemplatePath() {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "determineTemplatePath");
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "determineTemplatePath");
        return System.getProperty("WS_CMT_CONF_DIR");
    }

    private static String determineProfileName() {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "determineProfileName");
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "determineProfileName");
        return System.getProperty("profileName");
    }

    private static String determineCurrentMode() {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "determineCurrentMode");
        String sModeCreate = System.getProperty("create");
        String sModeAugment = System.getProperty("augment");
        String sMode = null;
        if (sModeCreate == null && sModeAugment == null) {
            sMode = null;
        } else if (sModeCreate == null && sModeAugment.equals(S_EMPTY)) {
            sMode = "augment";
        } else if (sModeCreate.equals(S_EMPTY) && sModeAugment == null) {
            sMode = "create";
        } else if (sModeCreate.equals(S_EMPTY) && sModeAugment.equals(S_EMPTY)) {
            sMode = null;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "determineCurrentMode", "Mode was determined to be: " + sMode);
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "determineCurrentMode");
        return sMode;
    }
}

