/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.websphere.product.WASDirectory;
import com.ibm.websphere.product.WASProductInfo;
import com.ibm.ws.profile.registry.ProfileBackup;
import com.ibm.ws.profile.utils.FileUtils;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.registry.Profile;
import java.io.File;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BackupProfileSnippetMarshallerUtils {
    private static final String S_TAG_WAS_INFO = "WASInfo";
    private static final String S_TAG_WAS_ID = "id";
    private static final String S_TAG_WAS_NAME = "name";
    private static final String S_TAG_WAS_VERSION = "version";
    private static final String S_TAG_WAS_BUILD_DATE = "buildDate";
    private static final String S_TAG_WAS_BUILD_LEVEL = "buildLevel";
    private static final String S_TAG_WAS_HOME = "wasHome";
    private static final String S_TAG_PROFILE_SIZE = "profileSize";

    public static void writeInformationToSnippetFile(Profile profile, String rootTag, File backupProfileSnippet) throws WSProfileException {
        DocumentBuilderFactory documentbuilderfactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentbuilder = documentbuilderfactory.newDocumentBuilder();
            Document document = documentbuilder.newDocument();
            Element elementRoot = document.createElement(rootTag);
            Element elementData = BackupProfileSnippetMarshallerUtils.marshallInfoToDOM(document, profile);
            elementRoot.appendChild(elementData);
            document.appendChild(elementRoot);
            FileUtils.saveDocumentToFile(document, backupProfileSnippet);
        }
        catch (ParserConfigurationException e) {
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
        }
    }

    public static Element marshallInfoToDOM(Document document, Profile profile) {
        String WAS_HOME = System.getProperty("WAS_HOME");
        Element parentElement = document.createElement(S_TAG_WAS_INFO);
        WASDirectory wasDirectory = new WASDirectory(WAS_HOME);
        WASProductInfo wasInfo = wasDirectory.getWASProductInfoInstances()[0];
        if (wasInfo != null) {
            parentElement.setAttribute(S_TAG_WAS_ID, wasInfo.getId());
            parentElement.setAttribute(S_TAG_WAS_NAME, wasInfo.getName());
            parentElement.setAttribute(S_TAG_WAS_VERSION, wasInfo.getVersion());
            parentElement.setAttribute(S_TAG_WAS_BUILD_DATE, wasInfo.getBuildDate());
            parentElement.setAttribute(S_TAG_WAS_BUILD_LEVEL, wasInfo.getBuildLevel());
            parentElement.setAttribute(S_TAG_WAS_HOME, WAS_HOME);
            parentElement.setAttribute(S_TAG_PROFILE_SIZE, FileUtils.getProfileFileSystemSize(profile));
        }
        return parentElement;
    }

    public static boolean deleteFile(File file) {
        return file.delete();
    }

    public static ProfileBackup readFileSnippetInputStream(InputStream is) throws WSProfileException {
        DocumentBuilderFactory documentbuilderfactory = DocumentBuilderFactory.newInstance();
        try {
            Document document = documentbuilderfactory.newDocumentBuilder().parse(is);
            ProfileBackup backupProfile = BackupProfileSnippetMarshallerUtils.readFileFromDOM(document);
            return backupProfile;
        }
        catch (Exception e) {
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
        }
    }

    public static ProfileBackup readFileFromDOM(Document document) throws WSProfileException {
        NodeList wasInfo = document.getElementsByTagName(S_TAG_WAS_INFO);
        return BackupProfileSnippetMarshallerUtils.unmarshallFileInformationFromDOM(wasInfo);
    }

    private static ProfileBackup unmarshallFileInformationFromDOM(NodeList wasInfo) {
        ProfileBackup profileBackup = new ProfileBackup();
        for (int i = 0; i < wasInfo.getLength(); ++i) {
            Node nodeProfileThis = wasInfo.item(i);
            String sName = nodeProfileThis.getAttributes().getNamedItem(S_TAG_WAS_NAME).getNodeValue();
            profileBackup.setWASName(sName);
            String sId = nodeProfileThis.getAttributes().getNamedItem(S_TAG_WAS_ID).getNodeValue();
            profileBackup.setWASId(sId);
            String sVersion = nodeProfileThis.getAttributes().getNamedItem(S_TAG_WAS_VERSION).getNodeValue();
            profileBackup.setWASVersion(sVersion);
            String sBuildDate = nodeProfileThis.getAttributes().getNamedItem(S_TAG_WAS_BUILD_DATE).getNodeValue();
            profileBackup.setWASBuildDate(sBuildDate);
            String sBuildLevel = nodeProfileThis.getAttributes().getNamedItem(S_TAG_WAS_BUILD_LEVEL).getNodeValue();
            profileBackup.setWASBuildLevel(sBuildLevel);
            String sWasHome = nodeProfileThis.getAttributes().getNamedItem(S_TAG_WAS_HOME).getNodeValue();
            profileBackup.setWASHome(sWasHome);
            String sProfileSize = nodeProfileThis.getAttributes().getNamedItem(S_TAG_PROFILE_SIZE).getNodeValue();
            profileBackup.setProfileSize(sProfileSize);
        }
        return profileBackup;
    }
}

