/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.remote;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.datastore.WSProfileDataStore;
import com.ibm.ws.profile.remote.ArgumentProcessor;
import com.ibm.wsspi.profile.WSProfileException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseFile {
    private static final String S_RESPONSE_SEED = "response";
    private static final String S_RESPONSE_EXT = ".properties";
    private static Logger LOGGER = LoggerFactory.createLogger(ResponseFile.class);
    private static String S_CLASS_NAME = ResponseFile.class.getName();

    protected static File createResponseFileForUpload() throws WSProfileException {
        LOGGER.entering(S_CLASS_NAME, "createResponseFileForUpload");
        Map<String, List> args = WSProfileDataStore.getResponseFileArgsAsMap();
        args = ArgumentProcessor.getTargetArguments(args);
        LOGGER.exiting(S_CLASS_NAME, "createResponseFileForUpload");
        return ResponseFile.save(args);
    }

    private static File save(Map<String, List> args) throws WSProfileException {
        LOGGER.entering(S_CLASS_NAME, "save");
        Properties properties = new Properties();
        for (String key : args.keySet()) {
            List values = args.get(key);
            StringBuffer value = new StringBuffer();
            Iterator valueIterator = values.iterator();
            while (valueIterator.hasNext()) {
                value.append((String)valueIterator.next());
                if (!valueIterator.hasNext()) continue;
                value.append(",");
            }
            properties.put(key, value.toString());
        }
        File responseFile = null;
        FileOutputStream out = null;
        try {
            responseFile = File.createTempFile(S_RESPONSE_SEED, S_RESPONSE_EXT);
            out = new FileOutputStream(responseFile);
            properties.store(out, null);
        }
        catch (IOException e) {
            LogUtils.logException(LOGGER, e);
            LOGGER.exiting(S_CLASS_NAME, "save");
            throw new WSProfileException("An error occurred while creating the response file.");
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                LogUtils.logException(LOGGER, e);
            }
        }
        LOGGER.exiting(S_CLASS_NAME, "save");
        return responseFile;
    }
}

