/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.remote;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.WSProfileConstants;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.datastore.WSProfileDataStore;
import com.ibm.ws.profile.remote.RXACommand;
import com.ibm.ws.profile.remote.RemoteCommandLine;
import com.ibm.ws.profile.remote.ResponseFile;
import com.ibm.ws.profile.remote.TargetSystem;
import com.ibm.ws.profile.remote.UploadedFiles;
import com.ibm.wsspi.profile.WSProfileException;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteWSProfileCLI {
    private static Logger LOGGER = LoggerFactory.createLogger(RemoteWSProfileCLI.class);
    private static String S_CLASS_NAME = RemoteWSProfileCLI.class.getName();

    public static int invokeWSProfile(Map<String, List> cmdLineArgs) {
        LOGGER.entering(S_CLASS_NAME, "invokeWSProfile");
        try {
            UploadedFiles uploadFiles = new UploadedFiles();
            uploadFiles.addLocalFilesFromArgs();
            if (WSProfileDataStore.isResponseFileSpecified()) {
                File uploadResponseFile = ResponseFile.createResponseFileForUpload();
                uploadFiles.addLocalFile(uploadResponseFile.getAbsolutePath());
                List responseArgs = cmdLineArgs.get("response");
                responseArgs.set(0, uploadResponseFile.getName());
            }
            String remoteCommand = RemoteCommandLine.getManageProfilesCommandLine(cmdLineArgs);
            RXACommand rc = new RXACommand();
            rc.setHostName(TargetSystem.getInstance().getHostName());
            rc.setUser(TargetSystem.getInstance().getUserName());
            rc.setPassword(TargetSystem.getInstance().getPassword());
            rc.setRemoteUploadPath(TargetSystem.getInstance().getUploadPath());
            rc.setLocalFiles(uploadFiles.getUploadFileList());
            rc.setCommand(remoteCommand);
            int returnCode = rc.run();
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "invokeWSProfile", "Returning with return code: " + WSProfileConstants.AS_RETURN_CODES[returnCode]);
            LOGGER.exiting(S_CLASS_NAME, "invokeWSProfile");
            return returnCode;
        }
        catch (WSProfileException e) {
            OutputStreamHandler.println(e.getMessage());
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "invokeWSProfile", "Returning with return code: " + WSProfileConstants.AS_RETURN_CODES[1]);
            LOGGER.exiting(S_CLASS_NAME, "invokeWSProfile");
            return 1;
        }
    }
}

