/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.remote;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.install.configmanager.osutils.TargetPlatform;
import com.ibm.ws.profile.remote.ArgumentProcessor;
import com.ibm.ws.profile.remote.TargetSystem;
import com.ibm.ws.profile.utils.WSProfileUtils;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCommandLine {
    private static final String S_MANAGE_PROFILES_CMD = "/bin/manageprofiles";
    private static final String S_SHELL_EXT = ".sh";
    private static final String S_BATCH_EXT = ".bat";
    private static final String S_NO_EXT = "";
    private static final String S_SPACE = " ";
    private static Logger LOGGER = LoggerFactory.createLogger(RemoteCommandLine.class);
    private static String S_CLASS_NAME = RemoteCommandLine.class.getName();

    public static String getManageProfilesCommandLine(Map<String, List> mArgs) {
        LOGGER.entering(S_CLASS_NAME, "getManageProfilesCommandLine");
        String command = TargetSystem.getInstance().getInstallPath() + S_MANAGE_PROFILES_CMD;
        command = command + RemoteCommandLine.getExtension();
        String[] targetArgs = WSProfileUtils.getMapAsStringArray(ArgumentProcessor.getTargetArguments(mArgs));
        for (int i = 0; i < targetArgs.length; ++i) {
            command = command + S_SPACE + PlatformConstants.convertToShellParam(targetArgs[i]);
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getCommandLine", "Returning command: " + command);
        LOGGER.exiting(S_CLASS_NAME, "getManageProfilesCommandLine");
        return command;
    }

    protected static String getExtension() {
        LOGGER.entering(S_CLASS_NAME, "getExtension");
        String extension2 = null;
        extension2 = TargetPlatform.isWindows() ? S_BATCH_EXT : (TargetPlatform.isOS400() ? S_NO_EXT : S_SHELL_EXT);
        LOGGER.exiting(S_CLASS_NAME, "getExtension");
        return extension2;
    }
}

