/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.registry;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.registry.FSProfileRegistry;
import com.ibm.ws.profile.utils.FileLocker;
import com.ibm.ws.profile.utils.FileLockerException;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfileEmptyTemplate;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.WSProfileTemplate;
import com.ibm.wsspi.profile.registry.Profile;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileRegistryMarshaller {
    private String m_sProfileRegistryPath = null;
    private FSProfileRegistry m_fspr = null;
    private FileLocker m_flRegistryLocker = null;
    private static final String S_TAG_PROFILES = "profiles";
    private static final String S_TAG_PROFILE = "profile";
    private static final String S_TAG_AUGMENTOR = "augmentor";
    private static final String S_ATTR_IS_DEFAULT = "isDefault";
    private static final String S_ATTR_IS_A_RESERVATION_TICKET = "isAReservationTicket";
    private static final String S_ATTR_NAME = "name";
    private static final String S_ATTR_PATH = "path";
    private static final String S_ATTR_TEMPLATE = "template";
    private static final String S_YES = "yes";
    private static final String S_INDENT_AMOUNT = "{http://xml.apache.org/xslt}indent-amount";
    private static final String S_N_INDENT_AMOUNT = "4";
    private static final String S_PROFILE_ALREADY_REGISTERED = "Profile is already registered.";
    private static final String S_PROFILE_EXISTS_KEY = "WSProfile.ProfileRegistryMarshaller.profileAlreadyExists";
    private static final String S_PROFILE_NOT_FOUND = "Profile not found: ";
    private static final String S_PROFILE_NOT_FOUND_KEY = "WSProfile.ProfileRegistryMarshaller.profileNotFound";
    private static final String S_PROFILE_REGISTRY_CORRUPT_NO_DEFAULT_PROFILE = "Profile registry is corrupt, no default profile defined";
    private static final String S_FILE_LOCK_ACQUIRE_FAILED = "";
    private static final String S_FILE_LOCK_ACQUIRE_FAILED_KEY = "WSProfile.ProfileRegistryMarshaller.fileLockAcquireFailed";
    private static final String S_FILE_LOCK_RELEASE_FAILED = "";
    private static final String S_FILE_LOCK_RELEASE_FAILED_KEY = "WSProfile.ProfileRegistryMarshaller.fileLockReleaseFailed";
    private static final Logger LOGGER = LoggerFactory.createLogger(ProfileRegistryMarshaller.class);
    private static final String S_CLASS_NAME = ProfileRegistryMarshaller.class.getName();

    public ProfileRegistryMarshaller(String sProfileRegistryPath) {
        this.m_sProfileRegistryPath = sProfileRegistryPath;
        this.m_fspr = new FSProfileRegistry(sProfileRegistryPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProfileToRegistry(Profile profile) throws WSProfileException {
        this.acquireRegistryLock();
        try {
            this.throwExceptionIfTheGivenProfileIsAlreadyRegistered(profile);
            Vector<Object> vprofilesInRegistry = new Vector();
            if (this.doesProfileRegistryExist()) {
                vprofilesInRegistry = this.readProfileRegistry();
            }
            if (this.isProfileRegistryEmpty()) {
                profile.setDefault(true);
            }
            vprofilesInRegistry.add(profile);
            try {
                this.m_fspr.addProfileToRegistry(profile);
            }
            catch (IOException e) {
                throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
            }
            this.writeProfileRegistry(vprofilesInRegistry);
        }
        finally {
            this.releaseRegistryLock();
        }
        if (profile.isDefault()) {
            this.markProfileDefault(profile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCreateAddProfileToRegistry(Profile profile) throws WSProfileException {
        this.acquireRegistryLock();
        try {
            this.throwExceptionIfTheGivenProfileIsAlreadyRegistered(profile);
            Vector<Profile> vprofilesInRegistry = new Vector<Profile>();
            if (this.doesProfileRegistryExist()) {
                vprofilesInRegistry = this.readProfileRegistry();
            }
            vprofilesInRegistry.add(profile);
            this.writeProfileRegistry(vprofilesInRegistry);
        }
        finally {
            this.releaseRegistryLock();
        }
    }

    public void postCreateAddProfileToRegistry(Profile profile) throws WSProfileException {
        Vector<Profile> vprofiles = this.readProfileRegistry();
        if (!ProfileRegistryMarshaller.isThisProfileAlreadyPresentInThisVector(profile, vprofiles)) {
            return;
        }
        boolean fIsRegistryEmptyBeforeThisProfile = this.isProfileRegistryEmpty();
        try {
            this.m_fspr.addProfileToRegistry(profile);
        }
        catch (IOException e) {
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
        }
        if (profile.isDefault() || fIsRegistryEmptyBeforeThisProfile) {
            this.markProfileDefault(profile);
        }
    }

    public Profile getProfile(String sProfileName) throws WSProfileException {
        List listProfiles = this.listProfilesInRegistry();
        for (int i = 0; i < listProfiles.size(); ++i) {
            Profile profileThis = (Profile)listProfiles.get(i);
            if (!profileThis.getName().equals(sProfileName)) continue;
            return profileThis;
        }
        throw new WSProfileException(S_PROFILE_NOT_FOUND + sProfileName, ResourceBundleUtils.getLocaleString(S_PROFILE_NOT_FOUND_KEY, sProfileName), false);
    }

    public Profile getProfile(String sProfileName, boolean b_include_invalid) throws WSProfileException {
        List listProfiles = this.listAllProfilesInRegistry();
        for (int i = 0; i < listProfiles.size(); ++i) {
            Profile profileThis = (Profile)listProfiles.get(i);
            if (!profileThis.getName().equals(sProfileName)) continue;
            return profileThis;
        }
        throw new WSProfileException(S_PROFILE_NOT_FOUND + sProfileName, ResourceBundleUtils.getLocaleString(S_PROFILE_NOT_FOUND_KEY, sProfileName), false);
    }

    public Profile getProfile(File fileProfilePath) throws WSProfileException {
        List listProfiles = this.listProfilesInRegistry();
        for (int i = 0; i < listProfiles.size(); ++i) {
            Profile profileThis = (Profile)listProfiles.get(i);
            try {
                if (!profileThis.getPath().getCanonicalPath().equals(fileProfilePath.getCanonicalPath())) continue;
                return profileThis;
            }
            catch (IOException e) {
                throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
            }
        }
        throw new WSProfileException(S_PROFILE_NOT_FOUND + fileProfilePath, ResourceBundleUtils.getLocaleString(S_PROFILE_NOT_FOUND_KEY, fileProfilePath.toString()), false);
    }

    public void throwExceptionIfTheGivenProfileIsAlreadyRegistered(Profile profile) throws WSProfileException {
        if (this.isThisProfileAlreadyRegistered(profile)) {
            throw new WSProfileException(S_PROFILE_ALREADY_REGISTERED, ResourceBundleUtils.getLocaleString(S_PROFILE_EXISTS_KEY), true);
        }
    }

    public boolean isThisProfileAlreadyRegistered(Profile profile) throws WSProfileException {
        if (!this.doesProfileRegistryExist()) {
            return false;
        }
        Vector<Profile> vprofilesInRegistry = this.readProfileRegistry();
        return ProfileRegistryMarshaller.isThisProfileAlreadyPresentInThisVector(profile, vprofilesInRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteProfileFromRegistry(Profile profile) throws WSProfileException {
        this.acquireRegistryLock();
        try {
            Vector<Profile> vprofilesInRegistry = this.readProfileRegistry();
            if (!vprofilesInRegistry.remove(profile)) {
                boolean bl = false;
                return bl;
            }
            this.m_fspr.deleteProfileFromRegistry(profile);
            this.writeProfileRegistry(vprofilesInRegistry);
        }
        finally {
            this.releaseRegistryLock();
        }
        if (profile.isDefault()) {
            this.markFirstProfileDefault();
        }
        return true;
    }

    public boolean isProfileRegistryEmpty() throws WSProfileException {
        if (!this.doesProfileRegistryExist()) {
            return true;
        }
        return this.listProfilesInRegistry().isEmpty();
    }

    public boolean isProfileRegistryCompletelyEmpty() throws WSProfileException {
        if (!this.doesProfileRegistryExist()) {
            return true;
        }
        return this.listAllProfilesInRegistry().isEmpty();
    }

    public List listProfilesInRegistry() throws WSProfileException {
        List listProfiles = this.listAllProfilesInRegistry();
        for (int i = 0; i < listProfiles.size(); ++i) {
            Profile profileThis = (Profile)listProfiles.get(i);
            if (this.isProfileCreated(profileThis)) continue;
            listProfiles.remove(i);
            --i;
        }
        return listProfiles;
    }

    public List listAllProfilesInRegistry() throws WSProfileException {
        return this.readProfileRegistry();
    }

    public void markFirstProfileDefault() throws WSProfileException {
        if (this.isProfileRegistryEmpty()) {
            return;
        }
        Vector<Profile> vprofiles = this.readProfileRegistry();
        Profile profileFirst = vprofiles.elementAt(0);
        this.markProfileDefault(profileFirst);
    }

    public void markProfileDefault(Profile profileIn) throws WSProfileException {
        if (this.isProfileRegistryEmpty()) {
            return;
        }
        this.acquireRegistryLock();
        Vector<Profile> vprofiles = this.readProfileRegistry();
        for (int i = 0; i < vprofiles.size(); ++i) {
            Profile profileThis = vprofiles.elementAt(i);
            if (profileIn.equals(profileThis)) {
                profileThis.setDefault(true);
                this.m_fspr.setDefault(profileThis);
                continue;
            }
            profileThis.setDefault(false);
        }
        this.writeProfileRegistry(vprofiles);
        this.releaseRegistryLock();
    }

    public Profile getDefaultProfile() throws WSProfileException {
        if (this.isProfileRegistryEmpty()) {
            return null;
        }
        List listProfiles = this.listProfilesInRegistry();
        for (int i = 0; i < listProfiles.size(); ++i) {
            Profile profileThis = (Profile)listProfiles.get(i);
            if (!profileThis.isDefault()) continue;
            return profileThis;
        }
        throw new WSProfileException(S_PROFILE_REGISTRY_CORRUPT_NO_DEFAULT_PROFILE);
    }

    public boolean markProfileReservationTicket(String sProfileName) throws WSProfileException {
        return this.setProfileReservationTicket(sProfileName, true);
    }

    public void unmarkProfileReservationTicket(String sProfileName) throws WSProfileException {
        this.setProfileReservationTicket(sProfileName, false);
    }

    public List purgeInvalidEntries() throws WSProfileException {
        if (!this.doesProfileRegistryExist()) {
            return new Vector(0);
        }
        this.acquireRegistryLock();
        Vector<Profile> vprofiles = this.readProfileRegistry();
        List listprofilesInvalid = this.getInvalidProfiles();
        Vector<Profile> vprofilesValid = new Vector<Profile>(vprofiles);
        vprofilesValid.removeAll(listprofilesInvalid);
        this.m_fspr.purgeInvalidEntries(listprofilesInvalid);
        this.writeProfileRegistry(vprofilesValid);
        this.releaseRegistryLock();
        return listprofilesInvalid;
    }

    public void ensureThereIsOnlyASingleDefaultProfileInTheProfileRegistry() throws WSProfileException {
        if (!this.doesProfileRegistryExist()) {
            return;
        }
        if (this.isProfileRegistryEmpty()) {
            return;
        }
        Vector<Profile> vprofilesInRegistry = this.readProfileRegistry();
        boolean fDefaultProfileFoundAlready = false;
        for (int i = 0; i < vprofilesInRegistry.size(); ++i) {
            Profile profileThis = vprofilesInRegistry.elementAt(i);
            if (fDefaultProfileFoundAlready && profileThis.isDefault()) {
                profileThis.setDefault(false);
            }
            if (!profileThis.isDefault()) continue;
            fDefaultProfileFoundAlready = true;
        }
        if (!fDefaultProfileFoundAlready) {
            vprofilesInRegistry.elementAt(0).setDefault(true);
        }
        this.writeProfileRegistry(vprofilesInRegistry);
    }

    public List getInvalidProfiles() throws WSProfileException {
        if (!this.doesProfileRegistryExist()) {
            return new Vector(0);
        }
        Vector<Profile> vprofiles = this.readProfileRegistry();
        Vector<Profile> vprofilesValid = new Vector<Profile>();
        for (int i = 0; i < vprofiles.size(); ++i) {
            Profile profileThis = vprofiles.elementAt(i);
            if (!profileThis.isProfileValid() || ProfileRegistryMarshaller.isThisProfileAlreadyPresentInThisVector(profileThis, vprofilesValid)) continue;
            vprofilesValid.add(profileThis);
        }
        Vector<Profile> vprofilesInvalid = new Vector<Profile>(vprofiles);
        vprofilesInvalid.removeAll(vprofilesValid);
        return vprofilesInvalid;
    }

    public boolean isProfileCreated(Profile profileCurrent) {
        return this.m_fspr.doesProfileScriptExist(profileCurrent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setProfileReservationTicket(String sProfileName, boolean fReservationIn) throws WSProfileException {
        this.acquireRegistryLock();
        try {
            if (!this.isProfileRegistryCompletelyEmpty()) {
                Vector<Profile> vprofiles = this.readProfileRegistry();
                for (int i = 0; i < vprofiles.size(); ++i) {
                    Profile profileThis = vprofiles.elementAt(i);
                    if (!sProfileName.equals(profileThis.getName())) continue;
                    if (fReservationIn) {
                        if (profileThis.isAReservationTicket()) {
                            boolean bl = false;
                            return bl;
                        }
                        profileThis.setAReservationTicket(true);
                        continue;
                    }
                    profileThis.setAReservationTicket(false);
                }
                this.writeProfileRegistry(vprofiles);
            }
        }
        finally {
            this.releaseRegistryLock();
        }
        return true;
    }

    private void acquireRegistryLock() throws WSProfileException {
        try {
            this.m_flRegistryLocker = new FileLocker(this.m_sProfileRegistryPath);
            this.m_flRegistryLocker.acquireFileLock(300L, 20);
        }
        catch (FileLockerException e) {
            throw new WSProfileException("", ResourceBundleUtils.getLocaleString(S_FILE_LOCK_ACQUIRE_FAILED_KEY, this.m_flRegistryLocker.getLockFilePath()), e);
        }
        catch (IOException ioEx) {
            throw new WSProfileException(ioEx.getMessage());
        }
    }

    private void releaseRegistryLock() throws WSProfileException {
        try {
            this.m_flRegistryLocker.releaseFileLock();
        }
        catch (FileLockerException fle) {
            throw new WSProfileException("", ResourceBundleUtils.getLocaleString(S_FILE_LOCK_RELEASE_FAILED_KEY, this.m_flRegistryLocker.getLockFilePath()), fle);
        }
    }

    private static boolean isThisProfileAlreadyPresentInThisVector(Profile profile, Vector vprofiles) throws WSProfileException {
        for (int i = 0; i < vprofiles.size(); ++i) {
            Profile profileThis = (Profile)vprofiles.elementAt(i);
            try {
                if (!profileThis.getName().equals(profile.getName()) && !profileThis.getPath().getCanonicalPath().equals(profile.getPath().getCanonicalPath())) continue;
                return true;
            }
            catch (IOException e) {
                throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
            }
        }
        return false;
    }

    private boolean doesProfileRegistryExist() {
        return new File(this.m_sProfileRegistryPath).exists();
    }

    private Vector<Profile> readProfileRegistry() throws WSProfileException {
        DocumentBuilderFactory documentbuilderfactory = DocumentBuilderFactory.newInstance();
        try {
            Document document = documentbuilderfactory.newDocumentBuilder().parse(new File(this.m_sProfileRegistryPath));
            NodeList nodelistProfiles = document.getElementsByTagName(S_TAG_PROFILE);
            return this.unmarshallProfilesFromDOM(nodelistProfiles);
        }
        catch (Exception e) {
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
        }
    }

    private void writeProfileRegistry(Vector vprofiles) throws WSProfileException {
        DocumentBuilderFactory documentbuilderfactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentbuilder = documentbuilderfactory.newDocumentBuilder();
            Document document = documentbuilder.newDocument();
            Element elementRoot = document.createElement(S_TAG_PROFILES);
            for (int i = 0; i < vprofiles.size(); ++i) {
                Profile profileThis = (Profile)vprofiles.elementAt(i);
                Element elementProfile = this.marshallThisProfileToDOM(profileThis, document);
                elementRoot.appendChild(elementProfile);
            }
            document.appendChild(elementRoot);
            this.saveDocumentToProfileRegistry(document);
        }
        catch (ParserConfigurationException e) {
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
        }
    }

    private Vector<Profile> unmarshallProfilesFromDOM(NodeList nodelistProfiles) {
        Vector<Profile> vprofiles = new Vector<Profile>();
        for (int i = 0; i < nodelistProfiles.getLength(); ++i) {
            WSProfileTemplate wspeCreate;
            Node nodeProfileThis = nodelistProfiles.item(i);
            boolean fIsDefault = Boolean.valueOf(nodeProfileThis.getAttributes().getNamedItem(S_ATTR_IS_DEFAULT).getNodeValue());
            Node node = nodeProfileThis.getAttributes().getNamedItem(S_ATTR_IS_A_RESERVATION_TICKET);
            boolean fIsAReservationTicket = Boolean.valueOf(node == null ? "false" : node.getNodeValue());
            String sName = nodeProfileThis.getAttributes().getNamedItem(S_ATTR_NAME).getNodeValue();
            String sPath = nodeProfileThis.getAttributes().getNamedItem(S_ATTR_PATH).getNodeValue();
            String sTemplate = nodeProfileThis.getAttributes().getNamedItem(S_ATTR_TEMPLATE).getNodeValue();
            try {
                wspeCreate = new WSProfileTemplate(sTemplate);
            }
            catch (WSProfileException wspe) {
                wspeCreate = new WSProfileEmptyTemplate(sTemplate);
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "unmarshallProfilesFromDOM", "The profile template located at " + sTemplate + " failed to instantiate. It is possible that the template" + " is not present on the file system, or the metadata is corrupt. ");
            }
            Profile profileThis = new Profile(sName, new File(sPath), wspeCreate, fIsDefault, fIsAReservationTicket);
            this.unmarshallAugmentorsForThisProfile(nodeProfileThis, profileThis);
            vprofiles.add(profileThis);
        }
        return vprofiles;
    }

    private void unmarshallAugmentorsForThisProfile(Node nodeProfileThis, Profile profileThis) {
        Element elementProfileThis = (Element)nodeProfileThis;
        NodeList nodelistAugmentors = elementProfileThis.getElementsByTagName(S_TAG_AUGMENTOR);
        for (int i = 0; i < nodelistAugmentors.getLength(); ++i) {
            WSProfileTemplate wspeAugment;
            Node nodeAugmentorThis = nodelistAugmentors.item(i);
            String sAugmentorPath = nodeAugmentorThis.getAttributes().getNamedItem(S_ATTR_TEMPLATE).getNodeValue();
            try {
                wspeAugment = new WSProfileTemplate(sAugmentorPath);
            }
            catch (WSProfileException wspe) {
                wspeAugment = new WSProfileEmptyTemplate(sAugmentorPath);
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "unmarshallAugmentorsForThisProfile", "The profile template located at " + sAugmentorPath + " failed to instantiate. It is possible that the template" + " is not present on the file system, or the metadata is corrupt. The" + "registry will proceed to be read as normal.");
            }
            profileThis.addAugmentor(wspeAugment);
        }
    }

    private Element marshallThisProfileToDOM(Profile profileThis, Document document) {
        Element elementProfile = document.createElement(S_TAG_PROFILE);
        elementProfile.setAttribute(S_ATTR_IS_DEFAULT, Boolean.toString(profileThis.isDefault()));
        elementProfile.setAttribute(S_ATTR_IS_A_RESERVATION_TICKET, Boolean.toString(profileThis.isAReservationTicket()));
        elementProfile.setAttribute(S_ATTR_NAME, profileThis.getName());
        elementProfile.setAttribute(S_ATTR_PATH, profileThis.getPath().getAbsolutePath());
        elementProfile.setAttribute(S_ATTR_TEMPLATE, profileThis.getWSProfileTemplateRelaxed().getProfileTemplatePath().getAbsolutePath());
        List<WSProfileTemplate> listAugmentors = profileThis.getAugmentationTemplatesRelaxed();
        for (WSProfileTemplate wsptThis : listAugmentors) {
            String sAugmentorPath = wsptThis.getProfileTemplatePath().getAbsolutePath();
            Element elementAugmentorThis = document.createElement(S_TAG_AUGMENTOR);
            elementAugmentorThis.setAttribute(S_ATTR_TEMPLATE, sAugmentorPath);
            elementProfile.appendChild(elementAugmentorThis);
        }
        return elementProfile;
    }

    private void saveDocumentToProfileRegistry(Document document) throws WSProfileException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource domsource = new DOMSource(document);
            File profileRegistry = new File(this.m_sProfileRegistryPath);
            StreamResult streamresult = new StreamResult(profileRegistry.toURI().getPath());
            transformer.setOutputProperty("indent", S_YES);
            transformer.setOutputProperty(S_INDENT_AMOUNT, S_N_INDENT_AMOUNT);
            transformer.transform(domsource, streamresult);
        }
        catch (TransformerConfigurationException e) {
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
        }
        catch (TransformerException e) {
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
        }
    }
}

