/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.registry;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.profile.utils.FileUtils;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.registry.Profile;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FSProfileRegistry {
    private String m_sPathToFSRegistryDirectory = null;
    private static final String S_WINDOWS_SCRIPT_SET_COMMAND = "set WAS_USER_SCRIPT=";
    private static final String S_UNIX_SCRIPT_SET_COMMAND_1 = "#!/bin/sh\nWAS_USER_SCRIPT=";
    private static final String S_UNIX_SCRIPT_SET_COMMAND_2 = "\nexport WAS_USER_SCRIPT";
    private static final String S_OS400_SCRIPT_SET_COMMAND_1 = "#!/usr/bin/qsh\nWAS_USER_SCRIPT=";
    private static final String S_OS400_SCRIPT_SET_COMMAND_2 = "\nexport WAS_USER_SCRIPT";
    private static final String S_WINDOWS_SCRIPT_RELATIVE_PATH = "bin\\setupCmdLine.bat";
    private static final String S_UNIX_SCRIPT_RELATIVE_PATH = "bin/setupCmdLine.sh";
    private static final String S_OS400_SCRIPT_RELATIVE_PATH = "bin/setupCmdLine";
    private static final String S_BAT = ".bat";
    private static final String S_SH = ".sh";
    private static final String S_OS400EXT = "";
    private static final String S_DEFAULT_SCRIPT_DIRECTORY = "_was_profile_default";
    private static final String S_DEFAULT_SCRIPT_NAME = "default";
    private static final String S_EMPTY = "";
    private static final Logger LOGGER = LoggerFactory.createLogger(FSProfileRegistry.class);
    private static final String S_CLASS_NAME = FSProfileRegistry.class.getName();
    private static Vector<String> m_vsScriptPath = new Vector();

    public FSProfileRegistry(String sProfileRegistryPath) {
        LOGGER.entering(this.getClass().getName(), "FSProfileRegistry");
        this.m_sPathToFSRegistryDirectory = new File(new File(sProfileRegistryPath).getParent(), "fsdb").getAbsolutePath();
        LOGGER.exiting(this.getClass().getName(), "FSProfileRegistry");
    }

    public void deleteDefault(Profile profile) throws WSProfileException {
        LOGGER.entering(this.getClass().getName(), "deleteDefault");
        File fileDefaultProfileScript = new File(this.getDefaultScriptPath());
        File fileProfileScript = new File(this.getScriptPathForThisProfile(profile));
        String sDefault = "";
        String sProfile = "";
        try {
            sDefault = FileUtils.readShellScript(fileDefaultProfileScript);
            sProfile = FileUtils.readShellScript(fileProfileScript);
        }
        catch (IOException e) {
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
        }
        if (sProfile != null && sDefault != null && !sProfile.equals("") && sProfile.equals(sDefault)) {
            String parent = fileDefaultProfileScript.getParent();
            fileDefaultProfileScript.delete();
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "deleteDefault", "Default profile script: " + fileDefaultProfileScript.getAbsolutePath() + " is deleted.");
            File fParent = new File(parent);
            if (fParent != null && fParent.exists() && fParent.isDirectory()) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "deleteDefault", "Default profile script's parent directory: " + fParent.getAbsolutePath() + " is deleted.");
                fParent.delete();
            }
        }
        LOGGER.exiting(this.getClass().getName(), "deleteDefault");
    }

    public void setDefault(Profile profile) throws WSProfileException {
        LOGGER.entering(this.getClass().getName(), "setDefault");
        File fileProfileScript = new File(this.getDefaultScriptPath());
        fileProfileScript.getParentFile().mkdirs();
        if (fileProfileScript != null && fileProfileScript.exists()) {
            fileProfileScript.delete();
        }
        try {
            FileUtils.createShellScript(fileProfileScript, this.getScriptForThisProfile(profile));
        }
        catch (IOException e) {
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "setDefault", "Added default profile: " + profile + " to the FS DB");
        LOGGER.exiting(this.getClass().getName(), "setDefault");
    }

    public void addProfileToRegistry(Profile profile) throws IOException {
        LOGGER.entering(this.getClass().getName(), "addProfileToRegistry");
        File fileProfileScript = new File(this.getScriptPathForThisProfile(profile));
        fileProfileScript.getParentFile().mkdirs();
        FileUtils.createShellScript(fileProfileScript, this.getScriptForThisProfile(profile));
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "addProfileToRegistry", "Added profile: " + profile + " to the FS DB");
        LOGGER.exiting(this.getClass().getName(), "addProfileToRegistry");
    }

    public void deleteProfileFromRegistry(Profile profile) throws WSProfileException {
        LOGGER.entering(this.getClass().getName(), "deleteProfileFromRegistry");
        if (profile.isDefault()) {
            this.deleteDefault(profile);
        }
        File scriptFile = new File(this.getScriptPathForThisProfile(profile));
        scriptFile.delete();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "deleteProfileFromRegistry", "Deleted profile: " + profile + " from the FS DB");
        File parentFile = scriptFile.getParentFile();
        if (parentFile != null && parentFile.isDirectory()) {
            parentFile.delete();
        }
        LOGGER.exiting(this.getClass().getName(), "deleteProfileFromRegistry");
    }

    public void purgeInvalidEntries(List listprofiles) throws WSProfileException {
        LOGGER.entering(this.getClass().getName(), "purgeInvalidEntries");
        for (int i = 0; i < listprofiles.size(); ++i) {
            Profile profileThis = (Profile)listprofiles.get(i);
            this.deleteProfileFromRegistry(profileThis);
        }
        LOGGER.exiting(this.getClass().getName(), "purgeInvalidEntries");
    }

    public boolean doesProfileScriptExist(Profile profile) {
        File fileProfileScript = new File(this.getScriptPathForThisProfile(profile));
        return fileProfileScript.exists();
    }

    private String getDefaultScriptPath() {
        LOGGER.entering(this.getClass().getName(), "getDefaultScriptPathForThisProfile");
        String sExtension = null;
        sExtension = PlatformConstants.isCurrentPlatformUNIX() ? S_SH : (PlatformConstants.isCurrentPlatformOS400() ? "" : S_BAT);
        String sScriptPath = new File(this.m_sPathToFSRegistryDirectory, S_DEFAULT_SCRIPT_DIRECTORY + File.separator + S_DEFAULT_SCRIPT_NAME + sExtension).getAbsolutePath();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getDefaultScriptPath", "The default script path is: " + sScriptPath);
        LOGGER.exiting(this.getClass().getName(), "getDefaultScriptPathForThisProfile");
        return sScriptPath;
    }

    private String getScriptPathForThisProfile(Profile profile) {
        LOGGER.entering(this.getClass().getName(), "getScriptPathForThisProfile");
        String sExtension = null;
        sExtension = PlatformConstants.isCurrentPlatformUNIX() ? S_SH : (PlatformConstants.isCurrentPlatformOS400() ? "" : S_BAT);
        String sScriptPath = new File(this.m_sPathToFSRegistryDirectory, profile.getName() + sExtension).getAbsolutePath();
        if (!m_vsScriptPath.contains(sScriptPath)) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getScriptPathForThisProfile", "The script path for this profile: " + profile + ", is: " + sScriptPath);
            m_vsScriptPath.add(sScriptPath);
        }
        LOGGER.exiting(this.getClass().getName(), "getScriptPathForThisProfile");
        return sScriptPath;
    }

    private String getScriptForThisProfile(Profile profile) {
        LOGGER.entering(this.getClass().getName(), "getScriptForThisProfile");
        String sScript = null;
        sScript = PlatformConstants.isCurrentPlatformUNIX() ? this.getUNIXScriptForThisProfile(profile) : (PlatformConstants.isCurrentPlatformOS400() ? this.getOS400ScriptForThisProfile(profile) : this.getWindowsScriptForThisProfile(profile));
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getScriptForThisProfile", "The profile script for this profile: " + profile + ", is: " + sScript);
        LOGGER.exiting(this.getClass().getName(), "getScriptForThisProfile");
        return sScript;
    }

    private String getWindowsScriptForThisProfile(Profile profile) {
        LOGGER.entering(this.getClass().getName(), "getWindowsScriptForThisProfile");
        String sReturn = S_WINDOWS_SCRIPT_SET_COMMAND + new File(profile.getPath(), S_WINDOWS_SCRIPT_RELATIVE_PATH).getAbsolutePath();
        LOGGER.exiting(this.getClass().getName(), "getWindowsScriptForThisProfile");
        return sReturn;
    }

    private String getUNIXScriptForThisProfile(Profile profile) {
        LOGGER.entering(this.getClass().getName(), "getUNIXScriptForThisProfile");
        String sReturn = S_UNIX_SCRIPT_SET_COMMAND_1 + new File(profile.getPath(), S_UNIX_SCRIPT_RELATIVE_PATH).getAbsolutePath() + "\nexport WAS_USER_SCRIPT";
        LOGGER.exiting(this.getClass().getName(), "getUNIXScriptForThisProfile");
        return sReturn;
    }

    private String getOS400ScriptForThisProfile(Profile profile) {
        LOGGER.entering(this.getClass().getName(), "getOS400ScriptForThisProfile");
        String sReturn = S_OS400_SCRIPT_SET_COMMAND_1 + new File(profile.getPath(), S_OS400_SCRIPT_RELATIVE_PATH).getAbsolutePath() + "\nexport WAS_USER_SCRIPT";
        LOGGER.exiting(this.getClass().getName(), "getOS400ScriptForThisProfile");
        return sReturn;
    }
}

