/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.processing.preprocessing;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.datastore.WSProfileDataStore;
import com.ibm.ws.profile.processing.WSProfileProcessorTask;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TemplatePathValidationPreProcessorTask
extends WSProfileProcessorTask {
    private static final String S_TEMPLATE_NOT_FOUND_KEY = "WSProfile.WSProfileTemplate.templateNotFound";
    private static final Logger LOGGER = LoggerFactory.createLogger(TemplatePathValidationPreProcessorTask.class);
    private static final String S_CLASS_NAME = TemplatePathValidationPreProcessorTask.class.getName();

    public boolean runProcessor() throws Throwable {
        LOGGER.entering(S_CLASS_NAME, "runProcessor");
        Map<String, List> mFlowControllingArgs = WSProfileDataStore.getFlowControllingArgsAsMap();
        List vTemplatePaths = mFlowControllingArgs.get("templatePath");
        if (vTemplatePaths != null) {
            for (String sTemplatePathThis : vTemplatePaths) {
                try {
                    if (sTemplatePathThis == null) {
                        OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_TEMPLATE_NOT_FOUND_KEY, sTemplatePathThis));
                        LOGGER.exiting(S_CLASS_NAME, "runProcessor");
                        return false;
                    }
                    new WSProfileTemplate(sTemplatePathThis);
                }
                catch (WSProfileException wspe) {
                    OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_TEMPLATE_NOT_FOUND_KEY, sTemplatePathThis));
                    LOGGER.exiting(S_CLASS_NAME, "runProcessor");
                    return false;
                }
            }
        }
        LOGGER.exiting(S_CLASS_NAME, "runProcessor");
        return true;
    }

    public boolean doIRun() {
        LOGGER.entering(S_CLASS_NAME, "doIRun");
        boolean result = false;
        WSProfileCLIModeInvoker wspclimiFlowControlling = WSProfileDataStore.getFlowControllingModeInvoker();
        Map<String, List> mapFlowControllingArgs = WSProfileDataStore.getFlowControllingArgsAsMap();
        if (wspclimiFlowControlling != null && wspclimiFlowControlling.isArgumentRequired("templatePath") && mapFlowControllingArgs != null) {
            result = true;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", "doIRun = " + result);
        LOGGER.exiting(S_CLASS_NAME, "doIRun");
        return result;
    }
}

