/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.processing.preprocessing;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.datastore.WSProfileDataStore;
import com.ibm.ws.profile.processing.WSProfileProcessorTask;
import com.ibm.ws.profile.utils.ResponseFileUtils;
import com.ibm.ws.profile.utils.WSProfileUtils;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResponseFilePreProcessingTask
extends WSProfileProcessorTask {
    private static Logger LOGGER = LoggerFactory.createLogger(ResponseFilePreProcessingTask.class);
    private static String S_CLASS_NAME = ResponseFilePreProcessingTask.class.getName();

    public boolean runProcessor() throws IOException {
        LOGGER.entering(S_CLASS_NAME, "runProcessor");
        Hashtable htSpecifiedArgs = (Hashtable)WSProfileDataStore.getIncomingArgsAsMap();
        Vector vResponseFilePath = (Vector)htSpecifiedArgs.get("response");
        if (vResponseFilePath == null || vResponseFilePath.size() <= 0) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "runProcessor", "No value was provided for the response file location");
            LOGGER.exiting(S_CLASS_NAME, "runProcessor");
            return false;
        }
        String sRespFilePath = (String)vResponseFilePath.get(0);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runProcessor", "Response file being used is: " + sRespFilePath);
        Properties propsInResponseFile = (Properties)ResponseFileUtils.retrieveResponseFileArgs(sRespFilePath);
        String[] saArgsInResponseFile = WSProfileUtils.convertPropertiesToCommandLineArguments(propsInResponseFile);
        WSProfileDataStore.setResponseFileArgs(saArgsInResponseFile);
        WSProfileDataStore.setResponseFileIsSpecifiedArg(true);
        LOGGER.exiting(S_CLASS_NAME, "runProcessor");
        return true;
    }

    public boolean checkPreconditions() {
        LOGGER.entering(S_CLASS_NAME, "checkPreconditions");
        String[] saSpecifiedArgs = WSProfileDataStore.getIncomingArgsAsArray();
        if (saSpecifiedArgs == null || saSpecifiedArgs.length < 1) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = false");
            LOGGER.exiting(S_CLASS_NAME, "checkPreconditions");
            return false;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = true");
        LOGGER.exiting(S_CLASS_NAME, "checkPreconditions");
        return true;
    }

    public boolean doIRun() {
        LOGGER.entering(S_CLASS_NAME, "doIRun");
        String[] saSpecifiedArgs = WSProfileDataStore.getIncomingArgsAsArray();
        if (saSpecifiedArgs != null && WSProfileCLIModeInvoker.findModeInvoker(saSpecifiedArgs).getModeFlag().equals("response") && !WSProfileDataStore.getIncomingArgsAsMap().containsKey("help")) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", "doIRun = true");
            LOGGER.exiting(S_CLASS_NAME, "doIRun");
            return true;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", "doIRun = false");
        LOGGER.exiting(S_CLASS_NAME, "doIRun");
        return false;
    }
}

