/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.processing.preprocessing;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.datastore.WSProfileDataStore;
import com.ibm.ws.profile.processing.WSProfileProcessorTask;
import com.ibm.ws.profile.utils.DefaultValueManagerUtils;
import com.ibm.ws.profile.utils.SystemPropertiesUtils;
import com.ibm.ws.profile.utils.ValidationManagerUtils;
import com.ibm.ws.profile.utils.WSProfileUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.io.File;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EarlyDefaultingPreProcessorTask
extends WSProfileProcessorTask {
    private static Logger LOGGER = LoggerFactory.createLogger(EarlyDefaultingPreProcessorTask.class);
    private static String S_CLASS_NAME = EarlyDefaultingPreProcessorTask.class.getName();

    public boolean runProcessor() throws Throwable {
        LOGGER.entering(S_CLASS_NAME, "runProcessor");
        boolean fResult = true;
        fResult = this.executeDefaultingAndValidatingOnRequiredArgs();
        if (fResult) {
            for (int i = 0; i < WSProfileDataStore.getNumberOfJobGroupsInDataStore(); ++i) {
                WSProfileCLIModeInvoker wspclimiForExecution = WSProfileDataStore.getJobGroup(i).getCurrentModeInvoker();
                Map<String, List> mSpecifiedArgs = WSProfileDataStore.getJobGroup(i).getCurrentArgsAsMap();
                WSProfileDataStore.getJobGroup(i).setCurrentArgs((Hashtable)WSProfileUtils.addEarlyDefaults(wspclimiForExecution, (Hashtable)mSpecifiedArgs));
            }
        }
        LOGGER.exiting(S_CLASS_NAME, "runProcessor");
        return fResult;
    }

    public boolean checkPreconditions() {
        LOGGER.entering(S_CLASS_NAME, "checkPreconditions");
        for (int i = 0; i < WSProfileDataStore.getNumberOfJobGroupsInDataStore(); ++i) {
            WSProfileCLIModeInvoker wspclimiForExecution = WSProfileDataStore.getJobGroup(i).getCurrentModeInvoker();
            Map<String, List> mSpecifiedArgs = WSProfileDataStore.getJobGroup(i).getCurrentArgsAsMap();
            if (mSpecifiedArgs != null && wspclimiForExecution != null) continue;
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = false");
            LOGGER.exiting(S_CLASS_NAME, "checkPreconditions");
            return false;
        }
        if (WSProfileDataStore.getNumberOfJobGroupsInDataStore() <= 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = false");
            LOGGER.exiting(S_CLASS_NAME, "checkPreconditions");
            return false;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = true");
        LOGGER.exiting(S_CLASS_NAME, "checkPreconditions");
        return true;
    }

    public boolean doIRun() {
        LOGGER.entering(S_CLASS_NAME, "doIRun");
        WSProfileCLIModeInvoker wspclimiFlowControlling = WSProfileDataStore.getFlowControllingModeInvoker();
        Map<String, List> mapFlowControllingArgs = WSProfileDataStore.getFlowControllingArgsAsMap();
        if (wspclimiFlowControlling != null && !WSProfileDataStore.isHelpRequested() && !WSProfile.isAllMode(wspclimiFlowControlling.getModeFlag())) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", "doIRun = " + WSProfileUtils.isEarlyDefaultingNecessary(wspclimiFlowControlling, mapFlowControllingArgs));
            LOGGER.exiting(S_CLASS_NAME, "doIRun");
            return WSProfileUtils.isEarlyDefaultingNecessary(wspclimiFlowControlling, mapFlowControllingArgs);
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", "doIRun = false");
        LOGGER.exiting(S_CLASS_NAME, "doIRun");
        return false;
    }

    private boolean executeDefaultingAndValidatingOnRequiredArgs() {
        LOGGER.entering(S_CLASS_NAME, "executeDefaultingAndValidatingOnRequiredArgs");
        boolean fCurrentValidationResult = true;
        boolean fOverallValidationResult = true;
        for (int i = 0; i < WSProfileDataStore.getNumberOfJobGroupsInDataStore(); ++i) {
            WSProfileCLIModeInvoker wspclimiForExecution = WSProfileDataStore.getJobGroup(i).getCurrentModeInvoker();
            List<WSProfileTemplate> lwsptTemplateStack = WSProfileDataStore.getJobGroup(i).getTemplateStack();
            WSProfileTemplate wsptTopTemplate = lwsptTemplateStack.get(lwsptTemplateStack.size() - 1);
            WSProfileTemplate wsptBaseTemplate = lwsptTemplateStack.get(0);
            String sTemplatePath = wsptTopTemplate.getProfileTemplatePath().getAbsolutePath();
            String sRegistryFilePath = sTemplatePath + File.separator + wspclimiForExecution.getRegistryName();
            if (wsptBaseTemplate.getType().equals("management") && wspclimiForExecution.getModeFlag().equals("create")) {
                Properties origProps = SystemPropertiesUtils.getCurrentSystemProperties();
                System.setProperty("WS_CMT_ACTION_REGISTRY", sRegistryFilePath);
                System.setProperty("WS_CMT_CONF_DIR", sTemplatePath);
                System.setProperty(wspclimiForExecution.getModeFlag(), "");
                SystemPropertiesUtils.setTemplateStackIntoSystemProperties(lwsptTemplateStack);
                String sArgValue = WSProfileDataStore.isArgSpecified("serverType") ? WSProfileDataStore.getFlowControllingArgumentValue("serverType") : DefaultValueManagerUtils.getDefaultValue("serverType");
                System.setProperty("serverType", sArgValue);
                fCurrentValidationResult = ValidationManagerUtils.isArgumentValueValid("serverType", sArgValue);
                SystemPropertiesUtils.resetSystemProperties(origProps);
                if (!fCurrentValidationResult) {
                    WSProfileDataStore.addValidationErrorMessages(ValidationManagerUtils.getAllErrorMessages());
                } else {
                    System.setProperty("serverType", sArgValue);
                }
                ValidationManagerUtils.reinitialize();
                fOverallValidationResult &= fCurrentValidationResult;
                continue;
            }
            LOGGER.exiting(S_CLASS_NAME, "executeDefaultingAndValidatingOnRequiredArgs");
            return true;
        }
        if (!fOverallValidationResult) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "runProcessor", "Validation Failed");
            ValidationManagerUtils.printOutValidationResults(WSProfileDataStore.getAllValidationErrorMessages());
        }
        WSProfileDataStore.setValidationResult(fOverallValidationResult);
        LOGGER.exiting(S_CLASS_NAME, "executeDefaultingAndValidatingOnRequiredArgs");
        return fOverallValidationResult;
    }
}

