/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.processing;

import com.ibm.ws.install.configmanager.ijc.IJC;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class WSProfileProcessorTask
implements IJC {
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfileProcessorTask.class);
    private static final String S_CLASS_NAME = WSProfileProcessorTask.class.getName();
    protected static final String S_EMPTY = "";

    public final boolean execute() {
        try {
            if (this.doIRun()) {
                if (!this.checkPreconditions()) {
                    LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Precondition checking failed.");
                    return false;
                }
                boolean b_result = this.runProcessor();
                if (!b_result) {
                    LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "[" + this.getClass().getName() + "] ran with result = " + b_result);
                    return b_result;
                }
                if (!this.checkPostconditions()) {
                    LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Postcondition checking failed.");
                    return false;
                }
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "execute", "[" + this.getClass().getName() + "] ran with result = " + b_result);
                return b_result;
            }
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "execute", "doIRun = false :[" + this.getClass().getName() + "] execution skipped");
            return true;
        }
        catch (Throwable e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Exception thrown during execution of the [" + this.getClass().getName() + "] processor task.  Exception message follows.");
            LogUtils.logException(LOGGER, e);
            return false;
        }
    }

    public abstract boolean runProcessor() throws Throwable;

    public boolean checkPreconditions() {
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = true");
        return true;
    }

    public boolean checkPostconditions() {
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPostconditions", "checkPostconditions = true");
        return true;
    }

    public boolean doIRun() {
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", "doIRun = true");
        return true;
    }

    public String getErrorOutput() {
        return null;
    }

    public String getOutput() {
        return null;
    }
}

