/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.defaulters;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.WASUtilities;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.defaulters.GenericDefaulter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebServerPluginPathDefaulter
extends GenericDefaulter {
    public final String S_WSPROFILE_DEFAULTERS_WEBSERVER_PLUGIN_PATH_KEY = "WSProfile.Defaulters.webserver.pluginpath.";
    private static final Logger LOGGER = LoggerFactory.createLogger(WebServerPluginPathDefaulter.class);
    private static final String S_CLASS_NAME = WebServerPluginPathDefaulter.class.getName();
    public final String S_PERIOD = ".";
    public final String S_DEFAULT_PROGRAM_FILES_LOCATION = "C:\\Program Files";

    public boolean runDefaulter() throws IOException {
        LOGGER.entering(WebServerPluginPathDefaulter.class.getName(), "runDefaulter");
        String sWAS_HOME = System.getProperty("WAS_HOME");
        if (sWAS_HOME == null) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("WSProfile.Defaulters.arg_not_set", "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle"), "WAS_HOME");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runDefaulter", this.sErrorMessage);
            LOGGER.exiting(WebServerPluginPathDefaulter.class.getName(), "runDefaulter");
            return false;
        }
        String sWebServerType = System.getProperty("webServerType");
        if (sWebServerType == null) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("WSProfile.Defaulters.arg_not_set", "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle"), "webServerType");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runDefaulter", this.sErrorMessage);
            LOGGER.exiting(WebServerPluginPathDefaulter.class.getName(), "runDefaulter");
            return false;
        }
        String sWebServerOS = System.getProperty("webServerOS");
        if (sWebServerOS == null) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("WSProfile.Defaulters.arg_not_set", "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle"), "webServerOS");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runDefaulter", this.sErrorMessage);
            LOGGER.exiting(WebServerPluginPathDefaulter.class.getName(), "runDefaulter");
            return false;
        }
        String sPath = ResourceBundleUtils.getResourceBundleLocaleString("WSProfile.Defaulters.webserver.pluginpath." + sWebServerType + "." + sWebServerOS, "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle");
        if (sWebServerOS.equals("windows")) {
            String sProgramFiles = WASUtilities.isWindows() ? WASUtilities.getEnvironmentVariable("ProgramFiles") : "C:\\Program Files";
            if (sProgramFiles == null || sProgramFiles.equals("")) {
                sProgramFiles = "C:\\Program Files";
            }
            sPath = MessageFormat.format(sPath, sProgramFiles);
        }
        this.sDefaultedValue = sPath;
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runDefaulter", this.getOutput());
        LOGGER.exiting(WebServerPluginPathDefaulter.class.getName(), "runDefaulter");
        return true;
    }

    public boolean doIRun() {
        LOGGER.entering(WebServerPluginPathDefaulter.class.getName(), "doIRun");
        this.bDoIRun = true;
        String sWebServerCheck = System.getProperty("webServerCheck");
        if (sWebServerCheck == null || !sWebServerCheck.equals("true")) {
            this.bDoIRun = false;
        }
        LOGGER.exiting(WebServerPluginPathDefaulter.class.getName(), "doIRun");
        return this.bDoIRun;
    }
}

