/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.defaulters;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.TargetPlatform;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfileTemplate;
import com.ibm.wsspi.profile.defaulters.GenericDefaulter;
import java.io.File;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerNameDefaulter
extends GenericDefaulter {
    private static final Logger LOGGER = LoggerFactory.createLogger(ServerNameDefaulter.class);
    private static final String S_CLASS_NAME = ServerNameDefaulter.class.getName();

    /*
     * Enabled aggressive block sorting
     */
    public boolean runDefaulter() throws Exception {
        LOGGER.entering(ServerNameDefaulter.class.getName(), "runDefaulter");
        if (TargetPlatform.isOS400()) {
            this.sDefaultedValue = System.getProperty("profileName");
            if (this.sDefaultedValue == null) {
                this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("WSProfile.Defaulters.arg_not_set", "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle"), "profileName");
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runDefaulter", this.sErrorMessage);
                LOGGER.exiting(ServerNameDefaulter.class.getName(), "runDefaulter");
                return false;
            }
        } else {
            String templatePath = System.getProperty("templatePath");
            WSProfileTemplate template = new WSProfileTemplate(new File(templatePath));
            String templateType = template.getType();
            if (templateType == null || templateType.equals("")) {
                this.sDefaultedValue = "";
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runDefaulter", "The template type cannot be found");
                return false;
            }
            if (templateType.equals("default")) {
                this.sDefaultedValue = "server1";
            } else if (templateType.equals("secureProxy")) {
                this.sDefaultedValue = "proxy1";
            } else {
                if (!templateType.equals("management")) {
                    this.sDefaultedValue = "";
                    LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runDefaulter", "The template type cannot be found");
                    return false;
                }
                String sServerType = System.getProperty("serverType");
                if (sServerType == null || sServerType.equals("")) {
                    this.sDefaultedValue = "";
                    LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runDefaulter", "The required argument serverType has not been specified.");
                    return false;
                }
                if (sServerType.equals("ADMIN_AGENT")) {
                    this.sDefaultedValue = "adminagent";
                } else if (sServerType.equals("DEPLOYMENT_MANAGER")) {
                    this.sDefaultedValue = "dmgr";
                } else {
                    if (!sServerType.equals("JOB_MANAGER")) {
                        this.sDefaultedValue = "";
                        LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runDefaulter", "The required argument serverType=" + sServerType + " has been specified incorrectly.");
                        return false;
                    }
                    this.sDefaultedValue = "jobmgr";
                }
            }
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runDefaulter", this.getOutput());
        LOGGER.exiting(ServerNameDefaulter.class.getName(), "runDefaulter");
        return true;
    }
}

