/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.defaulters;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.WASUtilities;
import com.ibm.ws.profile.defaulters.UniqueTokenCreatorDefaulter;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProfileNameDefaulter
extends UniqueTokenCreatorDefaulter {
    public final String S_WSPROFILE_DEFAULTERS_PROFILE_NAME_SEED = "WSProfile.Defaulters.profileNameSeed.";
    private static final Logger LOGGER = LoggerFactory.createLogger(ProfileNameDefaulter.class);
    private static final String S_CLASS_NAME = ProfileNameDefaulter.class.getName();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean runDefaulter() throws Exception {
        File default_dir;
        List profileNameList;
        boolean result;
        block13: {
            String templateType;
            block14: {
                block15: {
                    LOGGER.entering(ProfileNameDefaulter.class.getName(), "runDefaulter");
                    result = false;
                    String templatePath = System.getProperty("templatePath");
                    templateType = "";
                    WSProfileTemplate template = new WSProfileTemplate(new File(templatePath));
                    templateType = template.getType();
                    if (!templateType.equals("management")) break block14;
                    String sServerType = System.getProperty("serverType");
                    if (sServerType == null || sServerType.equals("")) break block15;
                    if (sServerType.equals("ADMIN_AGENT")) {
                        this.setSeed("AdminAgent");
                        break block13;
                    } else if (sServerType.equals("DEPLOYMENT_MANAGER")) {
                        this.setSeed("Dmgr");
                        break block13;
                    } else {
                        if (!sServerType.equals("JOB_MANAGER")) {
                            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runDefaulter", "The required argument serverType=" + sServerType + " has been specified incorrectly.");
                            return false;
                        }
                        this.setSeed("JobMgr");
                    }
                    break block13;
                }
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runDefaulter", "The required argument serverType has not been specified.");
                return false;
            }
            this.setSeed(ResourceBundleUtils.getResourceBundleLocaleString("WSProfile.Defaulters.profileNameSeed." + templateType, "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle"));
            if (!this.validateResourceBundleReturn("WSProfile.Defaulters.profileNameSeed." + templateType, this.getSeed())) {
                LOGGER.exiting(ProfileNameDefaulter.class.getName(), "runDefaulter");
                return false;
            }
        }
        String existingTokens = "";
        try {
            profileNameList = WSProfile.listAllProfileNames();
        }
        catch (WSProfileException e) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runDefaulter", "Could not find a profileRegistry.xml file, assuming no profiles currently exist");
            profileNameList = null;
        }
        if (profileNameList != null) {
            for (int i = 0; i < profileNameList.size(); ++i) {
                String name = (String)profileNameList.get(i);
                existingTokens = ProfileNameDefaulter.addToken(existingTokens, this.getTokensSeparator(), name);
            }
        }
        if ((default_dir = new File(WASUtilities.getWASProperty("WS_WSPROFILE_DEFAULT_PROFILE_HOME").trim())).isDirectory()) {
            File[] aDir_list = default_dir.listFiles();
            for (int i = 0; i < aDir_list.length; ++i) {
                if (!aDir_list[i].isDirectory()) continue;
                String name = aDir_list[i].getName();
                existingTokens = ProfileNameDefaulter.addToken(existingTokens, this.getTokensSeparator(), name);
            }
        }
        this.setExistingTokens(existingTokens);
        result = this.generateSuggestion();
        if (result) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runDefaulter", this.getOutput());
        }
        LOGGER.exiting(ProfileNameDefaulter.class.getName(), "runDefaulter");
        return result;
    }

    public boolean runDefaulterDisconnected() {
        this.sDefaultedValue = "";
        return true;
    }
}

