/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.defaulters;

import com.ibm.websphere.product.WASSystem;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.profile.WASUtilities;
import com.ibm.ws.profile.WSProfileContext;
import com.ibm.ws.profile.defaulters.FindNodeCellNamesUtil;
import com.ibm.ws.profile.defaulters.UniqueTokenCreatorDefaulter;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.utils.StringUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NodeNameDefaulter
extends UniqueTokenCreatorDefaulter {
    public static final String S_WSPROFILE_DEFAULTERS_NODE_NAME_SEED = "WSProfile.Defaulters.nodeNameSeed.";
    public static final String S_WSPROFILE_DEFAULTERS_NODE_NAME_OS400_TAIL = "WSProfile.Defaulters.nodeNameTail.os400.";
    private static final Logger LOGGER = LoggerFactory.createLogger(NodeNameDefaulter.class);
    private static final String S_CLASS_NAME = NodeNameDefaulter.class.getName();
    public static final String S_COLON = ":";
    public static final String S_FORCE_PREFIX = "force";
    public static final String S_IS_FORCE_REGEX = "^force:*";
    public static final String S_FORCE_DIST = "dist";
    public static final String S_FORCE_OS400 = "os400";
    public static final String S_FORCE_DIST_DEFAULT = "force:dist:default";
    public static final String S_FORCE_OS400_DEFAULT = "force:os400:default";

    public boolean runDefaulter() throws Exception {
        LOGGER.entering(NodeNameDefaulter.class.getName(), "runDefaulter");
        boolean result = false;
        String templatePath = System.getProperty("templatePath");
        String templateType = "";
        WSProfileTemplate template = new WSProfileTemplate(new File(templatePath));
        templateType = template.getType();
        result = this.generateNodeName(templateType);
        if (result) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runDefaulter", this.getOutput());
        }
        LOGGER.exiting(NodeNameDefaulter.class.getName(), "runDefaulter");
        return result;
    }

    public boolean runDefaulterDisconnected() {
        this.sDefaultedValue = "";
        return true;
    }

    protected boolean generateOS400NodeName(String templateType, String hostName) {
        String sProfileName = System.getProperty("profileName");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "generateOS400NodeName", "using os400 defaulter");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "generateOS400NodeName", "profileName set to [" + sProfileName + "] in system properties");
        this.sDefaultedValue = templateType.equals("cell.dmgr") || templateType.equals("dmgr") ? sProfileName + ResourceBundleUtils.getResourceBundleLocaleString(S_WSPROFILE_DEFAULTERS_NODE_NAME_OS400_TAIL + templateType, "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle") : (hostName.equals("LOOPBACK") ? "LOCAL_" + sProfileName : hostName + "_" + sProfileName);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean generateDistributedNodeName(String templateType, String hostName) throws Exception {
        block21: {
            block22: {
                block23: {
                    if (!templateType.equals("management")) break block22;
                    String sServerType = System.getProperty("serverType");
                    if (sServerType == null || sServerType.equals("")) break block23;
                    if (sServerType.equals("ADMIN_AGENT")) {
                        this.setSeed(hostName + "AANode");
                        break block21;
                    } else if (sServerType.equals("DEPLOYMENT_MANAGER")) {
                        this.setSeed(hostName + "CellManager");
                        break block21;
                    } else {
                        if (!sServerType.equals("JOB_MANAGER")) {
                            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runDefaulter", "The required argument serverType=" + sServerType + " has been specified incorrectly.");
                            return false;
                        }
                        this.setSeed(hostName + "JobMgr");
                    }
                    break block21;
                }
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runDefaulter", "The required argument serverType has not been specified.");
                return false;
            }
            this.setSeed(hostName + ResourceBundleUtils.getResourceBundleLocaleString(S_WSPROFILE_DEFAULTERS_NODE_NAME_SEED + templateType, "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle"));
        }
        if (!this.validateResourceBundleReturn(S_WSPROFILE_DEFAULTERS_NODE_NAME_SEED + templateType, this.getSeed())) {
            return false;
        }
        String existingTokens = "";
        LinkedList<String> profileLocationList = new LinkedList<String>();
        WSProfileContext currentContext = new WSProfileContext();
        currentContext.saveCurrentContext();
        WASSystem wasSystem = WASSystem.getWASSystemInstance();
        String sCurrent_WAS_HOME = System.getProperty("WAS_HOME");
        String[] saWASLocations = wasSystem.getNonCachedWASLocations();
        if (saWASLocations.length > 1) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "generateDistributedNodeName", "Located the following WAS home(s): " + StringUtils.convertStringArrayToCommaSeparatedString(saWASLocations));
        } else {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "generateDistributedNodeName", "No other WAS home directories have been found");
        }
        int wasInstall = 0;
        while (true) {
            if (wasInstall >= saWASLocations.length) {
                currentContext.restoreSavedContext();
                this.setExistingTokens(existingTokens);
                return this.generateSuggestion();
            }
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "generateDistributedNodeName", "Scanning WAS location:" + saWASLocations[wasInstall]);
            try {
                int i;
                currentContext.switchContext(saWASLocations[wasInstall]);
                List profileNameList = WSProfile.listProfileNames();
                for (i = 0; i < profileNameList.size(); ++i) {
                    profileLocationList.add(WSProfile.getProfileLocation("" + profileNameList.get(i)).getAbsolutePath());
                }
                if (profileLocationList != null) {
                    for (i = 0; i < profileLocationList.size(); ++i) {
                        String name = (String)profileLocationList.get(i);
                        FindNodeCellNamesUtil nodeName = new FindNodeCellNamesUtil(name);
                        existingTokens = NodeNameDefaulter.addToken(existingTokens, this.getTokensSeparator(), nodeName.getNodeNameFound());
                    }
                }
            }
            catch (Exception e) {
                try {
                    sCurrent_WAS_HOME = new File(sCurrent_WAS_HOME).getCanonicalPath();
                }
                catch (IOException e1) {
                    sCurrent_WAS_HOME = null;
                    LOGGER.logp(Level.WARNING, S_CLASS_NAME, "generateDistributedNodeName", "Problems occurred when retrieving reference to current install.  Exception follows.");
                    LogUtils.logException(LOGGER, e1);
                    throw e;
                }
                String s_Install_under_review = null;
                try {
                    s_Install_under_review = new File(saWASLocations[wasInstall]).getCanonicalPath();
                }
                catch (IOException e1) {
                    s_Install_under_review = null;
                    LOGGER.logp(Level.WARNING, S_CLASS_NAME, "generateDistributedNodeName", "Problems occurred when retrieving reference to the WAS install:" + saWASLocations[wasInstall]);
                    LogUtils.logException(LOGGER, e1);
                }
                if (sCurrent_WAS_HOME != null && s_Install_under_review != null) {
                    if (sCurrent_WAS_HOME.equals(s_Install_under_review)) {
                        LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "generateDistributeNodeName", "There are problems with the current install: " + saWASLocations[wasInstall]);
                        LogUtils.logException(LOGGER, e);
                        throw e;
                    }
                    LOGGER.logp(Level.WARNING, S_CLASS_NAME, "generateDistributedNodeName", "Ignoring incomplete installation: " + saWASLocations[wasInstall]);
                }
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "generateDistributedNodeName", "Ignoring incomplete installation: " + saWASLocations[wasInstall]);
            }
            profileLocationList = new LinkedList();
            ++wasInstall;
        }
    }

    public boolean generateNodeName(String type) throws Exception {
        LOGGER.entering(NodeNameDefaulter.class.getName(), "generateNodeName");
        String templateType = type;
        String hostName = System.getProperty("hostName");
        if (hostName == null) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "generateNodeName", "hostName was not set in the system properties, will use an empty string");
            hostName = "";
        } else {
            hostName = WASUtilities.getShortHostName(hostName);
        }
        if (this.isForcedOption(templateType)) {
            return this.executeForcedOption(templateType, hostName);
        }
        if (PlatformConstants.isCurrentPlatformOS400()) {
            LOGGER.exiting(NodeNameDefaulter.class.getName(), "generateNodeName");
            return this.generateOS400NodeName(templateType, hostName);
        }
        LOGGER.exiting(NodeNameDefaulter.class.getName(), "generateNodeName");
        return this.generateDistributedNodeName(templateType, hostName);
    }

    private boolean isForcedOption(String option) {
        Pattern pattern = Pattern.compile(S_IS_FORCE_REGEX);
        Matcher matcher = pattern.matcher(option);
        return matcher.find();
    }

    private boolean executeForcedOption(String templateType, String hostName) throws Exception {
        StringTokenizer tokenizer = new StringTokenizer(templateType, S_COLON);
        tokenizer.nextToken();
        String sPlatform = tokenizer.nextToken();
        String type = tokenizer.nextToken();
        if (sPlatform.equals(S_FORCE_DIST)) {
            return this.generateDistributedNodeName(type, hostName);
        }
        return this.generateOS400NodeName(type, hostName);
    }
}

