/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.cli;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.logging.LoggerFactoryConstants;
import com.ibm.ws.profile.cli.CommandLineArgument;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.util.Arrays;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WSProfileCLIUnaugmentAllProfileInvoker
extends WSProfileCLIModeInvoker {
    private boolean fIsPublic = true;
    private static final CommandLineArgument[] ACLA_RESERVED_REQUIRED_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("unaugmentAll", V_EMPTY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("templatePath", V_SINGLE_ENTRY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final CommandLineArgument[] ACLA_RESERVED_OPTIONAL_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("unaugmentDependents", V_SINGLE_ENTRY_VECTOR, false, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfileCLIUnaugmentAllProfileInvoker.class);
    private static final String S_CLASS_NAME = WSProfileCLIUnaugmentAllProfileInvoker.class.getName();

    public WSProfileCLIUnaugmentAllProfileInvoker() {
        this.S_SUCCESS_KEY = "WSProfile.WSProfileCLIUnaugmentAllProfileInvoker.successMessage";
        this.S_PARTIAL_SUCCESS_KEY = "WSProfile.WSProfileCLIUnaugmentAllProfileInvoker.partialSuccessMessage";
        this.S_FAILURE_KEY = "WSProfile.WSProfileCLIUnaugmentAllProfileInvoker.failureMessage";
    }

    public String getModeFlag() {
        LOGGER.entering(this.getClass().getName(), "getModeFlag");
        LOGGER.exiting(this.getClass().getName(), "getModeFlag");
        return "unaugmentAll";
    }

    public boolean isTemplateStackRequired() {
        LOGGER.entering(this.getClass().getName(), "isTemplateStackRequired");
        LOGGER.exiting(this.getClass().getName(), "isTemplateStackRequired");
        return true;
    }

    public boolean isValidationAllowed() {
        LOGGER.entering(S_CLASS_NAME, "isValidationAllowed");
        LOGGER.exiting(S_CLASS_NAME, "isValidationAllowed");
        return true;
    }

    protected int executeWSProfileAccordingToMode() {
        LOGGER.entering(this.getClass().getName(), "invokeWSProfile");
        int nReturnCode = 1;
        String sTemplatePath = this.getArgumentValue("templatePath");
        if (sTemplatePath == null) {
            return nReturnCode;
        }
        try {
            nReturnCode = WSProfile.unaugmentAll(new WSProfileTemplate(sTemplatePath), CommandLineArgument.convertCommandLineArgumentListToMap(this.getIncomingCommandLineArguments()));
        }
        catch (WSProfileException wspe) {
            LogUtils.logException(LOGGER, wspe);
            nReturnCode = 1;
        }
        if (nReturnCode == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(this.S_FAILURE_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        if (nReturnCode == 2) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(this.S_PARTIAL_SUCCESS_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        if (nReturnCode == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(this.S_SUCCESS_KEY));
        }
        LOGGER.exiting(this.getClass().getName(), "invokeWSProfile");
        return nReturnCode;
    }

    protected Vector getListOfRequiredCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        Vector<CommandLineArgument> vclaRet = new Vector<CommandLineArgument>(Arrays.asList(ACLA_RESERVED_REQUIRED_ARGUMENTS));
        LOGGER.exiting(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        return vclaRet;
    }

    protected Vector getListOfOptionalCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfOptionalCommandLineArguments");
        Vector<CommandLineArgument> vclaRet = new Vector<CommandLineArgument>(Arrays.asList(ACLA_RESERVED_OPTIONAL_ARGUMENTS));
        LOGGER.exiting(this.getClass().getName(), "getListOfOptionalCommandLineArguments");
        return vclaRet;
    }

    public boolean isPublicMode() {
        return this.fIsPublic;
    }
}

