/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.cli;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.logging.LoggerFactoryConstants;
import com.ibm.ws.profile.WSProfileConstants;
import com.ibm.ws.profile.WSProfileJob;
import com.ibm.ws.profile.cli.CommandLineArgument;
import com.ibm.ws.profile.cli.WSProfileCLIAugmentProfileInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIBackupProfileInvoker;
import com.ibm.ws.profile.cli.WSProfileCLICheckProfileRegistryIntegrityInvoker;
import com.ibm.ws.profile.cli.WSProfileCLICreateProfileInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIDeleteAllProfileInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIDeleteProfileInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIEditProfileInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIGetDefaultProfileNameInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIGetProfileNameInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIGetProfilePathInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIHelpInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIListAugmentsInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIListProfileInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIListProfilesInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIRegisterProfileInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIResponseInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIRestoreProfileInvoker;
import com.ibm.ws.profile.cli.WSProfileCLISetDefaultProfileNameInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIUnaugmentAllProfileInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIUnaugmentProfileInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIUnlockProfileInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIUnregisterProfileInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIUpdateProfileRegistryInvoker;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.datastore.WSProfileDataStore;
import com.ibm.ws.profile.utils.CommandLineArgumentsUtils;
import com.ibm.ws.profile.utils.FileUtils;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.utils.SystemPropertiesUtils;
import com.ibm.ws.profile.utils.ValidationManagerUtils;
import com.ibm.ws.profile.utils.WSProfileUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WSProfileCLIModeInvoker {
    private Vector m_vclaIncomingCommandLineArguments = new Vector();
    protected static final Class[] aclassRegisteredInvokers = new Class[]{WSProfileCLICreateProfileInvoker.class, WSProfileCLIAugmentProfileInvoker.class, WSProfileCLIDeleteProfileInvoker.class, WSProfileCLIUnaugmentProfileInvoker.class, WSProfileCLIUnaugmentAllProfileInvoker.class, WSProfileCLIEditProfileInvoker.class, WSProfileCLIListProfileInvoker.class, WSProfileCLIDeleteAllProfileInvoker.class, WSProfileCLIListProfilesInvoker.class, WSProfileCLIListAugmentsInvoker.class, WSProfileCLIRegisterProfileInvoker.class, WSProfileCLIUnregisterProfileInvoker.class, WSProfileCLIBackupProfileInvoker.class, WSProfileCLIRestoreProfileInvoker.class, WSProfileCLIGetProfileNameInvoker.class, WSProfileCLIGetProfilePathInvoker.class, WSProfileCLICheckProfileRegistryIntegrityInvoker.class, WSProfileCLIUpdateProfileRegistryInvoker.class, WSProfileCLIGetDefaultProfileNameInvoker.class, WSProfileCLISetDefaultProfileNameInvoker.class, WSProfileCLIResponseInvoker.class, WSProfileCLIUnlockProfileInvoker.class, WSProfileCLIHelpInvoker.class};
    public static final String S_DASH = "-";
    protected static final String S_SPACE = " ";
    protected static final String S_NEWLINE = "\n";
    protected static final String S_ARGUMENT_SYNTAX = "-<argument> <argument parameter> ...";
    protected static final String S_ARGUMENT_PARAMETER = "<argument parameter>";
    protected static final String S_MANAGEPROFILES = "manageprofiles";
    protected static final String S_TAB = "   ";
    protected static final String S_MODE = "<mode>";
    protected static final String S_KEY_TEMPLATE_NOTES = "WSProfile.templateSpecificHelpMessage";
    protected static final String S_TEMPLATE_INFO_TAG = "Template Information:";
    protected static final String S_EMPTY = "";
    protected static final Vector V_EMPTY_VECTOR = new Vector();
    protected static final Vector<String> V_SINGLE_ENTRY_VECTOR = new Vector<String>(Arrays.asList(""));
    private static final CommandLineArgument[] ACLA_RESERVED_OPTIONAL_REMOTE_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("remote", V_SINGLE_ENTRY_VECTOR, false, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("remoteOS", V_SINGLE_ENTRY_VECTOR, false, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("remoteHostName", V_SINGLE_ENTRY_VECTOR, false, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("remoteUserName", V_SINGLE_ENTRY_VECTOR, false, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("remotePassword", V_SINGLE_ENTRY_VECTOR, false, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("remoteInstallPath", V_SINGLE_ENTRY_VECTOR, false, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final String S_COLON = ":";
    private static final String S_CLA_RESOURCE_BUNDLE_HELP_KEY_POSTFIX = ".help";
    private static final String S_WSPROFILE = "WSProfile.";
    private static final String S_FUNTIONAL_DESCRIPTION = ".functionalDescription";
    private static final String S_VALIDATION_ERROR_KEY = "WSProfile.WSProfileCLIModeInvoker.validationError";
    private static final String S_PROFILE_REGISTRY_ACCESS_FAILED_KEY = "WSProfile.WSProfileCLIModeInvoker.registryFileAcquireFailed";
    private static final String S_PROFILE_REGISTRY_ACCESS_FAILED = "Unable to access profile registry file ";
    private static final String S_NOTES_SPACE_IN_ARG = "WSProfile.WSProfileCLIModeInvokerNotes.doubleQuotes";
    private static final String S_NOTES_REMOTEOS_ARG = "WSProfile.WSProfileCLIModeInvokerNotes.remoteOSSpecificArg";
    private static final String S_NOTES_DEFAULT_TEMPLATE = "WSProfile.WSProfileCLIModeInvokerNotes.defaultTemplate";
    private static final String S_NOTES_PATH_KEY = "WSProfile.WSProfileCLIModeInvokerNotes.templateSpecificArgs";
    private static final String S_NOTES_TEMPLATE_HELP_KEY = "WSProfile.WSProfileCLIModeInvokerNotes.templateSpecificHelp";
    private static final String S_NOTES_CASE_SENSITIVE_ARGS_KEY = "WSProfile.WSProfileCLIModeInvokerNotes.caseSensitiveArgs";
    private static final String S_NOTES_MODE_ARGS_KEY = "WSProfile.WSProfileCLIModeInvokerNotes.modeSpecificArgs";
    protected String S_FAILURE_KEY = "";
    protected String S_PARTIAL_SUCCESS_KEY = "";
    protected String S_SUCCESS_KEY = "";
    protected String S_FUNCTIONAL_DESCRIPTION = "";
    public static final Logger LOGGER = LoggerFactory.createLogger(WSProfileCLIModeInvoker.class);
    private static final String S_CLASS_NAME = WSProfileCLIModeInvoker.class.getName();

    public static WSProfileCLIModeInvoker findModeInvoker(String[] saSpecifiedArgs) {
        Vector vclaIncomingCommandLineArguments = CommandLineArgumentsUtils.convertIncomingCommandLineToCommandLineArguments(saSpecifiedArgs);
        for (int i = 0; i < aclassRegisteredInvokers.length; ++i) {
            Class classInvokerThis = aclassRegisteredInvokers[i];
            try {
                WSProfileCLIModeInvoker wspclimiThis = (WSProfileCLIModeInvoker)classInvokerThis.newInstance();
                wspclimiThis.m_vclaIncomingCommandLineArguments = vclaIncomingCommandLineArguments;
                Hashtable ht_args = CommandLineArgumentsUtils.convertCommandLineToHashtable(saSpecifiedArgs);
                if (ht_args.get(wspclimiThis.getModeFlag()) == null) continue;
                return wspclimiThis;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        return new WSProfileCLIHelpInvoker();
    }

    public static boolean isTheUserRequestingHelp(String[] args) {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "isUserRequestingHelp");
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "isUserRequestingHelp");
        return Arrays.asList(args).contains("-help");
    }

    public static int doHelpMode(String[] args) {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "doHelpMode");
        Vector vclaIncomingCommandLineArguments = CommandLineArgumentsUtils.convertIncomingCommandLineToCommandLineArguments(args);
        for (int i = 0; i < aclassRegisteredInvokers.length; ++i) {
            Class classInvokerThis = aclassRegisteredInvokers[i];
            try {
                WSProfileCLIModeInvoker wspclimiThis = (WSProfileCLIModeInvoker)classInvokerThis.newInstance();
                wspclimiThis.m_vclaIncomingCommandLineArguments = vclaIncomingCommandLineArguments;
                CommandLineArgument claThisModeArgument = new CommandLineArgument(wspclimiThis.getModeFlag(), new Vector());
                if (!CommandLineArgument.isThisModePresentInThisExpectedList(claThisModeArgument, vclaIncomingCommandLineArguments)) continue;
                wspclimiThis.doHelp();
                LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "doHelpMode");
                return 0;
            }
            catch (IllegalAccessException e) {
                LogUtils.logException(LOGGER, e);
                LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "doHelpMode");
                return 1;
            }
            catch (InstantiationException e) {
                LogUtils.logException(LOGGER, e);
                LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "doHelpMode");
                return 1;
            }
        }
        if (vclaIncomingCommandLineArguments == null || vclaIncomingCommandLineArguments.size() == 0) {
            new WSProfileCLIHelpInvoker().doGeneralHelp();
            LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "doHelpMode");
            return 0;
        }
        new WSProfileCLIHelpInvoker().doHelp();
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "doHelpMode");
        return 0;
    }

    public static WSProfileCLIModeInvoker getModeInvoker(String[] args) {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "getModeInvoker");
        Vector vclaIncomingCommandLineArguments = CommandLineArgumentsUtils.convertIncomingCommandLineToCommandLineArguments(args);
        try {
            for (int i = 0; i < aclassRegisteredInvokers.length; ++i) {
                Class classInvokerThis = aclassRegisteredInvokers[i];
                WSProfileCLIModeInvoker wspclimiThis = (WSProfileCLIModeInvoker)classInvokerThis.newInstance();
                wspclimiThis.m_vclaIncomingCommandLineArguments = vclaIncomingCommandLineArguments;
                Vector vclaExpectedCommandLineArguments = wspclimiThis.getListOfRequiredCommandLineArguments();
                if (!WSProfileCLIModeInvoker.checkIfCommandLineIsSufficientForThisMode(vclaIncomingCommandLineArguments, vclaExpectedCommandLineArguments)) continue;
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getModeInvoker", "Identified WSProfile mode invoker to be: " + wspclimiThis.getClass().getName());
                LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "getModeInvoker");
                return wspclimiThis;
            }
        }
        catch (IllegalAccessException e) {
            LogUtils.logException(LOGGER, e);
            LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "getModeInvoker");
            return new WSProfileCLIHelpInvoker();
        }
        catch (InstantiationException e) {
            LogUtils.logException(LOGGER, e);
            LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "getModeInvoker");
            return new WSProfileCLIHelpInvoker();
        }
        LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "getModeInvoker", "Unreachable code block reached.");
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "getModeInvoker");
        return new WSProfileCLIHelpInvoker();
    }

    public void setIncomingCommandLineArguments(Vector incomingCommandLineArguments) {
        this.m_vclaIncomingCommandLineArguments = incomingCommandLineArguments;
    }

    public List findArgumentsNeedingDefaults(Vector vclaCommandLineArguments) {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "findArgumentsNeedingDefaults");
        Vector<String> listArgumentsToDefault = new Vector<String>();
        for (int i = 0; i < vclaCommandLineArguments.size(); ++i) {
            CommandLineArgument claExpectedThis = (CommandLineArgument)vclaCommandLineArguments.elementAt(i);
            if (CommandLineArgument.isThisArgumentKeyPresentInThisExpectedList(claExpectedThis, this.m_vclaIncomingCommandLineArguments) || claExpectedThis.getDefaulter() == null) continue;
            listArgumentsToDefault.add(claExpectedThis.getKey());
        }
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "findArgumentsNeedingDefaults");
        return listArgumentsToDefault;
    }

    public boolean isTemplateStackRequired() {
        LOGGER.entering(S_CLASS_NAME, "isTemplateStackRequired");
        LOGGER.exiting(S_CLASS_NAME, "isTemplateStackRequired");
        return false;
    }

    public boolean isDefaultingAllowed() {
        LOGGER.entering(S_CLASS_NAME, "isDefaultingAllowed");
        LOGGER.exiting(S_CLASS_NAME, "isDefaultingAllowed");
        return false;
    }

    public boolean isValidationAllowed() {
        LOGGER.entering(S_CLASS_NAME, "isValidationAllowed");
        LOGGER.exiting(S_CLASS_NAME, "isValidationAllowed");
        return false;
    }

    public Map<String, List> generateJobArgs(Map<String, List> mJobGroupArgs, List<WSProfileTemplate> lwsptTemplateStack, int nJobNumber) {
        LOGGER.entering(S_CLASS_NAME, "generateJobArgs");
        Map<String, List> mBrokenDownArgs = WSProfileUtils.cloneMap(mJobGroupArgs);
        Vector<String> vTemplatePath = new Vector<String>();
        Vector<String> vProfilePath = new Vector<String>();
        if (mBrokenDownArgs.get("templatePath") != null) {
            vTemplatePath.add(lwsptTemplateStack.get(nJobNumber).getProfileTemplatePath().getPath());
            mBrokenDownArgs.put("templatePath", vTemplatePath);
        }
        if (mBrokenDownArgs.get("profilePath") != null) {
            vProfilePath.add(FileUtils.getNormalizedPath((String)mBrokenDownArgs.get("profilePath").get(0)));
            mBrokenDownArgs.put("profilePath", vProfilePath);
        }
        LOGGER.exiting(S_CLASS_NAME, "generateJobArgs");
        return mBrokenDownArgs;
    }

    public List<WSProfileJob> generateJobsForMode(Map<String, List> mJobGroupArgs, List<WSProfileTemplate> lwsptTemplateStack) {
        LOGGER.entering(S_CLASS_NAME, "generateJobsForMode");
        Vector<WSProfileJob> lwspjFromGroup = new Vector<WSProfileJob>();
        if (this.isTemplateStackRequired()) {
            for (int i = 0; i < lwsptTemplateStack.size(); ++i) {
                lwspjFromGroup.add(new WSProfileJob(this.generateJobArgs(mJobGroupArgs, lwsptTemplateStack, i)));
            }
        } else {
            lwspjFromGroup.add(new WSProfileJob(WSProfileUtils.cloneMap(mJobGroupArgs)));
        }
        LOGGER.exiting(S_CLASS_NAME, "generateJobsForMode");
        return lwspjFromGroup;
    }

    public void printOutExecutionResult(int nReturnCode, Map<String, List> mapArgs) {
        LOGGER.entering(S_CLASS_NAME, "getExecutionResultMessage");
        String sReturnMessageKey = new String();
        if (nReturnCode == 1) {
            sReturnMessageKey = this.S_FAILURE_KEY;
        } else if (nReturnCode == 2) {
            sReturnMessageKey = this.S_PARTIAL_SUCCESS_KEY;
        } else if (nReturnCode == 0) {
            sReturnMessageKey = this.S_SUCCESS_KEY;
        }
        String sExecutionMessage = ResourceBundleUtils.getLocaleString(sReturnMessageKey, LoggerFactoryConstants.getGlobalLogFilePath());
        if (!sExecutionMessage.equals(sReturnMessageKey)) {
            OutputStreamHandler.println(sExecutionMessage);
        } else {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "printOutExecutionResult", "A message for the key " + sReturnMessageKey + " does not exist in the resource bundle.");
        }
        LOGGER.exiting(S_CLASS_NAME, "getExecutionResultMessage");
    }

    public int invokeWSProfile() {
        return this.executeWSProfileAccordingToMode();
    }

    public abstract String getModeFlag();

    public String getRegistryName() {
        return null;
    }

    protected abstract int executeWSProfileAccordingToMode();

    protected abstract Vector getListOfRequiredCommandLineArguments();

    protected abstract Vector getListOfOptionalCommandLineArguments();

    protected String getFunctionalDescription() {
        return ResourceBundleUtils.getLocaleString(S_WSPROFILE + this.getClass().getSimpleName() + S_FUNTIONAL_DESCRIPTION);
    }

    public boolean isArgumentRequired(String s_arg) {
        Vector v_required_args = this.getListOfRequiredCommandLineArguments();
        for (int i = 0; i < v_required_args.size(); ++i) {
            CommandLineArgument cla = (CommandLineArgument)v_required_args.get(i);
            if (!cla.getKey().equals(s_arg)) continue;
            return true;
        }
        return false;
    }

    public boolean isArgumentOptional(String s_arg) {
        Vector v_optional_args = this.getListOfOptionalCommandLineArguments();
        for (int i = 0; i < v_optional_args.size(); ++i) {
            CommandLineArgument cla = (CommandLineArgument)v_optional_args.get(i);
            if (!cla.getKey().equals(s_arg)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean isPublicMode();

    protected final Vector getIncomingCommandLineArguments() {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "getIncomingCommandLineArguments");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getIncomingCommandLineArguments", "Parsed incoming command line arguments were: " + this.m_vclaIncomingCommandLineArguments.toArray());
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "getIncomingCommandLineArguments");
        return this.m_vclaIncomingCommandLineArguments;
    }

    protected final boolean isArgumentPresent(String sKey) {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "isArgumentPresent");
        if (this.getArgumentValue(sKey) != null) {
            LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "isArgumentPresent");
            return true;
        }
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "isArgumentPresent");
        return false;
    }

    protected final String getArgumentValue(String sKey) {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "getArgumentValue");
        for (int i = 0; i < this.m_vclaIncomingCommandLineArguments.size(); ++i) {
            CommandLineArgument claThis = (CommandLineArgument)this.m_vclaIncomingCommandLineArguments.elementAt(i);
            if (!claThis.getKey().equals(sKey)) continue;
            String sValue = S_EMPTY;
            if (claThis.getArgumentValues().size() > 0) {
                sValue = (String)claThis.getArgumentValues().elementAt(0);
            }
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getArgumentValue", sKey + " was resolved to " + sValue);
            LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "getArgumentValue");
            return sValue;
        }
        LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getArgumentValue", "Could not resolve " + sKey + " from command line");
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "getArgumentValue");
        return null;
    }

    protected final File getProfileRegistryPath() throws WSProfileException {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "getProfileRegistryPath");
        String sProfileRegistryPath = this.getArgumentValue("registry");
        if (sProfileRegistryPath == null) {
            sProfileRegistryPath = WSProfile.getRegistryFile().getAbsolutePath();
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getProfileRegistryPath", "Profile registry being used is: " + sProfileRegistryPath);
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "getProfileRegistryPath");
        try {
            return new File(sProfileRegistryPath).getCanonicalFile();
        }
        catch (IOException e) {
            LogUtils.logException(LOGGER, e);
            throw new WSProfileException(S_PROFILE_REGISTRY_ACCESS_FAILED + sProfileRegistryPath, ResourceBundleUtils.getLocaleString(S_PROFILE_REGISTRY_ACCESS_FAILED_KEY, sProfileRegistryPath), true);
        }
    }

    protected final boolean areCommandLineArgumentsValid() {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "validateArguments");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "areCommandLineArgumentsValid", "Validating command line arguments.");
        Hashtable<String, Object> hashtableCommandLineArguments = new Hashtable<String, Object>();
        Properties props = com.ibm.ws.install.configmanager.utils.SystemPropertiesUtils.getCurrentSystemProperties();
        for (int i = 0; i < this.m_vclaIncomingCommandLineArguments.size(); ++i) {
            CommandLineArgument claCurrent = (CommandLineArgument)this.m_vclaIncomingCommandLineArguments.get(i);
            hashtableCommandLineArguments.put(claCurrent.getKey(), claCurrent.getArgumentValues());
            if (!claCurrent.getKey().equals("templatePath") || claCurrent.getArgumentValues().size() < 1 || (String)claCurrent.getArgumentValues().firstElement() == null || ((String)claCurrent.getArgumentValues().firstElement()).equals(S_EMPTY) || this.getRegistryName() == null) continue;
            File fileThisTemplate = new File((String)claCurrent.getArgumentValues().firstElement());
            System.setProperty("WS_CMT_CONF_DIR", fileThisTemplate.getAbsolutePath());
            System.setProperty("WS_CMT_ACTION_REGISTRY", new File(fileThisTemplate.getAbsoluteFile(), this.getRegistryName()).getAbsolutePath());
            System.setProperty(this.getModeFlag(), S_EMPTY);
        }
        hashtableCommandLineArguments.put(this.getModeFlag(), S_EMPTY);
        boolean fAreCommandLineArgsValid = ValidationManagerUtils.areAllArgumentsValid(hashtableCommandLineArguments);
        com.ibm.ws.install.configmanager.utils.SystemPropertiesUtils.resetSystemProperties(props);
        if (!fAreCommandLineArgsValid) {
            Hashtable hashtableValidationError = ValidationManagerUtils.getAllErrorMessages();
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "areCommandLineArgumentsValid", "Validation Failed");
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_VALIDATION_ERROR_KEY));
            Enumeration enumArgKeys = hashtableValidationError.keys();
            while (enumArgKeys.hasMoreElements()) {
                String sArgumentKey = (String)enumArgKeys.nextElement();
                List listValidationErrors = (List)hashtableValidationError.get(sArgumentKey);
                for (int j = 0; j < listValidationErrors.size(); ++j) {
                    LOGGER.logp(Level.INFO, S_CLASS_NAME, "areCommandLineArgumentsValid", "Validation Error for " + sArgumentKey + ": " + listValidationErrors.get(j));
                    String sRawMessage = (String)listValidationErrors.get(j);
                    String sFormatedMessage = MessageFormat.format(sRawMessage, sArgumentKey);
                    OutputStreamHandler.println("\t" + sArgumentKey + ": " + sFormatedMessage);
                }
            }
            return false;
        }
        return true;
    }

    protected void doHelp() {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "doHelp");
        OutputStreamHandler.setTabSize(3);
        this.doHelpPrintFunctionalDescription();
        this.doHelpPrintSyntax();
        this.doHelpPrintTemplateInfo();
        this.doHelpPrintAllArguments();
        this.doHelpPrintNotes();
        OutputStreamHandler.setDefaultTabSize();
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "doHelp");
    }

    protected void doHelpPrintFunctionalDescription() {
        OutputStreamHandler.println(S_EMPTY);
        OutputStreamHandler.printlnTabbed(1, "Function:");
        OutputStreamHandler.printlnTabbed(2, this.getFunctionalDescription() + S_NEWLINE);
    }

    protected void doHelpPrintAvailableModes() {
        for (int i = 0; i < aclassRegisteredInvokers.length; ++i) {
            Class classInvokerThis = aclassRegisteredInvokers[i];
            try {
                WSProfileCLIModeInvoker wspclimiThis = (WSProfileCLIModeInvoker)classInvokerThis.newInstance();
                if (!wspclimiThis.isPublicMode()) continue;
                OutputStreamHandler.printlnTabbed(2, wspclimiThis.getModeFlag());
                continue;
            }
            catch (IllegalAccessException e) {
                LogUtils.logException(LOGGER, e);
                LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "doHelpMode");
                continue;
            }
            catch (InstantiationException e) {
                LogUtils.logException(LOGGER, e);
                LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "doHelpMode");
            }
        }
        OutputStreamHandler.println(S_EMPTY);
    }

    protected void doHelpPrintSyntax() {
        OutputStreamHandler.printlnTabbed(1, "Syntax:");
        if (this.getListOfOptionalCommandLineArguments().size() == 0 && this.getListOfRequiredCommandLineArguments().size() == 1) {
            OutputStreamHandler.printlnTabbed(2, "manageprofiles -" + this.getModeFlag() + S_NEWLINE);
        } else {
            OutputStreamHandler.printlnTabbed(2, "manageprofiles -" + this.getModeFlag() + S_SPACE + S_ARGUMENT_SYNTAX + S_NEWLINE);
        }
    }

    protected void doHelpPrintTemplateInfo() {
        if (WSProfileDataStore.getFlowControllingModeInvoker().isTemplateStackRequired() && WSProfileDataStore.isArgSpecified("templatePath")) {
            String sTemplatePath = WSProfileDataStore.getFlowControllingArgumentValue("templatePath");
            try {
                String sTemplateInfo;
                WSProfileTemplate wspt = new WSProfileTemplate(sTemplatePath);
                ResourceBundle resourceBundle = wspt.getResourceBundle();
                if (resourceBundle != null && (sTemplateInfo = ResourceBundleUtils.getResourceBundleLocaleString(S_KEY_TEMPLATE_NOTES, resourceBundle)) != null && sTemplateInfo != S_KEY_TEMPLATE_NOTES) {
                    OutputStreamHandler.printlnTabbed(1, S_TEMPLATE_INFO_TAG);
                    OutputStreamHandler.printlnTabbed(2, sTemplateInfo + S_NEWLINE);
                }
            }
            catch (WSProfileException wspe) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "doHelpTemplateInfo", "The template located at " + sTemplatePath + " is not a valid profile template. " + "Only mode specifid help will be printed.");
            }
        }
    }

    protected void doHelpPrintRequiredArguments() {
        boolean fPrintLine = false;
        Vector vclaArgumentsRequired = WSProfileDataStore.getFlowControllingModeInvoker().getListOfNonDefaultableRequiredCommandLineArguments();
        OutputStreamHandler.printlnTabbed(1, "Arguments:\n");
        OutputStreamHandler.printlnTabbed(2, ResourceBundleUtils.getLocaleString("WSProfile.WSProfileCLIModeInvoker.genericHelpProlog") + S_NEWLINE);
        for (int i = 0; i < vclaArgumentsRequired.size(); ++i) {
            CommandLineArgument claThis = (CommandLineArgument)vclaArgumentsRequired.elementAt(i);
            if (!claThis.isVisible() || claThis.getKey().equals(this.getModeFlag())) continue;
            fPrintLine = true;
            String argumentHelpBundle = claThis.getArgumentHelpBundle();
            if (argumentHelpBundle == null) {
                argumentHelpBundle = "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle";
            }
            OutputStreamHandler.printlnTabbed(3, S_DASH + claThis.getKey() + S_SPACE + S_ARGUMENT_PARAMETER + S_COLON + S_SPACE + ResourceBundleUtils.getResourceBundleLocaleString(claThis.getKey() + S_CLA_RESOURCE_BUNDLE_HELP_KEY_POSTFIX, argumentHelpBundle));
        }
        if (fPrintLine) {
            OutputStreamHandler.println(S_EMPTY);
        }
    }

    protected void doHelpPrintRequiredDefaultableArguments() {
        boolean fPrintLine = false;
        Vector vclaArgumentsOptionalWithDefaulters = WSProfileDataStore.getFlowControllingModeInvoker().getListOfDefaultableCommandLineArguments();
        if (vclaArgumentsOptionalWithDefaulters.size() > 0 && this.isAnyArgumentVisible(vclaArgumentsOptionalWithDefaulters)) {
            OutputStreamHandler.printlnTabbed(2, ResourceBundleUtils.getLocaleString("WSProfile.WSProfileCLIModeInvoker.requiredDefaultableArgsHelpProlog") + S_NEWLINE);
            for (int i = 0; i < vclaArgumentsOptionalWithDefaulters.size(); ++i) {
                CommandLineArgument claThis = (CommandLineArgument)vclaArgumentsOptionalWithDefaulters.elementAt(i);
                if (!claThis.isVisible()) continue;
                fPrintLine = true;
                String argumentHelpBundle = claThis.getArgumentHelpBundle();
                if (argumentHelpBundle == null) {
                    argumentHelpBundle = "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle";
                }
                OutputStreamHandler.printlnTabbed(3, S_DASH + claThis.getKey() + S_COLON + S_SPACE + ResourceBundleUtils.getResourceBundleLocaleString(claThis.getKey() + S_CLA_RESOURCE_BUNDLE_HELP_KEY_POSTFIX, argumentHelpBundle));
            }
        }
        if (fPrintLine) {
            OutputStreamHandler.println(S_EMPTY);
        }
    }

    protected void doHelpPrintOptionalArguments() {
        boolean fPrintLine = false;
        Vector vclaArgumentsOptionalWithoutDefaulters = WSProfileDataStore.getFlowControllingModeInvoker().getListOfNonDefaultableCommandLineArguments();
        if (vclaArgumentsOptionalWithoutDefaulters.size() > 0 && this.isAnyArgumentVisible(vclaArgumentsOptionalWithoutDefaulters)) {
            OutputStreamHandler.printlnTabbed(2, ResourceBundleUtils.getLocaleString("WSProfile.WSProfileCLIModeInvoker.optionalNonDefaultableArgsHelpProlog") + S_NEWLINE);
            for (int i = 0; i < vclaArgumentsOptionalWithoutDefaulters.size(); ++i) {
                CommandLineArgument claThis = (CommandLineArgument)vclaArgumentsOptionalWithoutDefaulters.elementAt(i);
                if (!claThis.isVisible()) continue;
                fPrintLine = true;
                String argumentHelpBundle = claThis.getArgumentHelpBundle();
                if (argumentHelpBundle == null) {
                    argumentHelpBundle = "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle";
                }
                OutputStreamHandler.printlnTabbed(3, S_DASH + claThis.getKey() + S_SPACE + S_ARGUMENT_PARAMETER + S_COLON + S_SPACE + ResourceBundleUtils.getResourceBundleLocaleString(claThis.getKey() + S_CLA_RESOURCE_BUNDLE_HELP_KEY_POSTFIX, argumentHelpBundle));
            }
        }
        if (fPrintLine) {
            OutputStreamHandler.println(S_EMPTY);
        }
    }

    protected void doHelpPrintAllArguments() {
        this.doHelpPrintRequiredArguments();
        this.doHelpPrintRequiredDefaultableArguments();
        this.doHelpPrintOptionalArguments();
    }

    protected void doHelpPrintRemoteArguments() {
        OutputStreamHandler.printlnTabbed(2, ResourceBundleUtils.getLocaleString("WSProfile.WSProfileCLIModeInvoker.remoteArgsHelpProlog") + S_NEWLINE);
        String[] args = WSProfileConstants.AS_REMOTE_ARGS;
        for (int i = 0; i < args.length; ++i) {
            OutputStreamHandler.printlnTabbed(3, S_DASH + args[i] + S_COLON + S_SPACE + ResourceBundleUtils.getResourceBundleLocaleString(args[i] + S_CLA_RESOURCE_BUNDLE_HELP_KEY_POSTFIX, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"));
        }
        OutputStreamHandler.println(S_EMPTY);
    }

    protected void doHelpPrintNotes() {
        OutputStreamHandler.printTabbed(1, ResourceBundleUtils.getLocaleString("Note:"));
        OutputStreamHandler.println(S_SPACE + ResourceBundleUtils.getLocaleString(S_NOTES_CASE_SENSITIVE_ARGS_KEY));
        OutputStreamHandler.printTabbed(1, ResourceBundleUtils.getLocaleString("Note:"));
        OutputStreamHandler.println(S_SPACE + ResourceBundleUtils.getLocaleString(S_NOTES_SPACE_IN_ARG));
        OutputStreamHandler.printTabbed(1, ResourceBundleUtils.getLocaleString("Note:"));
        OutputStreamHandler.println(S_SPACE + ResourceBundleUtils.getLocaleString(S_NOTES_DEFAULT_TEMPLATE, WSProfileUtils.getDefaultTemplateName()));
        if (WSProfileDataStore.getFlowControllingModeInvoker() instanceof WSProfileCLIHelpInvoker) {
            OutputStreamHandler.printTabbed(1, ResourceBundleUtils.getLocaleString("Note:"));
            OutputStreamHandler.println(S_SPACE + ResourceBundleUtils.getLocaleString(S_NOTES_MODE_ARGS_KEY));
        } else if (WSProfileDataStore.getFlowControllingModeInvoker().isTemplateStackRequired() && !WSProfileDataStore.isArgSpecified("templatePath")) {
            OutputStreamHandler.printTabbed(1, ResourceBundleUtils.getLocaleString("Note:"));
            OutputStreamHandler.println(S_SPACE + ResourceBundleUtils.getLocaleString(S_NOTES_TEMPLATE_HELP_KEY));
        }
        if (WSProfileDataStore.getFlowControllingModeInvoker().isTemplateStackRequired() && WSProfileDataStore.isArgSpecified("templatePath")) {
            OutputStreamHandler.printTabbed(1, ResourceBundleUtils.getLocaleString("Note:"));
            OutputStreamHandler.println(S_SPACE + ResourceBundleUtils.getLocaleString(S_NOTES_PATH_KEY));
        }
    }

    public Vector getListOfAllCommandLineArguments() {
        Vector vclaAllCommandLineArguments = this.getListOfRequiredCommandLineArguments();
        vclaAllCommandLineArguments.addAll(this.getListOfOptionalCommandLineArguments());
        return vclaAllCommandLineArguments;
    }

    protected Properties setJavaSystemPropertiesForConfigManagerArgumentRetrieval() {
        return SystemPropertiesUtils.setJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap(CommandLineArgument.convertCommandLineArgumentListToMap(this.getIncomingCommandLineArguments()));
    }

    protected void resetJavaSystemProperties(Properties previousSystemProperties) {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "resetJavaSystemProperties");
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "resetJavaSystemProperties");
        SystemPropertiesUtils.resetJavaSystemProperties(previousSystemProperties);
    }

    protected Vector mergeCommandLineArgs(List listOriginalArgs, List listAdditionalArgs) {
        Vector<CommandLineArgument> vclaMergedArgs = new Vector<CommandLineArgument>(listOriginalArgs);
        for (int i = 0; i < listAdditionalArgs.size(); ++i) {
            CommandLineArgument claTemplate = (CommandLineArgument)listAdditionalArgs.get(i);
            int nIndex = vclaMergedArgs.indexOf(claTemplate);
            if (nIndex != -1) {
                CommandLineArgument claLocal = (CommandLineArgument)vclaMergedArgs.get(nIndex);
                CommandLineArgument claArgToReplace = CommandLineArgument.mergeArguments(claLocal, claTemplate);
                vclaMergedArgs.remove(claLocal);
                vclaMergedArgs.add(claArgToReplace);
                continue;
            }
            vclaMergedArgs.add(claTemplate);
        }
        return vclaMergedArgs;
    }

    private static boolean checkIfCommandLineIsSufficientForThisMode(Vector vclaIncomingCommandLineArguments, Vector vclaExpectedCommandLineArguments) {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "checkIfCommandLineIsSufficientForThisMode");
        for (int i = 0; i < vclaExpectedCommandLineArguments.size(); ++i) {
            CommandLineArgument claExpectedThis = (CommandLineArgument)vclaExpectedCommandLineArguments.elementAt(i);
            if (CommandLineArgument.isThisArgumentPresentInThisExpectedList(claExpectedThis, vclaIncomingCommandLineArguments) || claExpectedThis.getDefaulter() != null) continue;
            LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "checkIfCommandLineIsSufficientForThisMode");
            return false;
        }
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "checkIfCommandLineIsSufficientForThisMode");
        return true;
    }

    private Vector getListOfNonDefaultableCommandLineArguments() {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "getListOfNonDefaultableRequiredCommandLineArguments");
        Vector vclaCommandLineArguments = this.getListOfOptionalCommandLineArguments();
        Vector<CommandLineArgument> listArguments = new Vector<CommandLineArgument>();
        for (int i = 0; i < vclaCommandLineArguments.size(); ++i) {
            CommandLineArgument claExpectedThis = (CommandLineArgument)vclaCommandLineArguments.elementAt(i);
            if (claExpectedThis.getDefaulter() != null || this.getListOfDefaultableCommandLineArguments().contains(claExpectedThis)) continue;
            listArguments.add(claExpectedThis);
        }
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "getListOfNonDefaultableRequiredCommandLineArguments");
        return listArguments;
    }

    private Vector getListOfDefaultableCommandLineArguments() {
        CommandLineArgument claExpectedThis;
        int i;
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "getListOfDefaultableCommandLineArguments");
        Vector vclaRequiredCommandLineArguments = this.getListOfRequiredCommandLineArguments();
        Vector vclaOptionalCommandLineArguments = this.getListOfOptionalCommandLineArguments();
        Vector<CommandLineArgument> listArgumentsToDefault = new Vector<CommandLineArgument>();
        for (i = 0; i < vclaRequiredCommandLineArguments.size(); ++i) {
            claExpectedThis = (CommandLineArgument)vclaRequiredCommandLineArguments.elementAt(i);
            if (claExpectedThis.getDefaulter() == null) continue;
            listArgumentsToDefault.add(claExpectedThis);
        }
        for (i = 0; i < vclaOptionalCommandLineArguments.size(); ++i) {
            claExpectedThis = (CommandLineArgument)vclaOptionalCommandLineArguments.elementAt(i);
            if (claExpectedThis.getDefaulter() == null) continue;
            listArgumentsToDefault.add(claExpectedThis);
        }
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "getListOfDefaultableCommandLineArguments");
        return listArgumentsToDefault;
    }

    private Vector getListOfNonDefaultableRequiredCommandLineArguments() {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "getListOfNonDefaultableRequiredCommandLineArguments");
        Vector vclaCommandLineArguments = this.getListOfRequiredCommandLineArguments();
        Vector<CommandLineArgument> listArguments = new Vector<CommandLineArgument>();
        for (int i = 0; i < vclaCommandLineArguments.size(); ++i) {
            CommandLineArgument claExpectedThis = (CommandLineArgument)vclaCommandLineArguments.elementAt(i);
            if (claExpectedThis.getDefaulter() != null) continue;
            listArguments.add(claExpectedThis);
        }
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "getListOfNonDefaultableRequiredCommandLineArguments");
        return listArguments;
    }

    private boolean isAnyArgumentVisible(Vector vclaArguments) {
        if (vclaArguments != null && vclaArguments.size() > 0) {
            for (int i = 0; i < vclaArguments.size(); ++i) {
                CommandLineArgument claThis = (CommandLineArgument)vclaArguments.elementAt(i);
                if (!claThis.isVisible()) continue;
                return true;
            }
        }
        return false;
    }
}

